/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.querying.QueryNodeWithPlaceHolders;
import org.verdictdb.core.querying.SubscriptionTicket;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AliasedColumn;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.exception.VerdictDBException;

class LargeGroupSizeNode
extends QueryNodeWithPlaceHolders {
    private static final long serialVersionUID = -7863166573727173728L;
    private String primaryColumnName;
    public static final String LARGE_GROUP_SIZE_SUM_ALIAS = "largeGroupSizeSum";

    public LargeGroupSizeNode(String primaryColumnName) {
        super(null);
        this.primaryColumnName = primaryColumnName;
    }

    @Override
    public SqlConvertible createQuery(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        String tableSourceAlias = "t";
        String aliasName = LARGE_GROUP_SIZE_SUM_ALIAS;
        String groupSizeAlias = "groupSize";
        Pair<BaseTable, SubscriptionTicket> placeholder = this.createPlaceHolderTable(tableSourceAlias);
        BaseTable baseTable = (BaseTable)placeholder.getLeft();
        this.selectQuery = SelectQuery.create(new AliasedColumn(ColumnOp.sum(new BaseColumn(tableSourceAlias, groupSizeAlias)), aliasName), (AbstractRelation)baseTable);
        super.createQuery(tokens);
        return this.selectQuery;
    }

    @Override
    public ExecutionInfoToken createToken(DbmsQueryResult result) {
        ExecutionInfoToken token = new ExecutionInfoToken();
        token.setKeyValue(this.getClass().getSimpleName(), result);
        return token;
    }
}

