/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.querying.CreateTableAsSelectNode;
import org.verdictdb.core.querying.IdCreator;
import org.verdictdb.core.scrambling.PercentilesAndCountNode;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AliasReference;
import org.verdictdb.core.sqlobject.AliasedColumn;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.ConstantColumn;
import org.verdictdb.core.sqlobject.SelectItem;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.exception.VerdictDBException;

class LargeGroupListNode
extends CreateTableAsSelectNode {
    private static final long serialVersionUID = -2889642011123433574L;
    private double p0 = 0.001;
    private String schemaName;
    private String tableName;
    private String primaryColumnName;
    private long blockSize;
    public static final String PRIMARY_GROUP_RENAME = "verdictdbrenameprimarygroup";
    public static final String LARGE_GROUP_SIZE_COLUMN_ALIAS = "groupSize";

    public LargeGroupListNode(IdCreator idCreator, String schemaName, String tableName, String primaryColumnName, long blockSize) {
        super(idCreator, null);
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.primaryColumnName = primaryColumnName;
        this.blockSize = blockSize;
    }

    @Override
    public SqlConvertible createQuery(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        String tableSourceAlias = "t";
        String countNodeKey = PercentilesAndCountNode.class.getSimpleName();
        long tableSize = -1L;
        for (ExecutionInfoToken token : tokens) {
            if (!token.containsKey(countNodeKey)) continue;
            DbmsQueryResult tableSizeResult = (DbmsQueryResult)token.getValue(countNodeKey);
            tableSizeResult.rewind();
            tableSizeResult.next();
            tableSize = tableSizeResult.getLong("verdictdbtotalcount");
            break;
        }
        if (tableSize == 0L) {
            this.p0 = 1.0;
        } else if (tableSize != -1L) {
            this.p0 = Math.min(1.0, (double)this.blockSize / (double)tableSize);
        }
        ArrayList<SelectItem> selectList = new ArrayList<SelectItem>();
        selectList.add(new AliasedColumn(new BaseColumn(tableSourceAlias, this.primaryColumnName), PRIMARY_GROUP_RENAME));
        selectList.add(new AliasedColumn(ColumnOp.multiply(ColumnOp.count(), ColumnOp.divide(ConstantColumn.valueOf(1.0), ConstantColumn.valueOf(this.p0))), LARGE_GROUP_SIZE_COLUMN_ALIAS));
        SelectQuery selectQuery = SelectQuery.create(selectList, (AbstractRelation)new BaseTable(this.schemaName, this.tableName, tableSourceAlias));
        selectQuery.addFilterByAnd(ColumnOp.less(ColumnOp.rand(), ConstantColumn.valueOf(this.p0)));
        selectQuery.addGroupby(new AliasReference(this.primaryColumnName));
        this.selectQuery = selectQuery;
        return super.createQuery(tokens);
    }

    @Override
    public ExecutionInfoToken createToken(DbmsQueryResult result) {
        ExecutionInfoToken token = super.createToken(result);
        Pair fullTableName = Pair.of((Object)((String)token.getValue("schemaName")), (Object)((String)token.getValue("tableName")));
        token.setKeyValue(this.getClass().getSimpleName(), fullTableName);
        return token;
    }
}

