/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.querying.TempIdCreatorInScratchpadSchema;
import org.verdictdb.core.scrambling.LargeGroupListNode;
import org.verdictdb.core.scrambling.LargeGroupSizeNode;
import org.verdictdb.core.scrambling.OutlierProportionNode;
import org.verdictdb.core.scrambling.PercentilesAndCountNode;
import org.verdictdb.core.scrambling.ScramblingMethodBase;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.ConstantColumn;
import org.verdictdb.core.sqlobject.JoinTable;
import org.verdictdb.core.sqlobject.UnnamedColumn;

public class FastConvergeScramblingMethod
extends ScramblingMethodBase {
    double p0 = 0.5;
    double p1 = 0.8;
    static final double OUTLIER_STDDEV_MULTIPLIER = 3.09;
    Optional<String> primaryColumnName = Optional.absent();
    private String scratchpadSchemaName;
    List<Double> tier0CumulProbDist = null;
    List<Double> tier1CumulProbDist = null;
    List<Double> tier2CumulProbDist = null;
    private long outlierSize = 0L;
    private long smallGroupSizeSum = 0L;
    public static final String MAIN_TABLE_SOURCE_ALIAS_NAME = "t1";
    public static final String RIGHT_TABLE_SOURCE_ALIAS_NAME = "t2";
    private int totalNumberOfblocks = -1;

    public FastConvergeScramblingMethod(long blockSize, String scratchpadSchemaName) {
        super(blockSize);
        this.scratchpadSchemaName = scratchpadSchemaName;
    }

    public FastConvergeScramblingMethod(long blockSize, String scratchpadSchemaName, String primaryColumnName) {
        this(blockSize, scratchpadSchemaName);
        this.primaryColumnName = Optional.of((Object)primaryColumnName);
    }

    @Override
    public List<ExecutableNodeBase> getStatisticsNode(String oldSchemaName, String oldTableName, String columnMetaTokenKey, String partitionMetaTokenKey) {
        ArrayList<ExecutableNodeBase> statisticsNodes = new ArrayList<ExecutableNodeBase>();
        PercentilesAndCountNode pc = new PercentilesAndCountNode(oldSchemaName, oldTableName, columnMetaTokenKey, partitionMetaTokenKey, this.primaryColumnName);
        statisticsNodes.add(pc);
        OutlierProportionNode op = new OutlierProportionNode(oldSchemaName, oldTableName);
        op.subscribeTo(pc);
        statisticsNodes.add(op);
        if (this.primaryColumnName.isPresent()) {
            TempIdCreatorInScratchpadSchema idCreator = new TempIdCreatorInScratchpadSchema(this.scratchpadSchemaName);
            LargeGroupListNode ll = new LargeGroupListNode(idCreator, oldSchemaName, oldTableName, (String)this.primaryColumnName.get(), this.blockSize);
            ll.subscribeTo(pc, 0);
            LargeGroupSizeNode ls = new LargeGroupSizeNode((String)this.primaryColumnName.get());
            ls.subscribeTo(ll, 0);
            statisticsNodes.add(ll);
            statisticsNodes.add(ls);
        }
        return statisticsNodes;
    }

    static UnnamedColumn createOutlierTuplePredicate(DbmsQueryResult percentileAndCountResult, String sourceTableAlias) {
        ColumnOp outlierPredicate = null;
        percentileAndCountResult.rewind();
        percentileAndCountResult.next();
        for (int i = 0; i < percentileAndCountResult.getColumnCount(); ++i) {
            String columnName = percentileAndCountResult.getColumnName(i);
            if (columnName.startsWith("verdictdbavg")) {
                String originalColumnName = columnName.substring("verdictdbavg".length());
                double columnAverage = percentileAndCountResult.getDouble(i);
                double columnStddev = percentileAndCountResult.getDouble(i + 1);
                double lowCriteria = columnAverage - columnStddev * 3.09;
                double highCriteria = columnAverage + columnStddev * 3.09;
                ColumnOp newOrPredicate = ColumnOp.or(ColumnOp.less(new BaseColumn(sourceTableAlias, originalColumnName), ConstantColumn.valueOf(lowCriteria)), ColumnOp.greater(new BaseColumn(sourceTableAlias, originalColumnName), ConstantColumn.valueOf(highCriteria)));
                outlierPredicate = outlierPredicate == null ? newOrPredicate : ColumnOp.or(outlierPredicate, newOrPredicate);
            }
            if (!columnName.equals("verdictdbtotalcount")) continue;
        }
        return outlierPredicate;
    }

    @Override
    public List<UnnamedColumn> getTierExpressions(Map<String, Object> metaData) {
        ColumnOp tier1Predicate;
        DbmsQueryResult percentileAndCountResult = (DbmsQueryResult)metaData.get(PercentilesAndCountNode.class.getSimpleName());
        UnnamedColumn tier0Predicate = FastConvergeScramblingMethod.createOutlierTuplePredicate(percentileAndCountResult, MAIN_TABLE_SOURCE_ALIAS_NAME);
        if (!this.primaryColumnName.isPresent()) {
            tier1Predicate = ColumnOp.equal(ConstantColumn.valueOf(0), ConstantColumn.valueOf(1));
        } else {
            String rightTableSourceAlias = RIGHT_TABLE_SOURCE_ALIAS_NAME;
            tier1Predicate = ColumnOp.rightisnull(new BaseColumn(rightTableSourceAlias, "verdictdbrenameprimarygroup"));
        }
        return Arrays.asList(tier0Predicate, tier1Predicate);
    }

    @Override
    public List<Double> getCumulativeProbabilityDistributionForTier(Map<String, Object> metaData, int tier) {
        if (this.tier0CumulProbDist == null) {
            this.populateAllCumulativeProbabilityDistribution(metaData);
        }
        List<Double> dist = tier == 0 ? this.tier0CumulProbDist : (tier == 1 ? this.tier1CumulProbDist : this.tier2CumulProbDist);
        this.storeCumulativeProbabilityDistribution(tier, dist);
        return dist;
    }

    private void populateAllCumulativeProbabilityDistribution(Map<String, Object> metaData) {
        this.populateTier0CumulProbDist(metaData);
        this.populateTier1CumulProbDist(metaData);
        this.populateTier2CumulProbDist(metaData);
    }

    private void populateTier0CumulProbDist(Map<String, Object> metaData) {
        ArrayList<Double> cumulProbDist = new ArrayList<Double>();
        Pair<Long, Integer> tableSizeAndBlockNumber = this.retrieveTableSizeAndBlockNumber(metaData);
        long tableSize = (Long)tableSizeAndBlockNumber.getLeft();
        int totalNumberOfblocks = (Integer)tableSizeAndBlockNumber.getRight();
        DbmsQueryResult outlierProportion = (DbmsQueryResult)metaData.get(OutlierProportionNode.class.getSimpleName());
        outlierProportion.rewind();
        outlierProportion.next();
        this.outlierSize = outlierProportion.getLong(0);
        if (this.outlierSize * 2L >= tableSize) {
            for (int i = 0; i < totalNumberOfblocks; ++i) {
                cumulProbDist.add((double)(i + 1) / (double)totalNumberOfblocks);
            }
        } else {
            Long remainingSize = this.outlierSize;
            while (this.outlierSize > 0L && remainingSize > 0L) {
                if ((double)remainingSize.longValue() <= this.p0 * (double)this.blockSize) {
                    cumulProbDist.add(1.0);
                    break;
                }
                long thisBlockSize = (long)((double)this.blockSize * this.p0);
                double ratio = thisBlockSize / this.outlierSize;
                if (cumulProbDist.size() == 0) {
                    cumulProbDist.add(ratio);
                } else {
                    cumulProbDist.add((Double)cumulProbDist.get(cumulProbDist.size() - 1) + ratio);
                }
                remainingSize = remainingSize - thisBlockSize;
            }
            while (cumulProbDist.size() < totalNumberOfblocks) {
                cumulProbDist.add(1.0);
            }
        }
        this.tier0CumulProbDist = cumulProbDist;
    }

    private void populateTier1CumulProbDist(Map<String, Object> metaData) {
        ArrayList<Double> cumulProbDist = new ArrayList<Double>();
        Pair<Long, Integer> tableSizeAndBlockNumber = this.retrieveTableSizeAndBlockNumber(metaData);
        long tableSize = (Long)tableSizeAndBlockNumber.getLeft();
        int totalNumberOfblocks = (Integer)tableSizeAndBlockNumber.getRight();
        if (!this.primaryColumnName.isPresent()) {
            while (cumulProbDist.size() < totalNumberOfblocks) {
                cumulProbDist.add(1.0);
            }
        } else {
            int i;
            DbmsQueryResult largeGroupSizeResult = (DbmsQueryResult)metaData.get(LargeGroupSizeNode.class.getSimpleName());
            largeGroupSizeResult.rewind();
            largeGroupSizeResult.next();
            long largeGroupSizeSum = largeGroupSizeResult.getLong(0);
            this.smallGroupSizeSum = tableSize - largeGroupSizeSum;
            long totalRemainingSizeUnderP1 = 0L;
            for (i = 0; i < this.tier0CumulProbDist.size(); ++i) {
                totalRemainingSizeUnderP1 = i == 0 ? (long)((double)totalRemainingSizeUnderP1 + ((double)this.blockSize * this.p1 - (double)this.outlierSize * this.tier0CumulProbDist.get(i))) : (long)((double)totalRemainingSizeUnderP1 + ((double)this.blockSize * this.p1 - (double)this.outlierSize * (this.tier0CumulProbDist.get(i) - this.tier0CumulProbDist.get(i - 1))));
            }
            if (this.smallGroupSizeSum >= totalRemainingSizeUnderP1) {
                for (i = 0; i < totalNumberOfblocks; ++i) {
                    cumulProbDist.add((double)(i + 1) / (double)totalNumberOfblocks);
                }
            } else {
                long thisBlockSize;
                for (long remainingSize = this.smallGroupSizeSum; remainingSize > 0L; remainingSize -= thisBlockSize) {
                    if ((double)remainingSize <= (this.p1 - this.p0) * (double)this.blockSize) {
                        cumulProbDist.add(1.0);
                        break;
                    }
                    thisBlockSize = (long)((double)this.blockSize * (this.p1 - this.p0));
                    double ratio = thisBlockSize / this.smallGroupSizeSum;
                    if (cumulProbDist.size() == 0) {
                        cumulProbDist.add(ratio);
                        continue;
                    }
                    cumulProbDist.add((Double)cumulProbDist.get(cumulProbDist.size() - 1) + ratio);
                }
                while (cumulProbDist.size() < totalNumberOfblocks) {
                    cumulProbDist.add(1.0);
                }
            }
        }
        this.tier1CumulProbDist = cumulProbDist;
    }

    private void populateTier2CumulProbDist(Map<String, Object> metaData) {
        ArrayList<Double> cumulProbDist = new ArrayList<Double>();
        Pair<Long, Integer> tableSizeAndBlockNumber = this.retrieveTableSizeAndBlockNumber(metaData);
        long tableSize = (Long)tableSizeAndBlockNumber.getLeft();
        int totalNumberOfblocks = (Integer)tableSizeAndBlockNumber.getRight();
        long tier2Size = tableSize - this.outlierSize - this.smallGroupSizeSum;
        for (int i = 0; i < totalNumberOfblocks; ++i) {
            long thisTier1Size;
            long thisTier0Size;
            if (i == 0) {
                thisTier0Size = (long)((double)this.outlierSize * this.tier0CumulProbDist.get(i));
                thisTier1Size = (long)((double)this.smallGroupSizeSum * this.tier1CumulProbDist.get(i));
            } else {
                thisTier0Size = (long)((double)this.outlierSize * (this.tier0CumulProbDist.get(i) - this.tier0CumulProbDist.get(i - 1)));
                thisTier1Size = (long)((double)this.smallGroupSizeSum * (this.tier1CumulProbDist.get(i) - this.tier1CumulProbDist.get(i - 1)));
            }
            long thisBlockSize = this.blockSize - thisTier0Size - thisTier1Size;
            if (tier2Size == 0L) {
                cumulProbDist.add(1.0);
                continue;
            }
            double thisBlockRatio = (double)thisBlockSize / (double)tier2Size;
            if (i == 0) {
                cumulProbDist.add(thisBlockRatio);
                continue;
            }
            cumulProbDist.add((Double)cumulProbDist.get(i - 1) + thisBlockRatio);
        }
        this.tier2CumulProbDist = cumulProbDist;
    }

    private Pair<Long, Integer> retrieveTableSizeAndBlockNumber(Map<String, Object> metaData) {
        DbmsQueryResult tableSizeResult = (DbmsQueryResult)metaData.get(PercentilesAndCountNode.class.getSimpleName());
        tableSizeResult.rewind();
        tableSizeResult.next();
        long tableSize = tableSizeResult.getLong("verdictdbtotalcount");
        this.totalNumberOfblocks = (int)Math.ceil((float)tableSize / (float)this.blockSize);
        return Pair.of((Object)tableSize, (Object)this.totalNumberOfblocks);
    }

    @Override
    public AbstractRelation getScramblingSource(String originalSchema, String originalTable, Map<String, Object> metaData) {
        if (this.primaryColumnName.isPresent()) {
            Pair fullTableName = (Pair)metaData.get(LargeGroupListNode.class.getSimpleName());
            String largeGroupListSchemaName = (String)fullTableName.getLeft();
            String largeGroupListTableName = (String)fullTableName.getRight();
            JoinTable source = JoinTable.create(Arrays.asList(new BaseTable(originalSchema, originalTable, MAIN_TABLE_SOURCE_ALIAS_NAME), new BaseTable(largeGroupListSchemaName, largeGroupListTableName, RIGHT_TABLE_SOURCE_ALIAS_NAME)), Arrays.asList(JoinTable.JoinType.leftouter), Arrays.asList(ColumnOp.equal(new BaseColumn(MAIN_TABLE_SOURCE_ALIAS_NAME, (String)this.primaryColumnName.get()), new BaseColumn(RIGHT_TABLE_SOURCE_ALIAS_NAME, "verdictdbrenameprimarygroup"))));
            return source;
        }
        return new BaseTable(originalSchema, originalTable, MAIN_TABLE_SOURCE_ALIAS_NAME);
    }

    @Override
    public String getMainTableAlias() {
        return MAIN_TABLE_SOURCE_ALIAS_NAME;
    }

    @Override
    public int getBlockCount() {
        return this.totalNumberOfblocks;
    }

    @Override
    public int getTierCount() {
        return 3;
    }
}

