/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.querying.IdCreator;
import org.verdictdb.core.querying.QueryNodeWithPlaceHolders;
import org.verdictdb.core.scrambling.ScramblingMethod;
import org.verdictdb.core.sqlobject.CreateScrambledTableQuery;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.exception.VerdictDBException;

public class CreateScrambledTableNode
extends QueryNodeWithPlaceHolders {
    private static final long serialVersionUID = 1L;
    private IdCreator namer;
    protected String originalSchemaName;
    protected String originalTableName;
    protected String tierColumnName;
    protected String blockColumnName;
    private String newTableSchemaName;
    private String newTableName;
    private List<String> partitionColumns = new ArrayList<String>();
    protected ScramblingMethod method;

    public CreateScrambledTableNode(IdCreator namer, SelectQuery query) {
        super(query);
        this.namer = namer;
    }

    public CreateScrambledTableNode(IdCreator namer, SelectQuery query, String originalSchemaName, String originalTableName, ScramblingMethod method, String tierColumnName, String blockColumnName) {
        super(query);
        this.namer = namer;
        this.originalSchemaName = originalSchemaName;
        this.originalTableName = originalTableName;
        this.method = method;
        this.tierColumnName = tierColumnName;
        this.blockColumnName = blockColumnName;
    }

    public static CreateScrambledTableNode create(IdCreator namer, SelectQuery query) {
        return new CreateScrambledTableNode(namer, query);
    }

    public IdCreator getNamer() {
        return this.namer;
    }

    public void setNamer(IdCreator namer) {
        this.namer = namer;
    }

    public void addPartitionColumn(String column) {
        this.partitionColumns.add(column);
    }

    @Override
    public SqlConvertible createQuery(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        super.createQuery(tokens);
        Pair<String, String> tempTableFullName = this.namer.generateTempTableName();
        this.newTableSchemaName = (String)tempTableFullName.getLeft();
        this.newTableName = (String)tempTableFullName.getRight();
        List columnMeta = null;
        for (ExecutionInfoToken token : tokens) {
            Object val = token.getValue("scramblingPlan:columnMetaData");
            if (val == null) continue;
            columnMeta = (List)val;
            break;
        }
        if (columnMeta == null) {
            throw new VerdictDBException("Column meta is null.");
        }
        CreateScrambledTableQuery createQuery = new CreateScrambledTableQuery(this.originalSchemaName, this.originalTableName, this.newTableSchemaName, this.newTableName, this.tierColumnName, this.blockColumnName, this.selectQuery, this.method.getBlockCount(), columnMeta);
        for (String col : this.partitionColumns) {
            createQuery.addPartitionColumn(col);
        }
        return createQuery;
    }

    @Override
    public ExecutionInfoToken createToken(DbmsQueryResult result) {
        ExecutionInfoToken token = new ExecutionInfoToken();
        token.setKeyValue("schemaName", this.newTableSchemaName);
        token.setKeyValue("tableName", this.newTableName);
        return token;
    }

    @Override
    public ExecutableNodeBase deepcopy() {
        CreateScrambledTableNode node = new CreateScrambledTableNode(this.namer, this.selectQuery);
        this.copyFields(this, node);
        return node;
    }

    void copyFields(CreateScrambledTableNode from, CreateScrambledTableNode to) {
        super.copyFields(from, to);
    }
}

