/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import org.verdictdb.core.scrambling.ScrambleMeta;

public class BaseScrambler {
    String originalSchemaName;
    String originalTableName;
    String scrambledSchemaName;
    String scrambledTableName;
    int aggregationBlockCount;
    static String aggregationBlockColumn = "verdictdbaggblock";
    static String subsampleColumn = "verdictdbsid";
    static String tierColumn = "verdictdbtier";

    public BaseScrambler(String originalSchemaName, String originalTableName, String scrambledSchemaName, String scrambledTableName, int aggregationBlockCount) {
        this.originalSchemaName = originalSchemaName;
        this.originalTableName = originalTableName;
        this.scrambledSchemaName = scrambledSchemaName;
        this.scrambledTableName = scrambledTableName;
        this.aggregationBlockCount = aggregationBlockCount;
    }

    public ScrambleMeta generateMeta() {
        ScrambleMeta meta = new ScrambleMeta();
        meta.setSchemaName(this.scrambledSchemaName);
        meta.setTableName(this.scrambledTableName);
        meta.setAggregationBlockCount(this.aggregationBlockCount);
        meta.setAggregationBlockColumn(aggregationBlockColumn);
        meta.setSubsampleColumn(subsampleColumn);
        meta.setTierColumn(tierColumn);
        return meta;
    }

    public static String getAggregationBlockColumn() {
        return aggregationBlockColumn;
    }

    public static String getSubsampleColumn() {
        return subsampleColumn;
    }

    public static String getTierColumn() {
        return tierColumn;
    }
}

