/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.rewriter.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.core.rewriter.AliasRenamingRules;
import org.verdictdb.core.rewriter.query.AggblockMeta;
import org.verdictdb.core.scrambling.ScrambleMetaSet;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AliasReference;
import org.verdictdb.core.sqlobject.AliasedColumn;
import org.verdictdb.core.sqlobject.AsteriskColumn;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.ConstantColumn;
import org.verdictdb.core.sqlobject.GroupingAttribute;
import org.verdictdb.core.sqlobject.SelectItem;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.UnnamedColumn;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.exception.VerdictDBTypeException;
import org.verdictdb.exception.VerdictDBValueException;

public class AggQueryRewriter {
    ScrambleMetaSet scrambleMeta;
    int nextAliasNumber = 1;

    public AggQueryRewriter(ScrambleMetaSet scrambleMeta) {
        this.scrambleMeta = scrambleMeta;
    }

    String generateNextAliasName() {
        String aliasName = "verdictdbalias" + this.nextAliasNumber;
        ++this.nextAliasNumber;
        return aliasName;
    }

    void initializeAliasNameSequence() {
        this.nextAliasNumber = 1;
    }

    public List<Pair<AbstractRelation, AggblockMeta>> rewrite(AbstractRelation relation) throws VerdictDBException {
        if (!(relation instanceof SelectQuery)) {
            throw new VerdictDBTypeException(relation);
        }
        if (!relation.isSupportedAggregate()) {
            throw new VerdictDBValueException("The provided relation is not an aggregate relation.");
        }
        List<Pair<AbstractRelation, AggblockMeta>> rewrittenQueries = this.rewriteAggregateQuery(relation);
        return rewrittenQueries;
    }

    public List<Pair<AbstractRelation, AggblockMeta>> rewriteAggregateQuery(AbstractRelation relation) throws VerdictDBException {
        ArrayList<AbstractRelation> selectAllScrambledBases = new ArrayList<AbstractRelation>();
        SelectQuery sel = (SelectQuery)relation;
        List<AbstractRelation> sourceList = sel.getFromList();
        sel.clearFromList();
        ArrayList<AbstractRelation> immediateScrambledSources = new ArrayList<AbstractRelation>();
        HashMap<String, String> aliasUpdateMap = new HashMap<String, String>();
        for (AbstractRelation source : sourceList) {
            AbstractRelation rewrittenSource = this.rewriteQueryRecursively(source, selectAllScrambledBases);
            sel.addTableSource(rewrittenSource);
            if (this.scrambleMeta.isScrambled((String)rewrittenSource.getAliasName().get())) {
                immediateScrambledSources.add(rewrittenSource);
            }
            aliasUpdateMap.put((String)source.getAliasName().get(), (String)rewrittenSource.getAliasName().get());
        }
        ArrayList<Pair<AbstractRelation, AggblockMeta>> rewrittenQueries = new ArrayList<Pair<AbstractRelation, AggblockMeta>>();
        if (immediateScrambledSources.size() == 0) {
            rewrittenQueries.add(Pair.of((Object)sel, (Object)AggblockMeta.empty()));
        } else {
            List<SelectItem> selectList = sel.getSelectList();
            sel.clearSelectList();
            for (SelectItem selectItem : selectList) {
                sel.addSelectItem(this.replaceTableReferenceInSelectItem(selectItem, aliasUpdateMap));
            }
            List<GroupingAttribute> groupbyList = sel.getGroupby();
            sel.clearGroupby();
            for (GroupingAttribute group : groupbyList) {
                sel.addGroupby(this.replaceTableReferenceInGroupby(group, aliasUpdateMap));
            }
            ArrayList<BaseColumn> arrayList = new ArrayList<BaseColumn>();
            ArrayList<List<Pair<Integer, Integer>>> blockingIndices = new ArrayList<List<Pair<Integer, Integer>>>();
            Pair<UnnamedColumn, UnnamedColumn> subsampleAndTierColumns = this.planBlockAggregation(selectAllScrambledBases, immediateScrambledSources, arrayList, blockingIndices);
            UnnamedColumn subsampleColumn = (UnnamedColumn)subsampleAndTierColumns.getLeft();
            UnnamedColumn tierColumn = (UnnamedColumn)subsampleAndTierColumns.getRight();
            int savedNextAliasNumber = this.nextAliasNumber;
            for (int k = 0; k < ((List)blockingIndices.get(0)).size(); ++k) {
                this.nextAliasNumber = savedNextAliasNumber;
                AbstractRelation rewrittenQuery = this.rewriteSelectListForErrorEstimation(sel, subsampleColumn, tierColumn);
                AggblockMeta aggblockMeta = new AggblockMeta();
                for (int m = 0; m < arrayList.size(); ++m) {
                    BaseColumn blockaggBaseColumn = (BaseColumn)arrayList.get(m);
                    Pair blockingIndex = (Pair)((List)blockingIndices.get(m)).get(k);
                    SelectQuery selectAllScramledBase = (SelectQuery)selectAllScrambledBases.get(m);
                    selectAllScramledBase.clearFilters();
                    selectAllScramledBase.addFilterByAnd(ColumnOp.equal(blockaggBaseColumn, ConstantColumn.valueOf((Integer)blockingIndex.getLeft())));
                    aggblockMeta.addMeta(blockaggBaseColumn.getSchemaName(), blockaggBaseColumn.getTableName(), (Pair<Integer, Integer>)blockingIndex);
                }
                rewrittenQueries.add((Pair<AbstractRelation, AggblockMeta>)Pair.of((Object)this.deepcopySelectQuery((SelectQuery)rewrittenQuery), (Object)aggblockMeta));
            }
        }
        return rewrittenQueries;
    }

    SelectItem replaceTableReferenceInSelectItem(SelectItem oldColumn, Map<String, String> aliasUpdateMap) throws VerdictDBTypeException {
        if (oldColumn instanceof UnnamedColumn) {
            return this.replaceTableReferenceInUnnamedColumn((UnnamedColumn)oldColumn, aliasUpdateMap);
        }
        if (oldColumn instanceof AliasedColumn) {
            AliasedColumn col = (AliasedColumn)oldColumn;
            return new AliasedColumn(this.replaceTableReferenceInUnnamedColumn(col.getColumn(), aliasUpdateMap), col.getAliasName());
        }
        throw new VerdictDBTypeException("Unexpected argument type: " + oldColumn.getClass().toString());
    }

    UnnamedColumn replaceTableReferenceInUnnamedColumn(UnnamedColumn oldColumn, Map<String, String> aliasUpdateMap) throws VerdictDBTypeException {
        if (oldColumn instanceof BaseColumn) {
            BaseColumn col = (BaseColumn)oldColumn;
            BaseColumn newCol = new BaseColumn(aliasUpdateMap.get(col.getTableSourceAlias()), col.getColumnName());
            return newCol;
        }
        if (oldColumn instanceof ColumnOp) {
            ColumnOp col = (ColumnOp)oldColumn;
            ArrayList<UnnamedColumn> newOperands = new ArrayList<UnnamedColumn>();
            for (UnnamedColumn c : col.getOperands()) {
                newOperands.add(this.replaceTableReferenceInUnnamedColumn(c, aliasUpdateMap));
            }
            return new ColumnOp(col.getOpType(), newOperands);
        }
        throw new VerdictDBTypeException("Unexpected argument type: " + oldColumn.getClass().toString());
    }

    GroupingAttribute replaceTableReferenceInGroupby(GroupingAttribute oldGroup, Map<String, String> aliasUpdateMap) throws VerdictDBTypeException {
        if (oldGroup instanceof AliasReference) {
            return oldGroup;
        }
        if (oldGroup instanceof UnnamedColumn) {
            return this.replaceTableReferenceInUnnamedColumn((UnnamedColumn)oldGroup, aliasUpdateMap);
        }
        throw new VerdictDBTypeException("Unexpected argument type: " + oldGroup.getClass().toString());
    }

    Pair<UnnamedColumn, UnnamedColumn> planBlockAggregation(List<AbstractRelation> selectAllScrambledBase, List<AbstractRelation> immediateScrambledSources, List<BaseColumn> blockAggregateColumns, List<List<Pair<Integer, Integer>>> blockingIndices) throws VerdictDBValueException {
        if (selectAllScrambledBase.size() > 1) {
            throw new VerdictDBValueException("Only one scrambled table is expected.");
        }
        SelectQuery selectAllBase = (SelectQuery)selectAllScrambledBase.get(0);
        BaseTable scrambledBase = (BaseTable)selectAllBase.getFromList().get(0);
        String baseSchemaName = scrambledBase.getSchemaName();
        String baseTableName = scrambledBase.getTableName();
        int aggBlockCount = this.scrambleMeta.getAggregationBlockCount(baseSchemaName, baseTableName);
        String aggBlockColumn = this.scrambleMeta.getAggregationBlockColumn(baseSchemaName, baseTableName);
        blockAggregateColumns.add(new BaseColumn((String)scrambledBase.getAliasName().get(), aggBlockColumn));
        ArrayList<Pair> blockingIndex = new ArrayList<Pair>();
        for (int k = 0; k < aggBlockCount; ++k) {
            blockingIndex.add(Pair.of((Object)k, (Object)k));
        }
        blockingIndices.add(blockingIndex);
        AbstractRelation scrambledDirectSource = immediateScrambledSources.get(0);
        String scrambledSourceAliasName = (String)scrambledDirectSource.getAliasName().get();
        String subsampleColumnName = this.scrambleMeta.getSubsampleColumn(scrambledSourceAliasName);
        String tierColumnName = this.scrambleMeta.getTierColumn(scrambledSourceAliasName);
        return Pair.of((Object)new BaseColumn(scrambledSourceAliasName, subsampleColumnName), (Object)new BaseColumn(scrambledSourceAliasName, tierColumnName));
    }

    public AbstractRelation rewriteQueryRecursively(AbstractRelation relation, List<AbstractRelation> selectAllScrambled) throws VerdictDBException {
        if (relation instanceof BaseTable) {
            String baseTableName;
            BaseTable base = (BaseTable)relation;
            String baseTableAliasName = (String)base.getAliasName().get();
            String baseSchemaName = base.getSchemaName();
            if (!this.scrambleMeta.isScrambled(baseSchemaName, baseTableName = base.getTableName())) {
                return relation;
            }
            String newRelationAliasName = this.generateNextAliasName();
            SelectQuery sel = SelectQuery.create(Arrays.asList(new AsteriskColumn()), (AbstractRelation)base);
            sel.setAliasName(newRelationAliasName);
            String string = this.scrambleMeta.getSubsampleColumn(baseSchemaName, baseTableName);
            String string2 = this.scrambleMeta.getTierColumn(baseSchemaName, baseTableName);
            String subsampleAliasName = this.generateNextAliasName();
            String tierAliasName = this.generateNextAliasName();
            sel.addSelectItem(new AliasedColumn(new BaseColumn(baseTableAliasName, string), subsampleAliasName));
            sel.addSelectItem(new AliasedColumn(new BaseColumn(baseTableAliasName, string2), tierAliasName));
            this.scrambleMeta.insertScrambleMetaEntry(newRelationAliasName, subsampleAliasName, tierAliasName);
            selectAllScrambled.add(sel);
            return sel;
        }
        if (relation instanceof SelectQuery) {
            SelectQuery sel = (SelectQuery)relation;
            List<AbstractRelation> oldSources = sel.getFromList();
            sel.clearFromList();
            boolean doesScrambledSourceExist = false;
            SelectQuery scrambledSource = null;
            HashMap<String, String> aliasUpdateMap = new HashMap<String, String>();
            for (AbstractRelation abstractRelation : oldSources) {
                AbstractRelation abstractRelation2 = this.rewriteQueryRecursively(abstractRelation, selectAllScrambled);
                sel.addTableSource(abstractRelation2);
                if (this.scrambleMeta.isScrambled((String)abstractRelation2.getAliasName().get())) {
                    doesScrambledSourceExist = true;
                    scrambledSource = (SelectQuery)abstractRelation2;
                }
                aliasUpdateMap.put((String)abstractRelation.getAliasName().get(), (String)abstractRelation2.getAliasName().get());
            }
            List<SelectItem> selectList = sel.getSelectList();
            sel.clearSelectList();
            for (SelectItem selectItem : selectList) {
                sel.addSelectItem(this.replaceTableReferenceInSelectItem(selectItem, aliasUpdateMap));
            }
            List<GroupingAttribute> list = sel.getGroupby();
            sel.clearGroupby();
            for (GroupingAttribute group : list) {
                sel.addGroupby(this.replaceTableReferenceInGroupby(group, aliasUpdateMap));
            }
            if (!doesScrambledSourceExist) {
                return relation;
            }
            String string = (String)scrambledSource.getAliasName().get();
            String subsampleColumn = this.scrambleMeta.getSubsampleColumn(string);
            String tierColumn = this.scrambleMeta.getTierColumn(string);
            String subsampleAliasName = this.generateNextAliasName();
            String tierAliasName = this.generateNextAliasName();
            sel.addSelectItem(new AliasedColumn(new BaseColumn(string, subsampleColumn), subsampleAliasName));
            sel.addSelectItem(new AliasedColumn(new BaseColumn(string, tierColumn), tierAliasName));
            this.scrambleMeta.insertScrambleMetaEntry((String)sel.getAliasName().get(), subsampleAliasName, tierAliasName);
            return relation;
        }
        throw new VerdictDBTypeException("An unexpected relation type: " + relation.getClass().toString());
    }

    SelectQuery deepcopySelectQuery(SelectQuery relation) {
        SelectQuery sel = new SelectQuery();
        for (SelectItem c : relation.getSelectList()) {
            sel.addSelectItem(c);
        }
        for (AbstractRelation r : relation.getFromList()) {
            if (r instanceof SelectQuery) {
                sel.addTableSource(this.deepcopySelectQuery((SelectQuery)r));
                continue;
            }
            sel.addTableSource(r);
        }
        if (relation.getFilter().isPresent()) {
            sel.addFilterByAnd((UnnamedColumn)relation.getFilter().get());
        }
        for (GroupingAttribute a : relation.getGroupby()) {
            sel.addGroupby(a);
        }
        if (relation.getAliasName().isPresent()) {
            sel.setAliasName((String)relation.getAliasName().get());
        }
        return sel;
    }

    AbstractRelation rewriteSelectListForErrorEstimation(AbstractRelation relation, UnnamedColumn subsampleColumnOfSource, UnnamedColumn tierColumnOfSource) throws VerdictDBException {
        SelectQuery rewrittenOuter = new SelectQuery();
        SelectQuery rewrittenInner = new SelectQuery();
        String innerTableAliasName = this.generateNextAliasName();
        String innerTierColumnAliasName = this.generateNextAliasName();
        String outerTierColumnAliasName = AliasRenamingRules.tierAliasName();
        rewrittenInner.setAliasName(innerTableAliasName);
        SelectQuery sel = (SelectQuery)relation;
        List<SelectItem> selectList = sel.getSelectList();
        ArrayList<AliasedColumn> newInnerSelectList = new ArrayList<AliasedColumn>();
        ArrayList<AliasedColumn> newOuterSelectList = new ArrayList<AliasedColumn>();
        List<GroupingAttribute> groupbyList = sel.getGroupby();
        ArrayList<GroupingAttribute> newInnerGroupbyList = new ArrayList<GroupingAttribute>();
        ArrayList<AliasReference> newOuterGroupbyList = new ArrayList<AliasReference>();
        ArrayList<Pair> innerNonaggregateSelectItemToAliases = new ArrayList<Pair>();
        newInnerSelectList.add(new AliasedColumn(tierColumnOfSource, innerTierColumnAliasName));
        newOuterSelectList.add(new AliasedColumn(new BaseColumn(innerTableAliasName, innerTierColumnAliasName), outerTierColumnAliasName));
        for (SelectItem selectItem : selectList) {
            if (!(selectItem instanceof AliasedColumn)) {
                throw new VerdictDBTypeException("The following select item is not aliased: " + selectItem.toString());
            }
            UnnamedColumn c = ((AliasedColumn)selectItem).getColumn();
            String aliasName = ((AliasedColumn)selectItem).getAliasName();
            if (c instanceof BaseColumn) {
                String aliasForBase = this.generateNextAliasName();
                newInnerSelectList.add(new AliasedColumn(c, aliasForBase));
                newOuterSelectList.add(new AliasedColumn(new BaseColumn(innerTableAliasName, aliasForBase), aliasName));
                innerNonaggregateSelectItemToAliases.add(Pair.of((Object)c, (Object)Pair.of((Object)aliasForBase, (Object)aliasName)));
                continue;
            }
            if (c instanceof ColumnOp) {
                String aliasForSumSquaredScaledSubsum;
                String aliasForSumScaledSubsum;
                String aliasForSumEstimate;
                String aliasForSubsampleSize;
                String aliasForSubSumEst;
                ColumnOp col = (ColumnOp)c;
                if (col.getOpType().equals("sum")) {
                    aliasForSubSumEst = this.generateNextAliasName();
                    aliasForSubsampleSize = this.generateNextAliasName();
                    aliasForSumEstimate = AliasRenamingRules.sumEstimateAliasName(aliasName);
                    aliasForSumScaledSubsum = AliasRenamingRules.sumScaledSumAliasName(aliasName);
                    aliasForSumSquaredScaledSubsum = AliasRenamingRules.sumSquaredScaledSumAliasName(aliasName);
                    String aliasForCountSubsample = AliasRenamingRules.countSubsampleAliasName();
                    String aliasForSumSubsampleSize = AliasRenamingRules.sumSubsampleSizeAliasName();
                    UnnamedColumn op = col.getOperand();
                    ColumnOp newCol = ColumnOp.sum(op);
                    newInnerSelectList.add(new AliasedColumn(newCol, aliasForSubSumEst));
                    ColumnOp oneIfNotNull = ColumnOp.casewhen(Arrays.asList(ColumnOp.rightisnotnull(op), ConstantColumn.valueOf(1), ConstantColumn.valueOf(0)));
                    newInnerSelectList.add(new AliasedColumn(ColumnOp.sum(oneIfNotNull), aliasForSubsampleSize));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(new BaseColumn(innerTableAliasName, aliasForSubSumEst)), aliasForSumEstimate));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(ColumnOp.multiply(new BaseColumn(innerTableAliasName, aliasForSubSumEst), new BaseColumn(innerTableAliasName, aliasForSubsampleSize))), aliasForSumScaledSubsum));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(ColumnOp.multiply(ColumnOp.multiply(new BaseColumn(innerTableAliasName, aliasForSubSumEst), new BaseColumn(innerTableAliasName, aliasForSubSumEst)), new BaseColumn(innerTableAliasName, aliasForSubsampleSize))), aliasForSumSquaredScaledSubsum));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.count(), aliasForCountSubsample));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(new BaseColumn(innerTableAliasName, aliasForSubsampleSize)), aliasForSumSubsampleSize));
                    continue;
                }
                if (col.getOpType().equals("count")) {
                    String aliasForSubsampleSize2 = this.generateNextAliasName();
                    String aliasForCountEstimate = AliasRenamingRules.countEstimateAliasName(aliasName);
                    String aliasForSumScaledSubcount = AliasRenamingRules.sumScaledCountAliasName(aliasName);
                    String aliasForSumSquaredScaledSubcount = AliasRenamingRules.sumSquaredScaledCountAliasName(aliasName);
                    String aliasForCountSubsample = AliasRenamingRules.countSubsampleAliasName();
                    String aliasForSumSubsampleSize = AliasRenamingRules.sumSubsampleSizeAliasName();
                    newInnerSelectList.add(new AliasedColumn(ColumnOp.count(), aliasForSubsampleSize2));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(new BaseColumn(innerTableAliasName, aliasForSubsampleSize2)), aliasForCountEstimate));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(ColumnOp.multiply(new BaseColumn(innerTableAliasName, aliasForSubsampleSize2), new BaseColumn(innerTableAliasName, aliasForSubsampleSize2))), aliasForSumScaledSubcount));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(ColumnOp.pow(new BaseColumn(innerTableAliasName, aliasForSubsampleSize2), ConstantColumn.valueOf(3))), aliasForSumSquaredScaledSubcount));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.count(), aliasForCountSubsample));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(new BaseColumn(innerTableAliasName, aliasForSubsampleSize2)), aliasForSumSubsampleSize));
                    continue;
                }
                if (col.getOpType().equals("avg")) {
                    aliasForSubSumEst = this.generateNextAliasName();
                    aliasForSubsampleSize = this.generateNextAliasName();
                    aliasForSumEstimate = AliasRenamingRules.sumEstimateAliasName(aliasName);
                    aliasForSumScaledSubsum = AliasRenamingRules.sumScaledSumAliasName(aliasName);
                    aliasForSumSquaredScaledSubsum = AliasRenamingRules.sumSquaredScaledSumAliasName(aliasName);
                    String aliasForCountEstimate = AliasRenamingRules.countEstimateAliasName(aliasName);
                    String aliasForSumScaledSubcount = AliasRenamingRules.sumScaledCountAliasName(aliasName);
                    String aliasForSumSquaredScaledSubcount = AliasRenamingRules.sumSquaredScaledCountAliasName(aliasName);
                    String aliasForCountSubsample = AliasRenamingRules.countSubsampleAliasName();
                    String aliasForSumSubsampleSize = AliasRenamingRules.sumSubsampleSizeAliasName();
                    UnnamedColumn op = col.getOperand();
                    ColumnOp newCol = ColumnOp.sum(op);
                    newInnerSelectList.add(new AliasedColumn(newCol, aliasForSubSumEst));
                    ColumnOp oneIfNotNull = ColumnOp.casewhen(Arrays.asList(ColumnOp.rightisnotnull(op), ConstantColumn.valueOf(1), ConstantColumn.valueOf(0)));
                    newInnerSelectList.add(new AliasedColumn(ColumnOp.sum(oneIfNotNull), aliasForSubsampleSize));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(new BaseColumn(innerTableAliasName, aliasForSubSumEst)), aliasForSumEstimate));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(new BaseColumn(innerTableAliasName, aliasForSubsampleSize)), aliasForCountEstimate));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(ColumnOp.multiply(new BaseColumn(innerTableAliasName, aliasForSubSumEst), new BaseColumn(innerTableAliasName, aliasForSubsampleSize))), aliasForSumScaledSubsum));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(ColumnOp.multiply(ColumnOp.multiply(new BaseColumn(innerTableAliasName, aliasForSubSumEst), new BaseColumn(innerTableAliasName, aliasForSubSumEst)), new BaseColumn(innerTableAliasName, aliasForSubsampleSize))), aliasForSumSquaredScaledSubsum));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(ColumnOp.multiply(new BaseColumn(innerTableAliasName, aliasForSubsampleSize), new BaseColumn(innerTableAliasName, aliasForSubsampleSize))), aliasForSumScaledSubcount));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(ColumnOp.pow(new BaseColumn(innerTableAliasName, aliasForSubsampleSize), ConstantColumn.valueOf(3))), aliasForSumSquaredScaledSubcount));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.count(), aliasForCountSubsample));
                    newOuterSelectList.add(new AliasedColumn(ColumnOp.sum(new BaseColumn(innerTableAliasName, aliasForSubsampleSize)), aliasForSumSubsampleSize));
                    continue;
                }
                throw new VerdictDBTypeException("Not implemented yet.");
            }
            throw new VerdictDBTypeException("Unexpected column type: " + c.getClass().toString());
        }
        newInnerGroupbyList.add(subsampleColumnOfSource);
        newInnerGroupbyList.add(new AliasReference(innerTierColumnAliasName));
        newOuterGroupbyList.add(new AliasReference(outerTierColumnAliasName));
        for (GroupingAttribute groupingAttribute : groupbyList) {
            boolean added = false;
            for (Pair pair : innerNonaggregateSelectItemToAliases) {
                UnnamedColumn col = (UnnamedColumn)pair.getLeft();
                String innerAlias = (String)((Pair)pair.getRight()).getLeft();
                String outerAlias = (String)((Pair)pair.getRight()).getRight();
                if (groupingAttribute.equals(col)) {
                    newInnerGroupbyList.add(new AliasReference(innerAlias));
                    newOuterGroupbyList.add(new AliasReference(outerAlias));
                    added = true;
                    continue;
                }
                if (!(groupingAttribute instanceof AliasReference) || !((AliasReference)groupingAttribute).getAliasName().equals(outerAlias)) continue;
                newInnerGroupbyList.add(new AliasReference(innerAlias));
                newOuterGroupbyList.add(new AliasReference(outerAlias));
                added = true;
            }
            if (added) continue;
            newInnerGroupbyList.add(groupingAttribute);
        }
        for (SelectItem selectItem : newInnerSelectList) {
            rewrittenInner.addSelectItem(selectItem);
        }
        for (AbstractRelation abstractRelation : sel.getFromList()) {
            rewrittenInner.addTableSource(abstractRelation);
        }
        if (sel.getFilter().isPresent()) {
            rewrittenInner.addFilterByAnd((UnnamedColumn)sel.getFilter().get());
        }
        for (GroupingAttribute groupingAttribute : newInnerGroupbyList) {
            rewrittenInner.addGroupby(groupingAttribute);
        }
        for (SelectItem selectItem : newOuterSelectList) {
            rewrittenOuter.addSelectItem(selectItem);
        }
        rewrittenOuter.addTableSource(rewrittenInner);
        for (GroupingAttribute groupingAttribute : newOuterGroupbyList) {
            rewrittenOuter.addGroupby(groupingAttribute);
        }
        return rewrittenOuter;
    }
}

