/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.rewriter.aggresult;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.TypeCasting;
import org.verdictdb.core.aggresult.AggregateFrame;
import org.verdictdb.core.aggresult.AggregateGroup;
import org.verdictdb.core.aggresult.AggregateMeasures;
import org.verdictdb.core.rewriter.AliasRenamingRules;
import org.verdictdb.core.rewriter.aggresult.AggNameAndType;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.exception.VerdictDBTypeException;
import org.verdictdb.exception.VerdictDBValueException;

public class SingleAggResultRewriter {
    AggregateFrame rawResultSet;
    List<String> columnNames;
    Map<String, Integer> indexCache = new HashMap<String, Integer>();

    public SingleAggResultRewriter(AggregateFrame rawResultSet) {
        this.rawResultSet = rawResultSet;
        this.columnNames = rawResultSet.getColumnNames();
    }

    public AggregateFrame rewrite(List<String> nonaggColumns, List<AggNameAndType> aggColumns) throws VerdictDBException {
        this.ensureColumnNamesValidity(nonaggColumns, aggColumns);
        AggregateFrame converted = new AggregateFrame(this.getNewColumnNames(nonaggColumns, aggColumns));
        HashMap regroupedData = new HashMap();
        for (Map.Entry<AggregateGroup, AggregateMeasures> entry : this.rawResultSet.groupAndMeasuresSet()) {
            ArrayList<String> newGroupNames = new ArrayList<String>();
            ArrayList<Object> newGroupValues = new ArrayList<Object>();
            int tierNumber = -1;
            AggregateGroup previousGroup = entry.getKey();
            List<String> groupNames = previousGroup.getAttributeNames();
            List<Object> groupValues = previousGroup.getAttributeValues();
            for (int i = 0; i < groupNames.size(); ++i) {
                if (groupNames.get(i).equals(AliasRenamingRules.tierAliasName())) {
                    tierNumber = Integer.valueOf(groupValues.get(i).toString());
                    continue;
                }
                newGroupNames.add(groupNames.get(i));
                newGroupValues.add(groupValues.get(i));
            }
            AggregateGroup newGroup = new AggregateGroup(newGroupNames, newGroupValues);
            if (!regroupedData.containsKey(newGroup)) {
                regroupedData.put(newGroup, new ArrayList());
            }
            ((List)regroupedData.get(newGroup)).add(Pair.of((Object)tierNumber, (Object)entry.getValue()));
        }
        for (Map.Entry<AggregateGroup, AggregateMeasures> entry : regroupedData.entrySet()) {
            AggregateGroup singleGroup = entry.getKey();
            List consolidatedMeasures = (List)((Object)entry.getValue());
            AggregateMeasures convertedMeasures = this.rewriteMeasures(consolidatedMeasures, aggColumns);
            converted.addRow(singleGroup, convertedMeasures);
        }
        return converted;
    }

    AggregateMeasures rewriteMeasures(List<Pair<Integer, AggregateMeasures>> tierAndMeasures, List<AggNameAndType> aggColumns) throws VerdictDBValueException, VerdictDBTypeException {
        AggregateMeasures rewrittenMeasures = new AggregateMeasures();
        for (AggNameAndType agg : aggColumns) {
            List<Pair<String, Object>> rewrittenSingle;
            Object sumSubsampleSizes;
            Object countSubsamples;
            Object sumSquaredScaledSum;
            Object sumScaledSum;
            Object sumEstimate;
            String aggname = agg.getName();
            String aggtype = agg.getAggType();
            AggregateMeasures originalMeasures = (AggregateMeasures)tierAndMeasures.get(0).getRight();
            if (aggtype.equals("sum")) {
                sumEstimate = this.getMeasureValue(originalMeasures, AliasRenamingRules.sumEstimateAliasName(aggname));
                sumScaledSum = this.getMeasureValue(originalMeasures, AliasRenamingRules.sumScaledSumAliasName(aggname));
                sumSquaredScaledSum = this.getMeasureValue(originalMeasures, AliasRenamingRules.sumSquaredScaledSumAliasName(aggname));
                countSubsamples = this.getMeasureValue(originalMeasures, AliasRenamingRules.countSubsampleAliasName());
                sumSubsampleSizes = this.getMeasureValue(originalMeasures, AliasRenamingRules.sumSubsampleSizeAliasName());
                rewrittenSingle = this.rewriteSumMeasure(aggname, sumEstimate, sumScaledSum, sumSquaredScaledSum, countSubsamples, sumSubsampleSizes);
                for (Pair<String, Object> nameAndValue : rewrittenSingle) {
                    rewrittenMeasures.addMeasure((String)nameAndValue.getLeft(), nameAndValue.getRight());
                }
                continue;
            }
            if (aggtype.equals("count")) {
                Object countEstimate = this.getMeasureValue(originalMeasures, AliasRenamingRules.countEstimateAliasName(aggname));
                Object sumScaledCount = this.getMeasureValue(originalMeasures, AliasRenamingRules.sumScaledCountAliasName(aggname));
                Object sumSquaredScaledCount = this.getMeasureValue(originalMeasures, AliasRenamingRules.sumSquaredScaledCountAliasName(aggname));
                countSubsamples = this.getMeasureValue(originalMeasures, AliasRenamingRules.countSubsampleAliasName());
                sumSubsampleSizes = this.getMeasureValue(originalMeasures, AliasRenamingRules.sumSubsampleSizeAliasName());
                rewrittenSingle = this.rewriteCountMeasure(aggname, countEstimate, sumScaledCount, sumSquaredScaledCount, countSubsamples, sumSubsampleSizes);
                for (Pair<String, Object> nameAndValue : rewrittenSingle) {
                    rewrittenMeasures.addMeasure((String)nameAndValue.getLeft(), nameAndValue.getRight());
                }
                continue;
            }
            if (!aggtype.equals("avg")) continue;
            sumEstimate = this.getMeasureValue(originalMeasures, AliasRenamingRules.sumEstimateAliasName(aggname));
            sumScaledSum = this.getMeasureValue(originalMeasures, AliasRenamingRules.sumScaledSumAliasName(aggname));
            sumSquaredScaledSum = this.getMeasureValue(originalMeasures, AliasRenamingRules.sumSquaredScaledSumAliasName(aggname));
            Object countEstimate = this.getMeasureValue(originalMeasures, AliasRenamingRules.countEstimateAliasName(aggname));
            Object sumScaledCount = this.getMeasureValue(originalMeasures, AliasRenamingRules.sumScaledCountAliasName(aggname));
            Object sumSquaredScaledCount = this.getMeasureValue(originalMeasures, AliasRenamingRules.sumSquaredScaledCountAliasName(aggname));
            Object countSubsamples2 = this.getMeasureValue(originalMeasures, AliasRenamingRules.countSubsampleAliasName());
            Object sumSubsampleSizes2 = this.getMeasureValue(originalMeasures, AliasRenamingRules.sumSubsampleSizeAliasName());
            List<Pair<String, Object>> rewrittenSingle2 = this.rewriteAvgMeasure(aggname, sumEstimate, sumScaledSum, sumSquaredScaledSum, countEstimate, sumScaledCount, sumSquaredScaledCount, countSubsamples2, sumSubsampleSizes2);
            for (Pair<String, Object> nameAndValue : rewrittenSingle2) {
                rewrittenMeasures.addMeasure((String)nameAndValue.getLeft(), nameAndValue.getRight());
            }
        }
        return rewrittenMeasures;
    }

    List<Pair<String, Object>> rewriteSumMeasure(String aggname, Object sumEstimate, Object sumScaledSum, Object sumSquaredScaledSum, Object countSubsamples, Object sumSubsampleSizes) throws VerdictDBTypeException {
        ArrayList<Pair<String, Object>> rewrittenMeasures = new ArrayList<Pair<String, Object>>();
        double mu = TypeCasting.toDouble(sumEstimate);
        double mu_nsi = TypeCasting.toDouble(sumScaledSum);
        double musquared_nsi = TypeCasting.toDouble(sumSquaredScaledSum);
        double b = TypeCasting.toDouble(countSubsamples);
        double n = TypeCasting.toDouble(sumSubsampleSizes);
        double mu_err = (musquared_nsi - 2.0 * mu_nsi + mu * mu * n) / (b * n);
        rewrittenMeasures.add(Pair.of((Object)AliasRenamingRules.expectedValueAliasName(aggname), (Object)mu));
        rewrittenMeasures.add(Pair.of((Object)AliasRenamingRules.expectedErrorAliasName(aggname), (Object)Math.sqrt(mu_err)));
        return rewrittenMeasures;
    }

    List<Pair<String, Object>> rewriteCountMeasure(String aggname, Object countEstimate, Object sumScaledCount, Object sumSquaredScaledCount, Object countSubsamples, Object sumSubsampleSizes) throws VerdictDBTypeException {
        ArrayList<Pair<String, Object>> rewrittenMeasures = new ArrayList<Pair<String, Object>>();
        double mu = TypeCasting.toDouble(countEstimate);
        double mu_nsi = TypeCasting.toDouble(sumScaledCount);
        double musquared_nsi = (Double)sumSquaredScaledCount;
        double b = TypeCasting.toDouble(countSubsamples);
        double n = TypeCasting.toDouble(sumSubsampleSizes);
        double mu_err = (musquared_nsi - 2.0 * mu_nsi + mu * mu * n) / (b * n);
        rewrittenMeasures.add(Pair.of((Object)AliasRenamingRules.expectedValueAliasName(aggname), (Object)mu));
        rewrittenMeasures.add(Pair.of((Object)AliasRenamingRules.expectedErrorAliasName(aggname), (Object)Math.sqrt(mu_err)));
        return rewrittenMeasures;
    }

    List<Pair<String, Object>> rewriteAvgMeasure(String aggname, Object sumEstimate, Object sumScaledSum, Object sumSquaredScaledSum, Object countEstimate, Object sumScaledCount, Object sumSquaredScaledCount, Object countSubsamples, Object sumSubsampleSizes) throws VerdictDBTypeException {
        ArrayList<Pair<String, Object>> rewrittenMeasures = new ArrayList<Pair<String, Object>>();
        double mu_s = TypeCasting.toDouble(sumEstimate);
        double mu_nsi_s = TypeCasting.toDouble(sumScaledSum);
        double musquared_nsi_s = TypeCasting.toDouble(sumSquaredScaledSum);
        double mu_c = TypeCasting.toDouble(countEstimate);
        double mu_nsi_c = TypeCasting.toDouble(sumScaledCount);
        double musquared_nsi_c = TypeCasting.toDouble(sumSquaredScaledCount);
        double b = TypeCasting.toDouble(countSubsamples);
        double n = TypeCasting.toDouble(sumSubsampleSizes);
        double mu_err_s = (musquared_nsi_s - 2.0 * mu_nsi_s + mu_s * mu_s * n) / (b * n);
        double mu_err_c = (musquared_nsi_c - 2.0 * mu_nsi_c + mu_c * mu_c * n) / (b * n);
        double mu = mu_s / mu_c;
        double mu_err = mu_err_s / (mu_c * mu_c) + mu_s * mu_s * mu_err_c / Math.pow(mu_c, 4.0);
        rewrittenMeasures.add(Pair.of((Object)AliasRenamingRules.expectedValueAliasName(aggname), (Object)mu));
        rewrittenMeasures.add(Pair.of((Object)AliasRenamingRules.expectedErrorAliasName(aggname), (Object)Math.sqrt(mu_err)));
        return rewrittenMeasures;
    }

    void ensureColumnNamesValidity(List<String> nonaggColumns, List<AggNameAndType> aggColumns) throws VerdictDBValueException {
        for (String nonagg : nonaggColumns) {
            this.mustContain(nonagg);
        }
        for (AggNameAndType agg : aggColumns) {
            String aggAlias = agg.getName();
            String aggType = agg.getAggType();
            if (aggType.equals("sum")) {
                this.mustContain(AliasRenamingRules.sumEstimateAliasName(aggAlias));
                this.mustContain(AliasRenamingRules.sumScaledSumAliasName(aggAlias));
                this.mustContain(AliasRenamingRules.sumSquaredScaledSumAliasName(aggAlias));
                this.mustContain(AliasRenamingRules.countSubsampleAliasName());
                this.mustContain(AliasRenamingRules.sumSubsampleSizeAliasName());
                continue;
            }
            if (aggType.equals("count")) {
                this.mustContain(AliasRenamingRules.countEstimateAliasName(aggAlias));
                this.mustContain(AliasRenamingRules.sumScaledCountAliasName(aggAlias));
                this.mustContain(AliasRenamingRules.sumSquaredScaledCountAliasName(aggAlias));
                this.mustContain(AliasRenamingRules.countSubsampleAliasName());
                this.mustContain(AliasRenamingRules.sumSubsampleSizeAliasName());
                continue;
            }
            if (!aggType.equals("avg")) continue;
            this.mustContain(AliasRenamingRules.sumEstimateAliasName(aggAlias));
            this.mustContain(AliasRenamingRules.sumScaledSumAliasName(aggAlias));
            this.mustContain(AliasRenamingRules.sumSquaredScaledSumAliasName(aggAlias));
            this.mustContain(AliasRenamingRules.countEstimateAliasName(aggAlias));
            this.mustContain(AliasRenamingRules.sumScaledCountAliasName(aggAlias));
            this.mustContain(AliasRenamingRules.sumSquaredScaledCountAliasName(aggAlias));
            this.mustContain(AliasRenamingRules.countSubsampleAliasName());
            this.mustContain(AliasRenamingRules.sumSubsampleSizeAliasName());
        }
    }

    List<String> getNewColumnNames(List<String> nonaggColumns, List<AggNameAndType> aggColumns) {
        ArrayList<String> newColumnNames = new ArrayList<String>();
        for (String name : nonaggColumns) {
            newColumnNames.add(name);
        }
        for (AggNameAndType agg : aggColumns) {
            String aggname = agg.getName();
            newColumnNames.add(AliasRenamingRules.expectedValueAliasName(aggname));
            newColumnNames.add(AliasRenamingRules.expectedErrorAliasName(aggname));
        }
        return newColumnNames;
    }

    Object getMeasureValue(AggregateMeasures measures, String aliasName) throws VerdictDBValueException {
        if (this.indexCache.containsKey(aliasName)) {
            return measures.getAttributeValueAt(this.indexCache.get(aliasName));
        }
        int index = measures.getIndexOfAttributeName(aliasName);
        this.indexCache.put(aliasName, index);
        return measures.getAttributeValueAt(index);
    }

    void mustContain(String colName) throws VerdictDBValueException {
        if (!this.columnNames.contains(colName)) {
            throw new VerdictDBValueException("The expected column name does not exist: " + colName);
        }
    }
}

