/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying.ola;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.core.querying.ola.Dimension;
import org.verdictdb.core.querying.ola.HyperTableCube;
import org.verdictdb.core.scrambling.ScrambleMetaSet;
import org.verdictdb.exception.VerdictDBValueException;

public class OlaAggregationPlan {
    List<HyperTableCube> cubes = new ArrayList<HyperTableCube>();

    public OlaAggregationPlan(ScrambleMetaSet scrambleMeta, List<Pair<String, String>> scrambles) throws VerdictDBValueException {
        if (scrambles.size() == 0) {
            return;
        }
        if (new HashSet<Pair<String, String>>(scrambles).size() < scrambles.size()) {
            throw new VerdictDBValueException("The same scrambled table cannot be included more than once.");
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        for (Pair<String, String> fullTableName : scrambles) {
            String schemaName = (String)fullTableName.getLeft();
            String tableName = (String)fullTableName.getRight();
            int aggBlockCount = scrambleMeta.getAggregationBlockCount(schemaName, tableName);
            dims.add(new Dimension(schemaName, tableName, 0, aggBlockCount - 1));
        }
        HyperTableCube originalCube = new HyperTableCube(dims);
        this.cubes = originalCube.roundRobinSlice();
    }

    public static OlaAggregationPlan createMergedOlaAggMeta(OlaAggregationPlan meta1, OlaAggregationPlan meta2) {
        return null;
    }

    public int totalBlockAggCount() {
        return this.cubes.size();
    }

    public Pair<Integer, Integer> getAggBlockSpanForTable(String schemaName, String tableName, int sequence) {
        HyperTableCube cube = this.cubes.get(sequence);
        return cube.getSpanOf(schemaName, tableName);
    }
}

