/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying.ola;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.core.querying.ola.Dimension;
import org.verdictdb.exception.VerdictDBValueException;

public class HyperTableCube
implements Serializable {
    private static final long serialVersionUID = -2326120491898400014L;
    List<Dimension> dimensions = new ArrayList<Dimension>();

    public HyperTableCube() {
    }

    public HyperTableCube(List<Dimension> dimensions) {
        this.dimensions = dimensions;
    }

    public static HyperTableCube createMergedCubes(HyperTableCube cube1, HyperTableCube cube2) {
        return null;
    }

    Dimension getDimension(int index) {
        return this.dimensions.get(index);
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public Pair<Integer, Integer> getSpanOf(String schemaName, String tableName) {
        for (Dimension d : this.dimensions) {
            if (!d.schemaName.equals(schemaName) || !d.tableName.equals(tableName)) continue;
            return Pair.of((Object)d.begin, (Object)d.end);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public List<HyperTableCube> roundRobinSlice() throws VerdictDBValueException {
        cubes = new ArrayList<HyperTableCube>();
        remaining = this;
        tableIndex = this.dimensions.size() - 1;
        block0: while (true) {
            numberOfDimensionsLongerThanOne = 0;
            for (i = 0; i < remaining.dimensions.size(); ++i) {
                if (remaining.dimensions.get(i).length() <= 1) continue;
                ++numberOfDimensionsLongerThanOne;
            }
            if (numberOfDimensionsLongerThanOne < 1) break;
            sliceAndLeft = remaining.sliceAlong(tableIndex);
            if (sliceAndLeft == null) {
                throw new VerdictDBValueException("Incorrect indexing.");
            }
            slice = (HyperTableCube)sliceAndLeft.getLeft();
            remaining = (HyperTableCube)sliceAndLeft.getRight();
            cubes.add(slice);
            i = 0;
            while (true) {
                if (i >= this.dimensions.size()) continue block0;
                if (--tableIndex < 0) {
                    tableIndex = this.dimensions.size() - 1;
                }
                if (remaining.dimensions.get(tableIndex).length() > 1) ** break;
                ++i;
            }
            break;
        }
        cubes.add(remaining);
        return cubes;
    }

    Pair<HyperTableCube, HyperTableCube> sliceAlong(int dimIndex) {
        if (dimIndex >= this.dimensions.size()) {
            return null;
        }
        if (this.dimensions.get(dimIndex).length() <= 1) {
            return null;
        }
        ArrayList<Dimension> slice = new ArrayList<Dimension>();
        ArrayList<Dimension> remaining = new ArrayList<Dimension>();
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension d = this.dimensions.get(i);
            if (i != dimIndex) {
                slice.add(d);
                remaining.add(d);
                continue;
            }
            slice.add(new Dimension(d.schemaName, d.tableName, d.begin, d.begin));
            remaining.add(new Dimension(d.schemaName, d.tableName, d.begin + 1, d.end));
        }
        return Pair.of((Object)new HyperTableCube(slice), (Object)new HyperTableCube(remaining));
    }

    public boolean isEmpty() {
        return this.dimensions.isEmpty();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }
}

