/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying.ola;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.verdictdb.core.execplan.ExecutableNode;
import org.verdictdb.core.querying.AggExecutionNode;
import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.querying.ProjectionNode;
import org.verdictdb.core.querying.QueryExecutionPlan;
import org.verdictdb.core.querying.QueryNodeBase;
import org.verdictdb.core.querying.ola.AggCombinerExecutionNode;
import org.verdictdb.core.querying.ola.AggExecutionNodeBlock;
import org.verdictdb.core.querying.ola.AggMeta;
import org.verdictdb.core.querying.ola.AsyncAggExecutionNode;
import org.verdictdb.core.querying.ola.OlaAggregationPlan;
import org.verdictdb.core.scrambling.ScrambleMeta;
import org.verdictdb.core.scrambling.ScrambleMetaSet;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AliasReference;
import org.verdictdb.core.sqlobject.AliasedColumn;
import org.verdictdb.core.sqlobject.AsteriskColumn;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.ConstantColumn;
import org.verdictdb.core.sqlobject.JoinTable;
import org.verdictdb.core.sqlobject.SelectItem;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.UnnamedColumn;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.exception.VerdictDBTypeException;
import org.verdictdb.exception.VerdictDBValueException;

public class AsyncQueryExecutionPlan
extends QueryExecutionPlan {
    private static final long serialVersionUID = -1670795390245860583L;
    private int aggColumnIdentiferNum = 0;
    private int verdictdbTierIndentiferNum = 0;
    static final String VERDICTDB_TIER_COLUMN_NAME = "verdictdb_tier_internal";

    private AsyncQueryExecutionPlan(String scratchpadSchemaName, ScrambleMetaSet scrambleMeta) throws VerdictDBException {
        super(scratchpadSchemaName, scrambleMeta);
    }

    public static AsyncQueryExecutionPlan create(QueryExecutionPlan plan) throws VerdictDBException {
        if (plan instanceof AsyncQueryExecutionPlan) {
            System.err.println("It is already an asyncronous plan.");
            throw new VerdictDBTypeException(plan);
        }
        AsyncQueryExecutionPlan asyncPlan = new AsyncQueryExecutionPlan(plan.getScratchpadSchemaName(), plan.getScrambleMeta());
        ExecutableNodeBase newRoot = asyncPlan.makeAsyncronousAggIfAvailable(plan.getRootNode());
        asyncPlan.setRootNode(newRoot);
        return asyncPlan;
    }

    ExecutableNodeBase makeAsyncronousAggIfAvailable(ExecutableNodeBase root) throws VerdictDBException {
        List<AggExecutionNodeBlock> aggBlocks = this.identifyTopAggBlocks(this.scrambleMeta, root);
        for (int i = 0; i < aggBlocks.size(); ++i) {
            AggExecutionNodeBlock nodeBlock = aggBlocks.get(i);
            SelectQuery originalQuery = null;
            if (nodeBlock.getBlockRootNode() instanceof AggExecutionNode) {
                originalQuery = ((AggExecutionNode)nodeBlock.getBlockRootNode()).getSelectQuery();
            }
            ExecutableNodeBase oldNode = nodeBlock.getBlockRootNode();
            ExecutableNodeBase newNode = this.convertToProgressiveAgg(this.scrambleMeta, nodeBlock);
            if (newNode instanceof AsyncAggExecutionNode && originalQuery != null) {
                ((AsyncAggExecutionNode)newNode).setSelectQuery(originalQuery);
            }
            List<ExecutableNodeBase> parents = oldNode.getExecutableNodeBaseParents();
            for (ExecutableNodeBase parent : parents) {
                Integer channel = parent.getChannelForSource(oldNode);
                if (channel == null) continue;
                parent.cancelSubscriptionTo(oldNode);
                parent.subscribeTo(newNode, channel);
            }
        }
        return root;
    }

    public ExecutableNodeBase convertToProgressiveAgg(ScrambleMetaSet scrambleMeta, AggExecutionNodeBlock aggNodeBlock) throws VerdictDBValueException {
        List<ExecutableNodeBase> blockNodes = aggNodeBlock.getNodesInBlock();
        ArrayList<ExecutableNodeBase> individualAggNodes = new ArrayList<ExecutableNodeBase>();
        ArrayList<ExecutableNodeBase> combiners = new ArrayList<ExecutableNodeBase>();
        List<Pair<ExecutableNodeBase, Triple<String, String, String>>> scrambledNodes = AsyncQueryExecutionPlan.identifyScrambledNodes(scrambleMeta, blockNodes);
        ArrayList<Pair<String, String>> scrambles = new ArrayList<Pair<String, String>>();
        for (Pair<ExecutableNodeBase, Triple<String, String, String>> a : scrambledNodes) {
            String schemaName = (String)((Triple)a.getRight()).getLeft();
            String tableName = (String)((Triple)a.getRight()).getMiddle();
            scrambles.add((Pair<String, String>)Pair.of((Object)schemaName, (Object)tableName));
        }
        OlaAggregationPlan aggPlan = new OlaAggregationPlan(scrambleMeta, scrambles);
        ArrayList<Pair<ExecutableNodeBase, ExecutableNodeBase>> oldSubscriptionInformation = new ArrayList<Pair<ExecutableNodeBase, ExecutableNodeBase>>();
        for (int i = 0; i < aggPlan.totalBlockAggCount(); ++i) {
            oldSubscriptionInformation.clear();
            AggExecutionNodeBlock copy = aggNodeBlock.deepcopyExcludingDependentAggregates(oldSubscriptionInformation);
            AggExecutionNode aggExecutionNode = (AggExecutionNode)copy.getBlockRootNode();
            for (ExecutableNodeBase executableNodeBase : aggExecutionNode.getExecutableNodeBaseParents()) {
                executableNodeBase.cancelSubscriptionTo(aggExecutionNode);
            }
            aggExecutionNode.cancelSubscriptionsFromAllSubscribers();
            List<Pair<ExecutableNodeBase, Triple<String, String, String>>> scrambledNodeAndTableName = AsyncQueryExecutionPlan.identifyScrambledNodes(scrambleMeta, copy.getNodesInBlock());
            aggExecutionNode.getAggMeta().setCubes(Arrays.asList(aggPlan.cubes.get(i)));
            this.addTierColumnsRecursively(copy, aggExecutionNode, new HashSet<ExecutableNode>());
            for (Pair<ExecutableNodeBase, Triple<String, String, String>> a : scrambledNodeAndTableName) {
                int right;
                ExecutableNodeBase scrambledNode = (ExecutableNodeBase)a.getLeft();
                String schemaName = (String)((Triple)a.getRight()).getLeft();
                String tableName = (String)((Triple)a.getRight()).getMiddle();
                String aliasName = (String)((Triple)a.getRight()).getRight();
                Pair<Integer, Integer> span = aggPlan.getAggBlockSpanForTable(schemaName, tableName, i);
                String aggblockColumn = scrambleMeta.getAggregationBlockColumn(schemaName, tableName);
                SelectQuery q = ((QueryNodeBase)scrambledNode).getSelectQuery();
                if (aliasName == null) {
                    throw new VerdictDBValueException(String.format("The alias name for the table (%s, %s) is not found.", schemaName, tableName));
                }
                int left = (Integer)span.getLeft();
                if (left == (right = ((Integer)span.getRight()).intValue())) {
                    q.addFilterByAnd(ColumnOp.equal(new BaseColumn(aliasName, aggblockColumn), ConstantColumn.valueOf(left)));
                    continue;
                }
                q.addFilterByAnd(ColumnOp.greaterequal(new BaseColumn(aliasName, aggblockColumn), ConstantColumn.valueOf(left)));
                q.addFilterByAnd(ColumnOp.lessequal(new BaseColumn(aliasName, aggblockColumn), ConstantColumn.valueOf(right)));
            }
            individualAggNodes.add(aggExecutionNode);
        }
        for (ExecutableNodeBase n : individualAggNodes) {
            n.cancelSubscriptionsFromAllSubscribers();
        }
        for (int i = 1; i < aggPlan.totalBlockAggCount(); ++i) {
            AggCombinerExecutionNode combiner = i == 1 ? AggCombinerExecutionNode.create(this.idCreator, (ExecutableNodeBase)individualAggNodes.get(0), (ExecutableNodeBase)individualAggNodes.get(1)) : AggCombinerExecutionNode.create(this.idCreator, (ExecutableNodeBase)combiners.get(i - 2), (ExecutableNodeBase)individualAggNodes.get(i));
            combiners.add(combiner);
        }
        AsyncAggExecutionNode newRoot = AsyncAggExecutionNode.create(this.idCreator, individualAggNodes, combiners, scrambleMeta);
        this.setTierColumnAlias(newRoot);
        for (Pair pair : oldSubscriptionInformation) {
            ExecutableNodeBase subscriber = (ExecutableNodeBase)pair.getLeft();
            ExecutableNodeBase executableNodeBase = (ExecutableNodeBase)pair.getRight();
            subscriber.cancelSubscriptionTo(executableNodeBase);
        }
        return newRoot;
    }

    private static List<Pair<ExecutableNodeBase, Triple<String, String, String>>> identifyScrambledNodes(ScrambleMetaSet scrambleMeta, List<ExecutableNodeBase> blockNodes) {
        ArrayList<Pair<ExecutableNodeBase, Triple<String, String, String>>> identified = new ArrayList<Pair<ExecutableNodeBase, Triple<String, String, String>>>();
        for (ExecutableNodeBase node : blockNodes) {
            for (AbstractRelation rel : ((QueryNodeBase)node).getSelectQuery().getFromList()) {
                if (rel instanceof BaseTable) {
                    BaseTable base = (BaseTable)rel;
                    if (!scrambleMeta.isScrambled(base.getSchemaName(), base.getTableName())) continue;
                    identified.add((Pair<ExecutableNodeBase, Triple<String, String, String>>)Pair.of((Object)node, (Object)Triple.of((Object)base.getSchemaName(), (Object)base.getTableName(), (Object)base.getAliasName().get())));
                    continue;
                }
                if (!(rel instanceof JoinTable)) continue;
                for (AbstractRelation r : ((JoinTable)rel).getJoinList()) {
                    BaseTable base;
                    if (!(r instanceof BaseTable) || !scrambleMeta.isScrambled((base = (BaseTable)r).getSchemaName(), base.getTableName())) continue;
                    identified.add((Pair<ExecutableNodeBase, Triple<String, String, String>>)Pair.of((Object)node, (Object)Triple.of((Object)base.getSchemaName(), (Object)base.getTableName(), (Object)base.getAliasName().get())));
                }
            }
        }
        return identified;
    }

    private List<ColumnOp> getAggregateColumn(UnnamedColumn sel) {
        ArrayList<UnnamedColumn> itemToCheck = new ArrayList<UnnamedColumn>();
        itemToCheck.add(sel);
        ArrayList<ColumnOp> columnOps = new ArrayList<ColumnOp>();
        while (!itemToCheck.isEmpty()) {
            SelectItem s = (SelectItem)itemToCheck.get(0);
            itemToCheck.remove(0);
            if (!(s instanceof ColumnOp)) continue;
            if (((ColumnOp)s).getOpType().equals("count") || ((ColumnOp)s).getOpType().equals("sum") || ((ColumnOp)s).getOpType().equals("avg") || ((ColumnOp)s).getOpType().equals("max") || ((ColumnOp)s).getOpType().equals("min")) {
                columnOps.add((ColumnOp)s);
                continue;
            }
            itemToCheck.addAll(((ColumnOp)s).getOperands());
        }
        return columnOps;
    }

    private List<AggExecutionNodeBlock> identifyTopAggBlocks(ScrambleMetaSet scrambleMeta, ExecutableNodeBase root) {
        ArrayList<AggExecutionNodeBlock> aggblocks = new ArrayList<AggExecutionNodeBlock>();
        if (root instanceof AggExecutionNode && this.doesContainScramble(root, scrambleMeta)) {
            AggExecutionNodeBlock block = new AggExecutionNodeBlock(root);
            aggblocks.add(block);
            return aggblocks;
        }
        for (ExecutableNodeBase dep : root.getExecutableNodeBaseDependents()) {
            List<AggExecutionNodeBlock> depAggBlocks = this.identifyTopAggBlocks(scrambleMeta, dep);
            aggblocks.addAll(depAggBlocks);
        }
        return aggblocks;
    }

    private boolean doesContainScramble(ExecutableNodeBase node, ScrambleMetaSet scrambleMeta) {
        SelectQuery query = ((QueryNodeBase)node).getSelectQuery();
        for (AbstractRelation rel : query.getFromList()) {
            if (rel instanceof BaseTable) {
                String tableName;
                BaseTable base = (BaseTable)rel;
                String schemaName = base.getSchemaName();
                if (!scrambleMeta.isScrambled(schemaName, tableName = base.getTableName())) continue;
                return true;
            }
            if (!(rel instanceof JoinTable)) continue;
            for (AbstractRelation r : ((JoinTable)rel).getJoinList()) {
                String tableName;
                BaseTable base;
                String schemaName;
                if (!(r instanceof BaseTable) || !scrambleMeta.isScrambled(schemaName = (base = (BaseTable)r).getSchemaName(), tableName = base.getTableName())) continue;
                return true;
            }
        }
        for (ExecutableNodeBase dep : node.getExecutableNodeBaseDependents()) {
            if (dep instanceof AggExecutionNode || !this.doesContainScramble(dep, scrambleMeta)) continue;
            return true;
        }
        return false;
    }

    private List<BaseTable> getMultiTierScramble(ExecutableNodeBase node, ScrambleMetaSet scrambleMeta) {
        SelectQuery query = ((QueryNodeBase)node).getSelectQuery();
        ArrayList<BaseTable> multiTierScrambleTables = new ArrayList<BaseTable>();
        for (AbstractRelation rel : query.getFromList()) {
            if (rel instanceof BaseTable) {
                String tableName;
                BaseTable base = (BaseTable)rel;
                String schemaName = base.getSchemaName();
                if (!scrambleMeta.isScrambled(schemaName, tableName = base.getTableName()) || scrambleMeta.getMetaForTable(schemaName, tableName).getNumberOfTiers() <= 1) continue;
                multiTierScrambleTables.add(base);
                continue;
            }
            if (!(rel instanceof JoinTable)) continue;
            for (AbstractRelation r : ((JoinTable)rel).getJoinList()) {
                String tableName;
                BaseTable base;
                String schemaName;
                if (!(r instanceof BaseTable) || !scrambleMeta.isScrambled(schemaName = (base = (BaseTable)r).getSchemaName(), tableName = base.getTableName()) || scrambleMeta.getMetaForTable(schemaName, tableName).getNumberOfTiers() <= 1) continue;
                multiTierScrambleTables.add(base);
            }
        }
        return multiTierScrambleTables;
    }

    private ExecutableNodeBase rewriteSelectListOfRootAndListedDependents(ExecutableNodeBase root, List<ExecutableNodeBase> nodeList) {
        ArrayList<ExecutableNodeBase> visitList = new ArrayList<ExecutableNodeBase>();
        ExecutableNodeBase rewritten = this.rewriteSelectListOfRootAndListedDependentsInner(root, nodeList, visitList);
        return rewritten;
    }

    private ExecutableNodeBase rewriteSelectListOfRootAndListedDependentsInner(ExecutableNodeBase root, List<ExecutableNodeBase> nodeList, List<ExecutableNodeBase> visitList) {
        return null;
    }

    private List<SelectItem> rewriteSelectlistWithBasicAgg(SelectQuery query, AggMeta meta) {
        List<SelectItem> selectList = query.getSelectList();
        ArrayList<String> aggColumnAlias = new ArrayList<String>();
        HashMap<String, String> maxminAlias = new HashMap<String, String>();
        ArrayList<SelectItem> newSelectlist = new ArrayList<SelectItem>();
        meta.setOriginalSelectList(selectList);
        for (SelectItem selectItem : selectList) {
            if (selectItem instanceof AliasedColumn) {
                List<ColumnOp> columnOps = this.getAggregateColumn(((AliasedColumn)selectItem).getColumn());
                if (!columnOps.isEmpty()) {
                    meta.getAggColumn().put(selectItem, columnOps);
                    for (ColumnOp col : columnOps) {
                        ColumnOp col1;
                        if (col.getOpType().equals("avg")) {
                            if (!meta.getAggColumnAggAliasPair().containsKey(new ImmutablePair((Object)"sum", (Object)col.getOperand(0)))) {
                                col1 = new ColumnOp("sum", col.getOperand(0));
                                newSelectlist.add(new AliasedColumn(col1, "agg" + this.aggColumnIdentiferNum));
                                meta.getAggColumnAggAliasPair().put((Pair<String, UnnamedColumn>)new ImmutablePair((Object)"sum", (Object)col1.getOperand(0)), "agg" + this.aggColumnIdentiferNum);
                                aggColumnAlias.add("agg" + this.aggColumnIdentiferNum++);
                            }
                            if (meta.getAggColumnAggAliasPair().containsKey(new ImmutablePair((Object)"count", (Object)new AsteriskColumn()))) continue;
                            ColumnOp col2 = new ColumnOp("count", new AsteriskColumn());
                            newSelectlist.add(new AliasedColumn(col2, "agg" + this.aggColumnIdentiferNum));
                            meta.getAggColumnAggAliasPair().put((Pair<String, UnnamedColumn>)new ImmutablePair((Object)"count", (Object)new AsteriskColumn()), "agg" + this.aggColumnIdentiferNum);
                            aggColumnAlias.add("agg" + this.aggColumnIdentiferNum++);
                            continue;
                        }
                        if (col.getOpType().equals("count") || col.getOpType().equals("sum")) {
                            if (col.getOpType().equals("count") && !meta.getAggColumnAggAliasPair().containsKey(new ImmutablePair((Object)"count", (Object)new AsteriskColumn()))) {
                                col1 = new ColumnOp(col.getOpType());
                                newSelectlist.add(new AliasedColumn(col1, "agg" + this.aggColumnIdentiferNum));
                                meta.getAggColumnAggAliasPair().put((Pair<String, UnnamedColumn>)new ImmutablePair((Object)col.getOpType(), (Object)new AsteriskColumn()), "agg" + this.aggColumnIdentiferNum);
                                aggColumnAlias.add("agg" + this.aggColumnIdentiferNum++);
                                continue;
                            }
                            if (!col.getOpType().equals("sum") || meta.getAggColumnAggAliasPair().containsKey(new ImmutablePair((Object)col.getOpType(), (Object)col.getOperand(0)))) continue;
                            col1 = new ColumnOp(col.getOpType(), col.getOperand(0));
                            newSelectlist.add(new AliasedColumn(col1, "agg" + this.aggColumnIdentiferNum));
                            meta.getAggColumnAggAliasPair().put((Pair<String, UnnamedColumn>)new ImmutablePair((Object)col.getOpType(), (Object)col1.getOperand(0)), "agg" + this.aggColumnIdentiferNum);
                            aggColumnAlias.add("agg" + this.aggColumnIdentiferNum++);
                            continue;
                        }
                        if (!col.getOpType().equals("max") && !col.getOpType().equals("min")) continue;
                        col1 = new ColumnOp(col.getOpType(), col.getOperand(0));
                        newSelectlist.add(new AliasedColumn(col1, "agg" + this.aggColumnIdentiferNum));
                        meta.getAggColumnAggAliasPairOfMaxMin().put((Pair<String, UnnamedColumn>)new ImmutablePair((Object)col.getOpType(), (Object)col1.getOperand(0)), "agg" + this.aggColumnIdentiferNum);
                        maxminAlias.put("agg" + this.aggColumnIdentiferNum++, col.getOpType());
                    }
                    continue;
                }
                newSelectlist.add(selectItem);
                continue;
            }
            newSelectlist.add(selectItem);
        }
        meta.setAggAlias(aggColumnAlias);
        meta.setMaxminAggAlias(maxminAlias);
        return newSelectlist;
    }

    private void addTierColumn(SelectQuery query, List<SelectItem> newSelectList, ScrambleMetaSet scrambleMeta, List<ProjectionNode> projectionNodeSources) {
        for (AbstractRelation table : query.getFromList()) {
            if (table instanceof BaseTable) {
                String string;
                String schemaName = ((BaseTable)table).getSchemaName();
                if (!scrambleMeta.isScrambled(schemaName, string = ((BaseTable)table).getTableName()) || scrambleMeta.getMetaForTable(schemaName, string).getNumberOfTiers() <= 1) continue;
                newSelectList.add(new AliasedColumn(new BaseColumn(schemaName, string, (String)table.getAliasName().get(), scrambleMeta.getTierColumn(schemaName, string)), VERDICTDB_TIER_COLUMN_NAME + this.verdictdbTierIndentiferNum));
                query.addGroupby(new AliasReference(VERDICTDB_TIER_COLUMN_NAME + this.verdictdbTierIndentiferNum++));
                continue;
            }
            if (!(table instanceof JoinTable)) continue;
            for (AbstractRelation abstractRelation : ((JoinTable)table).getJoinList()) {
                String tableName;
                String schemaName;
                if (!(abstractRelation instanceof BaseTable) || !scrambleMeta.isScrambled(schemaName = ((BaseTable)abstractRelation).getSchemaName(), tableName = ((BaseTable)abstractRelation).getTableName()) || scrambleMeta.getMetaForTable(schemaName, tableName).getNumberOfTiers() <= 1) continue;
                newSelectList.add(new AliasedColumn(new BaseColumn(schemaName, tableName, (String)abstractRelation.getAliasName().get(), scrambleMeta.getTierColumn(schemaName, tableName)), VERDICTDB_TIER_COLUMN_NAME + this.verdictdbTierIndentiferNum));
                query.addGroupby(new AliasReference(VERDICTDB_TIER_COLUMN_NAME + this.verdictdbTierIndentiferNum++));
            }
        }
        for (ProjectionNode source : projectionNodeSources) {
            for (Map.Entry entry : source.getAggMeta().getScrambleTableTierColumnAlias().entrySet()) {
                AliasedColumn selectItem;
                String oldtierAlias = (String)entry.getValue();
                String tierColumnAlias = VERDICTDB_TIER_COLUMN_NAME + this.verdictdbTierIndentiferNum++;
                if (source.getSelectQuery().getAliasName().isPresent()) {
                    String sourceAlias = (String)source.getSelectQuery().getAliasName().get();
                    selectItem = new AliasedColumn(new BaseColumn(sourceAlias, oldtierAlias), tierColumnAlias);
                } else {
                    selectItem = new AliasedColumn(new BaseColumn(oldtierAlias), tierColumnAlias);
                }
                newSelectList.add(selectItem);
                query.addGroupby(new AliasReference(tierColumnAlias));
            }
        }
        this.verdictdbTierIndentiferNum = 0;
    }

    private void rewriteProjectionNodeForMultiTier(ProjectionNode node, List<BaseTable> MultiTiertables, ScrambleMetaSet scrambleMeta) {
        List<SelectItem> selectItemList = node.getSelectQuery().getSelectList();
        if (selectItemList.get(0) instanceof AsteriskColumn) {
            for (BaseTable t : MultiTiertables) {
                String tierColumnAlias = VERDICTDB_TIER_COLUMN_NAME + this.verdictdbTierIndentiferNum++;
                ScrambleMeta meta = scrambleMeta.getMetaForTable(t.getSchemaName(), t.getTableName());
                node.getAggMeta().getScrambleTableTierColumnAlias().put(meta, tierColumnAlias);
            }
        } else {
            for (BaseTable t : MultiTiertables) {
                String tierColumnName = scrambleMeta.getTierColumn(t.getSchemaName(), t.getTableName());
                String tierColumnAlias = VERDICTDB_TIER_COLUMN_NAME + this.verdictdbTierIndentiferNum++;
                AliasedColumn tierColumn = t.getAliasName().isPresent() ? new AliasedColumn(new BaseColumn((String)t.getAliasName().get(), tierColumnName), tierColumnAlias) : new AliasedColumn(new BaseColumn(t.getTableName(), tierColumnName), tierColumnAlias);
                selectItemList.add(tierColumn);
                ScrambleMeta meta = scrambleMeta.getMetaForTable(t.getSchemaName(), t.getTableName());
                node.getAggMeta().getScrambleTableTierColumnAlias().put(meta, tierColumnAlias);
            }
        }
        this.verdictdbTierIndentiferNum = 0;
    }

    public void rewrittenProjectionNode(AggExecutionNodeBlock block, ProjectionNode node) {
        if (node.getSources().size() == 0) {
            List<BaseTable> multiTierScrambleTables = this.getMultiTierScramble(node, this.scrambleMeta);
            if (!multiTierScrambleTables.isEmpty()) {
                this.rewriteProjectionNodeForMultiTier(node, multiTierScrambleTables, this.scrambleMeta);
            }
            return;
        }
        ArrayList<ProjectionNode> projectionNodesSources = new ArrayList<ProjectionNode>();
        for (ExecutableNode executableNode : node.getSources()) {
            if (!(executableNode instanceof ProjectionNode) || !block.getNodesInBlock().contains(executableNode)) continue;
            projectionNodesSources.add((ProjectionNode)executableNode);
        }
        List<SelectItem> selectItemList = node.getSelectQuery().getSelectList();
        boolean bl = selectItemList.get(0) instanceof AsteriskColumn;
        for (ProjectionNode source : projectionNodesSources) {
            for (Map.Entry<ScrambleMeta, String> entry : source.getAggMeta().getScrambleTableTierColumnAlias().entrySet()) {
                String oldtierAlias = entry.getValue();
                String tierColumnAlias = VERDICTDB_TIER_COLUMN_NAME + this.verdictdbTierIndentiferNum++;
                if (!bl) {
                    AliasedColumn selectItem;
                    if (source.getSelectQuery().getAliasName().isPresent()) {
                        String sourceAlias = (String)source.getSelectQuery().getAliasName().get();
                        selectItem = new AliasedColumn(new BaseColumn(sourceAlias, oldtierAlias), tierColumnAlias);
                    } else {
                        selectItem = new AliasedColumn(new BaseColumn(oldtierAlias), tierColumnAlias);
                    }
                    selectItemList.add(selectItem);
                }
                node.getAggMeta().getScrambleTableTierColumnAlias().put(entry.getKey(), tierColumnAlias);
            }
        }
        List<BaseTable> multiTierScrambleTables = this.getMultiTierScramble(node, this.scrambleMeta);
        if (!multiTierScrambleTables.isEmpty()) {
            this.rewriteProjectionNodeForMultiTier(node, multiTierScrambleTables, this.scrambleMeta);
        }
        this.verdictdbTierIndentiferNum = 0;
    }

    public void setTierColumnAlias(AsyncAggExecutionNode node) {
        AggExecutionNode aggNode = (AggExecutionNode)node.getSources().get(0);
        ArrayList<ProjectionNode> projectionNodeList = new ArrayList<ProjectionNode>();
        for (ExecutableNodeBase executableNodeBase : aggNode.getSources()) {
            if (!(executableNodeBase instanceof ProjectionNode)) continue;
            projectionNodeList.add((ProjectionNode)executableNodeBase);
        }
        for (ProjectionNode projectionNode : projectionNodeList) {
            for (Map.Entry<ScrambleMeta, String> entry : projectionNode.getAggMeta().getScrambleTableTierColumnAlias().entrySet()) {
                String tierColumnAlias = VERDICTDB_TIER_COLUMN_NAME + this.verdictdbTierIndentiferNum++;
                node.getAggMeta().getScrambleTableTierColumnAlias().put(entry.getKey(), tierColumnAlias);
            }
        }
        this.verdictdbTierIndentiferNum = 0;
    }

    void addTierColumnsRecursively(AggExecutionNodeBlock block, ExecutableNodeBase node, Set<ExecutableNode> visitList) {
        for (ExecutableNodeBase source : node.getSources()) {
            if (visitList.contains(source) || !block.getNodesInBlock().contains(source)) continue;
            this.addTierColumnsRecursively(block, source, visitList);
        }
        visitList.add(node);
        if (node instanceof AggExecutionNode) {
            List<SelectItem> newSelectlist = this.rewriteSelectlistWithBasicAgg(((AggExecutionNode)node).getSelectQuery(), node.getAggMeta());
            ArrayList<ProjectionNode> projectionNodeList = new ArrayList<ProjectionNode>();
            for (ExecutableNodeBase source : node.getSources()) {
                if (!(source instanceof ProjectionNode) || !block.getNodesInBlock().contains(source)) continue;
                projectionNodeList.add((ProjectionNode)source);
            }
            this.addTierColumn(((AggExecutionNode)node).getSelectQuery(), newSelectlist, this.scrambleMeta, projectionNodeList);
            ((AggExecutionNode)node).getSelectQuery().clearSelectList();
            ((AggExecutionNode)node).getSelectQuery().getSelectList().addAll(newSelectlist);
            this.aggColumnIdentiferNum = 0;
        } else if (node instanceof ProjectionNode) {
            this.rewrittenProjectionNode(block, (ProjectionNode)node);
        }
    }
}

