/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying.ola;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.querying.IdCreator;
import org.verdictdb.core.querying.ProjectionNode;
import org.verdictdb.core.querying.ola.AggMeta;
import org.verdictdb.core.querying.ola.Dimension;
import org.verdictdb.core.querying.ola.HyperTableCube;
import org.verdictdb.core.rewriter.aggresult.AggNameAndType;
import org.verdictdb.core.scrambling.ScrambleMeta;
import org.verdictdb.core.scrambling.ScrambleMetaSet;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AliasReference;
import org.verdictdb.core.sqlobject.AliasedColumn;
import org.verdictdb.core.sqlobject.AsteriskColumn;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.ConstantColumn;
import org.verdictdb.core.sqlobject.CreateTableAsSelectQuery;
import org.verdictdb.core.sqlobject.SelectItem;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.core.sqlobject.UnnamedColumn;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.exception.VerdictDBValueException;

public class AsyncAggExecutionNode
extends ProjectionNode {
    private static final long serialVersionUID = -1829554239432075523L;
    ScrambleMetaSet scrambleMeta;
    List<String> nonaggColumns;
    List<AggNameAndType> aggColumns;
    int tableNum = 1;
    HashMap<Integer, String> multipleTierTableTierInfo = new HashMap();
    Boolean Initiated = false;
    String newTableSchemaName;
    String newTableName;

    private AsyncAggExecutionNode() {
        super(null, null);
    }

    public static AsyncAggExecutionNode create(IdCreator idCreator, List<ExecutableNodeBase> individualAggs, List<ExecutableNodeBase> combiners, ScrambleMetaSet meta) throws VerdictDBValueException {
        AsyncAggExecutionNode node = new AsyncAggExecutionNode();
        node.subscribeTo(individualAggs.get(0), 0);
        for (ExecutableNodeBase c : combiners) {
            node.subscribeTo(c, 0);
        }
        node.setScrambleMeta(meta);
        node.setNamer(idCreator);
        return node;
    }

    @Override
    public SqlConvertible createQuery(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        ExecutionInfoToken token = tokens.get(0);
        List<HyperTableCube> cubes = ((AggMeta)token.getValue("aggMeta")).getCubes();
        HashMap<List<Integer>, Double> scaleFactor = this.calculateScaleFactor(cubes);
        Pair<List<ColumnOp>, SqlConvertible> aggColumnsAndQuery = this.createBaseQueryForReplacement(cubes, token);
        if (scaleFactor.size() == 1) {
            Double s = (Double)scaleFactor.values().toArray()[0];
            for (ColumnOp col : (List)aggColumnsAndQuery.getLeft()) {
                col.setOperand(0, ConstantColumn.valueOf(String.format("%.16f", s)));
            }
        } else {
            for (ColumnOp col : (List)aggColumnsAndQuery.getLeft()) {
                col.setOpType("casewhen");
                ArrayList<UnnamedColumn> operands = new ArrayList<UnnamedColumn>();
                for (Map.Entry<List<Integer>, Double> entry : scaleFactor.entrySet()) {
                    UnnamedColumn condition = this.generateCaseCondition(entry.getKey());
                    operands.add(condition);
                    ColumnOp multiply = new ColumnOp("multiply", Arrays.asList(ConstantColumn.valueOf(String.format("%.16f", entry.getValue())), col.getOperand(1)));
                    operands.add(multiply);
                }
                operands.add(ConstantColumn.valueOf(0));
                col.setOperand(operands);
            }
        }
        SelectQuery query = this.multipleTierTableTierInfo.size() > 0 ? this.sumUpTierGroup((SelectQuery)aggColumnsAndQuery.getRight(), (AggMeta)token.getValue("aggMeta")) : (SelectQuery)aggColumnsAndQuery.getRight();
        Pair<String, String> tempTableFullName = this.getNamer().generateTempTableName();
        this.newTableSchemaName = (String)tempTableFullName.getLeft();
        this.newTableName = (String)tempTableFullName.getRight();
        SelectQuery createTableQuery = this.replaceWithOriginalSelectList(query, (AggMeta)token.getValue("aggMeta"));
        if (this.selectQuery != null) {
            if (!this.selectQuery.getGroupby().isEmpty() && this.selectQuery.getHaving().isPresent()) {
                createTableQuery.addGroupby(this.selectQuery.getGroupby());
            }
            if (!this.selectQuery.getOrderby().isEmpty()) {
                createTableQuery.addOrderby(this.selectQuery.getOrderby());
            }
            if (this.selectQuery.getHaving().isPresent()) {
                createTableQuery.addHavingByAnd((UnnamedColumn)this.selectQuery.getHaving().get());
            }
            if (this.selectQuery.getLimit().isPresent()) {
                createTableQuery.addLimit((UnnamedColumn)this.selectQuery.getLimit().get());
            }
        }
        CreateTableAsSelectQuery createQuery = new CreateTableAsSelectQuery(this.newTableSchemaName, this.newTableName, createTableQuery);
        return createQuery;
    }

    @Override
    public ExecutionInfoToken createToken(DbmsQueryResult result) {
        ExecutionInfoToken token = super.createToken(result);
        token.setKeyValue("schemaName", this.newTableSchemaName);
        token.setKeyValue("tableName", this.newTableName);
        return token;
    }

    @Override
    public ExecutableNodeBase deepcopy() {
        AsyncAggExecutionNode copy = new AsyncAggExecutionNode();
        this.copyFields(this, copy);
        return copy;
    }

    void copyFields(AsyncAggExecutionNode from, AsyncAggExecutionNode to) {
        to.scrambleMeta = from.scrambleMeta;
        to.nonaggColumns = from.nonaggColumns;
        to.aggColumns = from.aggColumns;
    }

    public ScrambleMetaSet getScrambleMeta() {
        return this.scrambleMeta;
    }

    public void setScrambleMeta(ScrambleMetaSet meta) {
        this.scrambleMeta = meta;
    }

    Pair<List<ColumnOp>, SqlConvertible> createBaseQueryForReplacement(List<HyperTableCube> cubes, ExecutionInfoToken token) {
        ArrayList<ColumnOp> aggColumnlist = new ArrayList<ColumnOp>();
        SelectQuery dependentQuery = (SelectQuery)token.getValue("dependentQuery");
        List<SelectItem> newSelectList = dependentQuery.deepcopy().getSelectList();
        AggMeta aggMeta = (AggMeta)token.getValue("aggMeta");
        for (SelectItem selectItem : newSelectList) {
            String tableName;
            String schemaName;
            if (!(selectItem instanceof AliasedColumn)) continue;
            AliasedColumn aliasedColumn = (AliasedColumn)selectItem;
            int index = newSelectList.indexOf(selectItem);
            UnnamedColumn col = aliasedColumn.getColumn();
            if (aggMeta.getAggAlias().contains(aliasedColumn.getAliasName())) {
                ColumnOp aggColumn = new ColumnOp("multiply", Arrays.asList(ConstantColumn.valueOf(1.0), new BaseColumn("verdictdbbeforescaling", aliasedColumn.getAliasName())));
                aggColumnlist.add(aggColumn);
                newSelectList.set(index, new AliasedColumn(aggColumn, aliasedColumn.getAliasName()));
                continue;
            }
            if (aggMeta.getMaxminAggAlias().keySet().contains(aliasedColumn.getAliasName())) {
                newSelectList.set(index, new AliasedColumn(new BaseColumn("verdictdbbeforescaling", aliasedColumn.getAliasName()), aliasedColumn.getAliasName()));
                continue;
            }
            if (!this.Initiated.booleanValue() && col instanceof BaseColumn && this.scrambleMeta.isScrambled(schemaName = ((BaseColumn)col).getSchemaName(), tableName = ((BaseColumn)col).getTableName()) && ((BaseColumn)col).getColumnName().equals(this.scrambleMeta.getTierColumn(schemaName, tableName))) {
                for (Dimension d : cubes.get(0).getDimensions()) {
                    if (!d.getTableName().equals(tableName) || !d.getSchemaName().equals(schemaName)) continue;
                    this.multipleTierTableTierInfo.put(cubes.get(0).getDimensions().indexOf(d), aliasedColumn.getAliasName());
                    break;
                }
            }
            newSelectList.set(index, new AliasedColumn(new BaseColumn("verdictdbbeforescaling", aliasedColumn.getAliasName()), aliasedColumn.getAliasName()));
        }
        this.Initiated = true;
        SelectQuery query = SelectQuery.create(newSelectList, (AbstractRelation)new BaseTable((String)token.getValue("schemaName"), (String)token.getValue("tableName"), "verdictdbbeforescaling"));
        return new ImmutablePair(aggColumnlist, (Object)query);
    }

    public HashMap<List<Integer>, Double> calculateScaleFactor(List<HyperTableCube> cubes) {
        ScrambleMetaSet scrambleMeta = this.getScrambleMeta();
        ArrayList<ScrambleMeta> metaForTablesList = new ArrayList<ScrambleMeta>();
        ArrayList<Integer> blockCountList = new ArrayList<Integer>();
        ArrayList<Pair<Integer, Integer>> scrambleTableTierInfo = new ArrayList<Pair<Integer, Integer>>();
        for (Dimension d : cubes.get(0).getDimensions()) {
            blockCountList.add(scrambleMeta.getAggregationBlockCount(d.getSchemaName(), d.getTableName()));
            metaForTablesList.add(scrambleMeta.getMetaForTable(d.getSchemaName(), d.getTableName()));
            scrambleTableTierInfo.add((Pair<Integer, Integer>)new ImmutablePair((Object)cubes.get(0).getDimensions().indexOf(d), (Object)scrambleMeta.getMetaForTable(d.getSchemaName(), d.getTableName()).getNumberOfTiers()));
            if (scrambleMeta.getMetaForTable(d.getSchemaName(), d.getTableName()).getNumberOfTiers() <= 1 || this.Initiated.booleanValue()) continue;
            ScrambleMeta meta = scrambleMeta.getMetaForTable(d.getSchemaName(), d.getTableName());
            HashMap<ScrambleMeta, String> scrambleTableTierColumnAlias = this.getAggMeta().getScrambleTableTierColumnAlias();
            if (scrambleTableTierColumnAlias.containsKey(meta)) {
                this.multipleTierTableTierInfo.put(cubes.get(0).getDimensions().indexOf(d), scrambleTableTierColumnAlias.get(meta));
                continue;
            }
            this.multipleTierTableTierInfo.put(cubes.get(0).getDimensions().indexOf(d), scrambleMeta.getMetaForTable(d.getSchemaName(), d.getTableName()).getTierColumn());
        }
        List<List<Integer>> tierPermuation = this.generateTierPermuation(scrambleTableTierInfo);
        HashMap<List<Integer>, Double> scaleFactor = new HashMap<List<Integer>, Double>();
        for (List<Integer> tierlist : tierPermuation) {
            double total = 0.0;
            for (HyperTableCube cube : cubes) {
                double scale = 1.0;
                for (int i = 0; i < tierlist.size(); ++i) {
                    int tier = tierlist.get(i);
                    Dimension d = cube.getDimensions().get(i);
                    double prob = 0.0;
                    prob = d.getBegin() == 0 ? ((ScrambleMeta)metaForTablesList.get(i)).getCumulativeDistributionForTier(tier).get(d.getEnd()) : ((ScrambleMeta)metaForTablesList.get(i)).getCumulativeDistributionForTier(tier).get(d.getEnd()) - ((ScrambleMeta)metaForTablesList.get(i)).getCumulativeDistributionForTier(tier).get(d.getBegin() - 1);
                    scale *= prob;
                }
                total += scale;
            }
            if (total == 0.0) {
                scaleFactor.put(tierlist, 0.0);
                continue;
            }
            scaleFactor.put(tierlist, 1.0 / total);
        }
        return scaleFactor;
    }

    List<List<Integer>> generateTierPermuation(List<Pair<Integer, Integer>> scrambleTableTierInfo) {
        if (scrambleTableTierInfo.size() == 1) {
            ArrayList<List<Integer>> res = new ArrayList<List<Integer>>();
            for (int tier = 0; tier < (Integer)scrambleTableTierInfo.get(0).getRight(); ++tier) {
                res.add(Arrays.asList(tier));
            }
            return res;
        }
        List<Pair<Integer, Integer>> next = scrambleTableTierInfo.subList(1, scrambleTableTierInfo.size());
        List<List<Integer>> subres = this.generateTierPermuation(next);
        ArrayList<List<Integer>> res = new ArrayList<List<Integer>>();
        for (int tier = 0; tier < (Integer)scrambleTableTierInfo.get(0).getRight(); ++tier) {
            for (List<Integer> tierlist : subres) {
                ArrayList<Integer> newTierlist = new ArrayList<Integer>();
                for (int i : tierlist) {
                    newTierlist.add(i);
                }
                newTierlist.add(0, tier);
                res.add(newTierlist);
            }
        }
        return res;
    }

    UnnamedColumn generateCaseCondition(List<Integer> tierlist) {
        Optional col = Optional.absent();
        for (Map.Entry<Integer, String> entry : this.multipleTierTableTierInfo.entrySet()) {
            BaseColumn tierColumn = new BaseColumn("verdictdbbeforescaling", entry.getValue());
            ColumnOp equation = new ColumnOp("equal", Arrays.asList(tierColumn, ConstantColumn.valueOf(tierlist.get(entry.getKey()))));
            if (col.isPresent()) {
                col = Optional.of((Object)new ColumnOp("and", Arrays.asList(equation, (UnnamedColumn)col.get())));
                continue;
            }
            col = Optional.of((Object)equation);
        }
        return (UnnamedColumn)col.get();
    }

    SelectQuery replaceWithOriginalSelectList(SelectQuery queryToReplace, AggMeta aggMeta) {
        List<SelectItem> originalSelectList = aggMeta.getOriginalSelectList();
        HashMap<SelectItem, List<ColumnOp>> aggColumn = aggMeta.getAggColumn();
        HashMap<String, UnnamedColumn> aggContents = new HashMap<String, UnnamedColumn>();
        for (SelectItem sel : queryToReplace.getSelectList()) {
            if (sel instanceof AliasedColumn && aggMeta.getAggAlias().contains(((AliasedColumn)sel).getAliasName())) {
                aggContents.put(((AliasedColumn)sel).getAliasName(), ((AliasedColumn)sel).getColumn());
                continue;
            }
            if (!(sel instanceof AliasedColumn) || !aggMeta.getMaxminAggAlias().keySet().contains(((AliasedColumn)sel).getAliasName())) continue;
            aggContents.put(((AliasedColumn)sel).getAliasName(), ((AliasedColumn)sel).getColumn());
        }
        for (SelectItem sel : originalSelectList) {
            if (aggColumn.containsKey(sel)) {
                List<ColumnOp> columnOps = aggColumn.get(sel);
                for (ColumnOp col : columnOps) {
                    UnnamedColumn aggContent;
                    String aliasName;
                    if (col.getOpType().equals("count") || col.getOpType().equals("sum")) {
                        aliasName = col.getOpType().equals("count") ? aggMeta.getAggColumnAggAliasPair().get(new ImmutablePair((Object)col.getOpType(), (Object)new AsteriskColumn())) : aggMeta.getAggColumnAggAliasPair().get(new ImmutablePair((Object)col.getOpType(), (Object)col.getOperand(0)));
                        aggContent = (ColumnOp)aggContents.get(aliasName);
                        col.setOpType(((ColumnOp)aggContent).getOpType());
                        col.setOperand(((ColumnOp)aggContent).getOperands());
                        continue;
                    }
                    if (col.getOpType().equals("max") || col.getOpType().equals("min")) {
                        aliasName = aggMeta.getAggColumnAggAliasPairOfMaxMin().get(new ImmutablePair((Object)col.getOpType(), (Object)col.getOperand(0)));
                        if (aggContents.get(aliasName) instanceof BaseColumn) {
                            aggContent = (BaseColumn)aggContents.get(aliasName);
                            col.setOpType("multiply");
                            col.setOperand(Arrays.asList(ConstantColumn.valueOf(1), aggContent));
                            continue;
                        }
                        aggContent = (ColumnOp)aggContents.get(aliasName);
                        col.setOpType(((ColumnOp)aggContent).getOpType());
                        col.setOperand(((ColumnOp)aggContent).getOperands());
                        continue;
                    }
                    if (!col.getOpType().equals("avg")) continue;
                    String aliasNameSum = aggMeta.getAggColumnAggAliasPair().get(new ImmutablePair((Object)"sum", (Object)col.getOperand(0)));
                    ColumnOp aggContentSum = (ColumnOp)aggContents.get(aliasNameSum);
                    String aliasNameCount = aggMeta.getAggColumnAggAliasPair().get(new ImmutablePair((Object)"count", (Object)new AsteriskColumn()));
                    ColumnOp aggContentCount = (ColumnOp)aggContents.get(aliasNameCount);
                    col.setOpType("divide");
                    col.setOperand(Arrays.asList(aggContentSum, aggContentCount));
                }
                continue;
            }
            if (!(sel instanceof AliasedColumn)) continue;
            ((AliasedColumn)sel).setColumn(new BaseColumn("verdictdbbeforescaling", ((AliasedColumn)sel).getAliasName()));
            ((AliasedColumn)sel).setAliasName(((AliasedColumn)sel).getAliasName());
        }
        queryToReplace.clearSelectList();
        queryToReplace.getSelectList().addAll(originalSelectList);
        return queryToReplace;
    }

    SelectQuery sumUpTierGroup(SelectQuery subquery, AggMeta aggMeta) {
        List<String> aggAlias = aggMeta.getAggAlias();
        ArrayList<String> groupby = new ArrayList<String>();
        ArrayList<SelectItem> newSelectlist = new ArrayList<SelectItem>();
        for (SelectItem sel : subquery.getSelectList()) {
            if (!(sel instanceof AliasedColumn)) continue;
            if (aggAlias.contains(((AliasedColumn)sel).getAliasName())) {
                newSelectlist.add(new AliasedColumn(new ColumnOp("sum", new BaseColumn("verdictdbafterscaling", ((AliasedColumn)sel).getAliasName())), ((AliasedColumn)sel).getAliasName()));
                continue;
            }
            if (aggMeta.getMaxminAggAlias().keySet().contains(((AliasedColumn)sel).getAliasName())) {
                String opType = aggMeta.getMaxminAggAlias().get(((AliasedColumn)sel).getAliasName());
                newSelectlist.add(new AliasedColumn(new ColumnOp(opType, new BaseColumn("verdictdbafterscaling", ((AliasedColumn)sel).getAliasName())), ((AliasedColumn)sel).getAliasName()));
                continue;
            }
            if (this.multipleTierTableTierInfo.values().contains(((AliasedColumn)sel).getAliasName())) continue;
            newSelectlist.add(new AliasedColumn(new BaseColumn("verdictdbafterscaling", ((AliasedColumn)sel).getAliasName()), ((AliasedColumn)sel).getAliasName()));
            groupby.add(((AliasedColumn)sel).getAliasName());
        }
        subquery.setAliasName("verdictdbafterscaling");
        SelectQuery query = SelectQuery.create(newSelectlist, (AbstractRelation)subquery);
        for (String group : groupby) {
            query.addGroupby(new AliasReference(group));
        }
        return query;
    }
}

