/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying.ola;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.verdictdb.core.querying.AggExecutionNode;
import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.querying.QueryNodeBase;
import org.verdictdb.core.scrambling.ScrambleMetaSet;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.JoinTable;
import org.verdictdb.exception.VerdictDBValueException;

public class AggExecutionNodeBlock {
    ExecutableNodeBase blockRoot;
    List<ExecutableNodeBase> blockNodes;

    public AggExecutionNodeBlock(ExecutableNodeBase blockRoot) {
        this.blockRoot = blockRoot;
        this.blockNodes = this.getNodesInBlock(blockRoot);
    }

    public ExecutableNodeBase getBlockRootNode() {
        return this.blockRoot;
    }

    public List<ExecutableNodeBase> getNodesInBlock() {
        return this.blockNodes;
    }

    List<ExecutableNodeBase> getNodesInBlock(ExecutableNodeBase root) {
        ArrayList<ExecutableNodeBase> nodes = new ArrayList<ExecutableNodeBase>();
        nodes.add((QueryNodeBase)root);
        for (ExecutableNodeBase dep : root.getExecutableNodeBaseDependents()) {
            if (dep instanceof AggExecutionNode) continue;
            List<ExecutableNodeBase> depNodes = this.getNodesInBlock(dep);
            nodes.addAll(depNodes);
        }
        return nodes;
    }

    List<Pair<ExecutableNodeBase, Triple<String, String, String>>> identifyScrambledNodes(ScrambleMetaSet scrambleMeta, List<ExecutableNodeBase> blockNodes) {
        ArrayList<Pair<ExecutableNodeBase, Triple<String, String, String>>> identified = new ArrayList<Pair<ExecutableNodeBase, Triple<String, String, String>>>();
        for (ExecutableNodeBase node : blockNodes) {
            for (AbstractRelation rel : ((QueryNodeBase)node).getSelectQuery().getFromList()) {
                if (rel instanceof BaseTable) {
                    BaseTable base = (BaseTable)rel;
                    if (!scrambleMeta.isScrambled(base.getSchemaName(), base.getTableName())) continue;
                    identified.add((Pair<ExecutableNodeBase, Triple<String, String, String>>)Pair.of((Object)node, (Object)Triple.of((Object)base.getSchemaName(), (Object)base.getTableName(), (Object)base.getAliasName().get())));
                    continue;
                }
                if (!(rel instanceof JoinTable)) continue;
                for (AbstractRelation r : ((JoinTable)rel).getJoinList()) {
                    BaseTable base;
                    if (!(r instanceof BaseTable) || !scrambleMeta.isScrambled((base = (BaseTable)r).getSchemaName(), base.getTableName())) continue;
                    identified.add((Pair<ExecutableNodeBase, Triple<String, String, String>>)Pair.of((Object)node, (Object)Triple.of((Object)base.getSchemaName(), (Object)base.getTableName(), (Object)base.getAliasName().get())));
                }
            }
        }
        return identified;
    }

    String findAliasFor(String schemaName, String tableName, List<AbstractRelation> fromList) {
        for (AbstractRelation rel : fromList) {
            if (rel instanceof BaseTable) {
                BaseTable base = (BaseTable)rel;
                if (!schemaName.equals(base.getSchemaName()) || !tableName.equals(base.getTableName())) continue;
                return (String)base.getAliasName().get();
            }
            if (!(rel instanceof JoinTable)) continue;
            for (AbstractRelation r : ((JoinTable)rel).getJoinList()) {
                BaseTable base;
                if (!(r instanceof BaseTable) || !schemaName.equals((base = (BaseTable)rel).getSchemaName()) || !tableName.equals(base.getTableName())) continue;
                return (String)base.getAliasName().get();
            }
        }
        return null;
    }

    public AggExecutionNodeBlock deepcopyExcludingDependentAggregates(List<Pair<ExecutableNodeBase, ExecutableNodeBase>> oldSubscriptionInformation) throws VerdictDBValueException {
        ArrayList<ExecutableNodeBase> newNodes = new ArrayList<ExecutableNodeBase>();
        for (ExecutableNodeBase node : this.blockNodes) {
            ExecutableNodeBase copied = node.deepcopy();
            copied.cancelSubscriptionsFromAllSubscribers();
            newNodes.add(copied);
        }
        for (int i = 0; i < newNodes.size(); ++i) {
            ExecutableNodeBase newNode = (ExecutableNodeBase)newNodes.get(i);
            ExecutableNodeBase oldNode = this.blockNodes.get(i);
            for (int j = 0; j < oldNode.getSources().size(); ++j) {
                Pair<ExecutableNodeBase, Integer> source = oldNode.getSourcesAndChannels().get(j);
                int idx = this.blockNodes.indexOf(source.getLeft());
                newNode.cancelSubscriptionTo((ExecutableNodeBase)source.getLeft());
                if (idx >= 0) {
                    newNode.subscribeTo((ExecutableNodeBase)newNodes.get(idx), (Integer)source.getRight());
                    continue;
                }
                newNode.subscribeTo((ExecutableNodeBase)source.getLeft(), (Integer)source.getRight());
                oldSubscriptionInformation.add((Pair<ExecutableNodeBase, ExecutableNodeBase>)Pair.of((Object)oldNode, (Object)source.getLeft()));
            }
        }
        int rootIdx = this.blockNodes.indexOf(this.blockRoot);
        return new AggExecutionNodeBlock((ExecutableNodeBase)newNodes.get(rootIdx));
    }
}

