/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying.ola;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.querying.CreateTableAsSelectNode;
import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.querying.IdCreator;
import org.verdictdb.core.querying.QueryNodeBase;
import org.verdictdb.core.querying.SubscriptionTicket;
import org.verdictdb.core.querying.ola.AggMeta;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AliasReference;
import org.verdictdb.core.sqlobject.AliasedColumn;
import org.verdictdb.core.sqlobject.AsteriskColumn;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.SelectItem;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SetOperationRelation;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.exception.VerdictDBValueException;

public class AggCombinerExecutionNode
extends CreateTableAsSelectNode {
    private static final long serialVersionUID = -5083977853340736042L;
    AggMeta aggMeta = new AggMeta();
    static String unionTableAlias = "unionTable";

    private AggCombinerExecutionNode(IdCreator namer) {
        super(namer, null);
    }

    public static AggCombinerExecutionNode create(IdCreator namer, ExecutableNodeBase leftQueryExecutionNode, ExecutableNodeBase rightQueryExecutionNode) throws VerdictDBValueException {
        AggCombinerExecutionNode node = new AggCombinerExecutionNode(namer);
        SelectQuery rightQuery = ((QueryNodeBase)rightQueryExecutionNode).getSelectQuery();
        String leftAliasName = namer.generateAliasName();
        String rightAliasName = namer.generateAliasName();
        Pair<BaseTable, SubscriptionTicket> leftBaseAndTicket = node.createPlaceHolderTable(leftAliasName);
        Pair<BaseTable, SubscriptionTicket> rightBaseAndTicket = node.createPlaceHolderTable(rightAliasName);
        SelectQuery joinQuery = AggCombinerExecutionNode.composeUnionQuery(rightQuery, (BaseTable)leftBaseAndTicket.getLeft(), (BaseTable)rightBaseAndTicket.getLeft());
        leftQueryExecutionNode.registerSubscriber((SubscriptionTicket)leftBaseAndTicket.getRight());
        rightQueryExecutionNode.registerSubscriber((SubscriptionTicket)rightBaseAndTicket.getRight());
        node.setSelectQuery(joinQuery);
        return node;
    }

    static SelectQuery composeUnionQuery(SelectQuery rightQuery, BaseTable leftBase, BaseTable rightBase) {
        ArrayList<SelectItem> allItems = new ArrayList<SelectItem>();
        ArrayList<String> groupAliasNames = new ArrayList<String>();
        for (SelectItem item : rightQuery.getSelectList()) {
            if (item.isAggregateColumn()) {
                if (item instanceof AliasedColumn && ((AliasedColumn)item).getColumn() instanceof ColumnOp && (((ColumnOp)((AliasedColumn)item).getColumn()).getOpType().equals("max") || ((ColumnOp)((AliasedColumn)item).getColumn()).getOpType().equals("min"))) {
                    allItems.add(new AliasedColumn(new ColumnOp(((ColumnOp)((AliasedColumn)item).getColumn()).getOpType(), new BaseColumn(unionTableAlias, ((AliasedColumn)item).getAliasName())), ((AliasedColumn)item).getAliasName()));
                    continue;
                }
                allItems.add(new AliasedColumn(ColumnOp.sum(new BaseColumn(unionTableAlias, ((AliasedColumn)item).getAliasName())), ((AliasedColumn)item).getAliasName()));
                continue;
            }
            allItems.add(new AliasedColumn(new BaseColumn(unionTableAlias, ((AliasedColumn)item).getAliasName()), ((AliasedColumn)item).getAliasName()));
            groupAliasNames.add(((AliasedColumn)item).getAliasName());
        }
        SelectQuery left = SelectQuery.create(new AsteriskColumn(), (AbstractRelation)leftBase);
        SelectQuery right = SelectQuery.create(new AsteriskColumn(), (AbstractRelation)rightBase);
        SetOperationRelation newBase = new SetOperationRelation(left, right, SetOperationRelation.SetOpType.unionAll);
        newBase.setAliasName(unionTableAlias);
        SelectQuery unionQuery = SelectQuery.create(allItems, (AbstractRelation)newBase);
        for (String a : groupAliasNames) {
            unionQuery.addGroupby(new AliasReference(a));
        }
        return unionQuery;
    }

    @Override
    public SqlConvertible createQuery(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        for (ExecutionInfoToken token : tokens) {
            AggMeta aggMeta = (AggMeta)token.getValue("aggMeta");
            if (aggMeta == null) continue;
            this.aggMeta.getCubes().addAll(aggMeta.getCubes());
            this.aggMeta.setAggAlias(aggMeta.getAggAlias());
            this.aggMeta.setOriginalSelectList(aggMeta.getOriginalSelectList());
            this.aggMeta.setAggColumn(aggMeta.getAggColumn());
            this.aggMeta.setAggColumnAggAliasPair(aggMeta.getAggColumnAggAliasPair());
            this.aggMeta.setAggColumnAggAliasPairOfMaxMin(aggMeta.getAggColumnAggAliasPairOfMaxMin());
            this.aggMeta.setMaxminAggAlias(aggMeta.getMaxminAggAlias());
        }
        return super.createQuery(tokens);
    }

    @Override
    public ExecutionInfoToken createToken(DbmsQueryResult result) {
        ExecutionInfoToken token = super.createToken(result);
        token.setKeyValue("aggMeta", this.aggMeta);
        token.setKeyValue("dependentQuery", this.selectQuery);
        return token;
    }
}

