/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.core.querying.IdCreator;

public class TempIdCreatorInScratchpadSchema
implements IdCreator,
Serializable {
    private static final long serialVersionUID = -8241890224536966759L;
    String scratchpadSchemaName;
    final int serialNum = ThreadLocalRandom.current().nextInt(0, 1000000);
    int identifierNum = 0;

    public TempIdCreatorInScratchpadSchema(String scratchpadSchemaName) {
        this.scratchpadSchemaName = scratchpadSchemaName;
    }

    public int getSerialNumber() {
        return this.serialNum;
    }

    public void reset() {
        this.identifierNum = 0;
    }

    public String getScratchpadSchemaName() {
        return this.scratchpadSchemaName;
    }

    synchronized String generateUniqueIdentifier() {
        return String.format("%d_%d", this.serialNum, this.identifierNum++);
    }

    @Override
    public String generateAliasName() {
        return String.format("verdictdbalias_%s", this.generateUniqueIdentifier());
    }

    @Override
    public Pair<String, String> generateTempTableName() {
        return Pair.of((Object)this.scratchpadSchemaName, (Object)String.format("verdictdbtemptable_%s", this.generateUniqueIdentifier()));
    }
}

