/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying;

import java.util.ArrayList;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.core.querying.AggExecutionNode;
import org.verdictdb.core.querying.CreateTableAsSelectNode;
import org.verdictdb.core.querying.IdCreator;
import org.verdictdb.core.querying.ProjectionNode;
import org.verdictdb.core.querying.SubscriptionTicket;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AliasedColumn;
import org.verdictdb.core.sqlobject.AsteriskColumn;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.JoinTable;
import org.verdictdb.core.sqlobject.SelectItem;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SubqueryColumn;
import org.verdictdb.core.sqlobject.UnnamedColumn;

public class SubqueriesToDependentNodes {
    public static void convertSubqueriesToDependentNodes(SelectQuery query, CreateTableAsSelectNode node) {
        IdCreator namer = node.getNamer();
        for (AbstractRelation source : query.getFromList()) {
            int index = query.getFromList().indexOf(source);
            if (source instanceof SelectQuery) {
                CreateTableAsSelectNode dep = source.isSupportedAggregate() ? AggExecutionNode.create(namer, (SelectQuery)source) : ProjectionNode.create(namer, (SelectQuery)source);
                Pair<BaseTable, SubscriptionTicket> baseAndSubscriptionTicket = node.createPlaceHolderTable((String)source.getAliasName().get());
                query.getFromList().set(index, (AbstractRelation)baseAndSubscriptionTicket.getLeft());
                dep.registerSubscriber((SubscriptionTicket)baseAndSubscriptionTicket.getRight());
                continue;
            }
            if (!(source instanceof JoinTable)) continue;
            for (AbstractRelation s : ((JoinTable)source).getJoinList()) {
                int joinindex = ((JoinTable)source).getJoinList().indexOf(s);
                if (!(s instanceof SelectQuery)) continue;
                CreateTableAsSelectNode dep = s.isSupportedAggregate() ? AggExecutionNode.create(namer, (SelectQuery)s) : ProjectionNode.create(namer, (SelectQuery)s);
                Pair<BaseTable, SubscriptionTicket> baseAndSubscriptionTicket = node.createPlaceHolderTable((String)s.getAliasName().get());
                ((JoinTable)source).getJoinList().set(joinindex, (AbstractRelation)baseAndSubscriptionTicket.getLeft());
                dep.registerSubscriber((SubscriptionTicket)baseAndSubscriptionTicket.getRight());
            }
        }
        if (query.getFilter().isPresent()) {
            UnnamedColumn where = (UnnamedColumn)query.getFilter().get();
            ArrayList<UnnamedColumn> filters = new ArrayList<UnnamedColumn>();
            filters.add(where);
            while (!filters.isEmpty()) {
                UnnamedColumn filter = (UnnamedColumn)filters.get(0);
                filters.remove(0);
                if (filter instanceof SubqueryColumn) {
                    Pair<BaseTable, SubscriptionTicket> baseAndSubscriptionTicket = ((SubqueryColumn)filter).getSubquery().getAliasName().isPresent() ? node.createPlaceHolderTable((String)((SubqueryColumn)filter).getSubquery().getAliasName().get()) : node.createPlaceHolderTable(namer.generateAliasName());
                    BaseTable base = (BaseTable)baseAndSubscriptionTicket.getLeft();
                    SelectQuery subquery = ((SubqueryColumn)filter).getSubquery();
                    CreateTableAsSelectNode dep = subquery.isSupportedAggregate() ? AggExecutionNode.create(namer, subquery) : ProjectionNode.create(namer, subquery);
                    dep.registerSubscriber((SubscriptionTicket)baseAndSubscriptionTicket.getRight());
                    ArrayList<SelectItem> newSelectItem = new ArrayList<SelectItem>();
                    for (SelectItem item : subquery.getSelectList()) {
                        if (item instanceof AliasedColumn) {
                            newSelectItem.add(new AliasedColumn(new BaseColumn(base.getSchemaName(), (String)base.getAliasName().get(), ((AliasedColumn)item).getAliasName()), ((AliasedColumn)item).getAliasName()));
                            continue;
                        }
                        if (!(item instanceof AsteriskColumn)) continue;
                        newSelectItem.add(new AsteriskColumn());
                    }
                    SelectQuery newSubquery = SelectQuery.create(newSelectItem, (AbstractRelation)base);
                    if (((SubqueryColumn)filter).getSubquery().getAliasName().isPresent()) {
                        newSubquery.setAliasName((String)((SubqueryColumn)filter).getSubquery().getAliasName().get());
                    }
                    ((SubqueryColumn)filter).setSubquery(newSubquery);
                    node.getPlaceholderTablesinFilter().add((SubqueryColumn)filter);
                    continue;
                }
                if (!(filter instanceof ColumnOp)) continue;
                filters.addAll(((ColumnOp)filter).getOperands());
            }
        }
    }
}

