/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.querying.AggExecutionNode;
import org.verdictdb.core.querying.CreateTableAsSelectNode;
import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.querying.IdCreator;
import org.verdictdb.core.querying.ProjectionNode;
import org.verdictdb.core.querying.QueryNodeWithPlaceHolders;
import org.verdictdb.core.querying.SubscriptionTicket;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AsteriskColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.core.sqlobject.UnnamedColumn;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.exception.VerdictDBValueException;

public class SelectAllExecutionNode
extends QueryNodeWithPlaceHolders {
    private SelectAllExecutionNode(SelectQuery query) {
        super(query);
    }

    public static SelectAllExecutionNode create(IdCreator namer, SelectQuery query) throws VerdictDBValueException {
        SelectAllExecutionNode selectAll = new SelectAllExecutionNode(null);
        Pair<BaseTable, SubscriptionTicket> baseAndSubscriptionTicket = selectAll.createPlaceHolderTable("t");
        SelectQuery selectQuery = SelectQuery.create(new AsteriskColumn(), (AbstractRelation)baseAndSubscriptionTicket.getLeft());
        selectQuery.addOrderby(query.getOrderby());
        if (query.getLimit().isPresent()) {
            selectQuery.addLimit((UnnamedColumn)query.getLimit().get());
        }
        selectAll.setSelectQuery(selectQuery);
        if (query.isSupportedAggregate()) {
            AggExecutionNode dependent = AggExecutionNode.create(namer, query);
            dependent.registerSubscriber((SubscriptionTicket)baseAndSubscriptionTicket.getRight());
        } else {
            ProjectionNode dependent = ProjectionNode.create(namer, query);
            dependent.registerSubscriber((SubscriptionTicket)baseAndSubscriptionTicket.getRight());
        }
        return selectAll;
    }

    @Override
    public SqlConvertible createQuery(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        return super.createQuery(tokens);
    }

    @Override
    public ExecutionInfoToken createToken(DbmsQueryResult result) {
        ExecutionInfoToken token = new ExecutionInfoToken();
        token.setKeyValue("queryResult", result);
        return token;
    }

    @Override
    public ExecutableNodeBase deepcopy() {
        SelectAllExecutionNode node = new SelectAllExecutionNode(this.selectQuery);
        this.copyFields(this, node);
        return node;
    }

    void copyFields(CreateTableAsSelectNode from, CreateTableAsSelectNode to) {
        super.copyFields(from, to);
    }
}

