/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.querying.QueryNodeBase;
import org.verdictdb.core.querying.SubscriptionTicket;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.JoinTable;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.core.sqlobject.SubqueryColumn;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.exception.VerdictDBValueException;

public abstract class QueryNodeWithPlaceHolders
extends QueryNodeBase {
    private static final long serialVersionUID = 5770210201301837177L;
    List<BaseTable> placeholderTables = new ArrayList<BaseTable>();
    List<SubqueryColumn> placeholderTablesinFilter = new ArrayList<SubqueryColumn>();

    public QueryNodeWithPlaceHolders(SelectQuery query) {
        super(query);
    }

    public Pair<BaseTable, SubscriptionTicket> createPlaceHolderTable(String aliasName) {
        BaseTable table = new BaseTable("placeholderSchemaName", "placeholderTableName", aliasName);
        this.placeholderTables.add(table);
        SubscriptionTicket ticket = this.createSubscriptionTicket();
        return Pair.of((Object)table, (Object)ticket);
    }

    @Override
    public SqlConvertible createQuery(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        if (tokens == null) {
            return null;
        }
        if (tokens.size() < this.placeholderTables.size()) {
            throw new VerdictDBValueException("Not enough temp tables to plug into placeholder tables.");
        }
        for (int i = 0; i < this.placeholderTables.size(); ++i) {
            BaseTable t = this.placeholderTables.get(i);
            ExecutionInfoToken r = tokens.get(i);
            String schemaName = (String)r.getValue("schemaName");
            String tableName = (String)r.getValue("tableName");
            t.setSchemaName(schemaName);
            t.setTableName(tableName);
        }
        return this.selectQuery;
    }

    public List<BaseTable> getPlaceholderTables() {
        return this.placeholderTables;
    }

    public List<SubqueryColumn> getPlaceholderTablesinFilter() {
        return this.placeholderTablesinFilter;
    }

    protected void copyFields(QueryNodeWithPlaceHolders from, QueryNodeWithPlaceHolders to) {
        super.copyFields(from, to);
        to.placeholderTables = new ArrayList<BaseTable>();
        to.placeholderTables.addAll(from.placeholderTables);
        to.placeholderTablesinFilter = new ArrayList<SubqueryColumn>();
        to.placeholderTablesinFilter.addAll(from.placeholderTablesinFilter);
        this.deepcopyPlaceHolderTable(to.placeholderTables, to.selectQuery);
    }

    private void deepcopyPlaceHolderTable(List<BaseTable> to, SelectQuery relation) {
        ArrayList<SelectQuery> queries = new ArrayList<SelectQuery>();
        queries.add(relation);
        while (!queries.isEmpty()) {
            SelectQuery query = (SelectQuery)queries.get(0);
            queries.remove(0);
            for (AbstractRelation t : query.getFromList()) {
                if (t instanceof BaseTable && to.contains(t)) {
                    BaseTable newT = new BaseTable(((BaseTable)t).getSchemaName(), ((BaseTable)t).getTableName());
                    if (t.getAliasName().isPresent()) {
                        newT.setAliasName((String)t.getAliasName().get());
                    }
                    query.getFromList().set(query.getFromList().indexOf(t), newT);
                    to.set(to.indexOf(t), newT);
                    continue;
                }
                if (t instanceof SelectQuery) {
                    queries.add((SelectQuery)t);
                    continue;
                }
                if (!(t instanceof JoinTable)) continue;
                for (AbstractRelation join : ((JoinTable)t).getJoinList()) {
                    if (join instanceof BaseTable && to.contains(join)) {
                        BaseTable newT = new BaseTable(((BaseTable)join).getSchemaName(), ((BaseTable)join).getTableName());
                        if (join.getAliasName().isPresent()) {
                            newT.setAliasName((String)join.getAliasName().get());
                        }
                        ((JoinTable)t).getJoinList().set(((JoinTable)t).getJoinList().indexOf(join), newT);
                        to.set(to.indexOf(join), newT);
                        continue;
                    }
                    if (!(join instanceof SelectQuery)) continue;
                    queries.add((SelectQuery)join);
                }
            }
        }
    }
}

