/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.core.execplan.ExecutableNode;
import org.verdictdb.core.querying.AggExecutionNode;
import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.querying.ProjectionNode;
import org.verdictdb.core.querying.QueryExecutionPlan;
import org.verdictdb.core.querying.QueryNodeBase;
import org.verdictdb.core.querying.QueryNodeWithPlaceHolders;
import org.verdictdb.core.querying.SelectAllExecutionNode;
import org.verdictdb.core.querying.ola.AsyncAggExecutionNode;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.JoinTable;
import org.verdictdb.core.sqlobject.SubqueryColumn;

public class QueryExecutionPlanSimplifier {
    public static QueryExecutionPlan simplify(QueryExecutionPlan originalPlan) {
        QueryExecutionPlan plan = originalPlan.deepcopy();
        ArrayList<ExecutableNodeBase> nodesToCompress = new ArrayList<ExecutableNodeBase>();
        ArrayList<ExecutableNodeBase> traverse = new ArrayList<ExecutableNodeBase>();
        traverse.add(plan.getRoot());
        while (!traverse.isEmpty()) {
            ExecutableNodeBase node = (ExecutableNodeBase)traverse.get(0);
            traverse.remove(0);
            if (node.getDependentNodeCount() == 0 && !nodesToCompress.contains(node)) {
                nodesToCompress.add(node);
                continue;
            }
            traverse.addAll(node.getExecutableNodeBaseDependents());
        }
        ArrayList<ExecutableNodeBase> history = new ArrayList<ExecutableNodeBase>();
        while (!nodesToCompress.isEmpty()) {
            ExecutableNodeBase parent;
            boolean compressable;
            ExecutableNodeBase node = (ExecutableNodeBase)nodesToCompress.remove(0);
            ArrayList<ExecutableNodeBase> nodeParentsSaved = new ArrayList<ExecutableNodeBase>(node.getExecutableNodeBaseParents());
            boolean bl = compressable = node.getExecutableNodeBaseParents().size() == 1 && !QueryExecutionPlanSimplifier.isSharingQueue(node);
            if (compressable && ((parent = node.getExecutableNodeBaseParents().get(0)) instanceof AggExecutionNode || parent instanceof SelectAllExecutionNode || parent instanceof ProjectionNode && !(parent instanceof AsyncAggExecutionNode)) && (node instanceof AggExecutionNode || node instanceof SelectAllExecutionNode || node instanceof ProjectionNode && !(node instanceof AsyncAggExecutionNode))) {
                QueryExecutionPlanSimplifier.compressTwoNode(node, parent);
            }
            history.add(node);
            for (ExecutableNodeBase parent2 : nodeParentsSaved) {
                if (history.contains(parent2) || nodesToCompress.contains(parent2)) continue;
                nodesToCompress.add(parent2);
            }
        }
        return plan;
    }

    static void compressTwoNode(ExecutableNodeBase node, ExecutableNodeBase parent) {
        if (!(node instanceof QueryNodeBase) || !(parent instanceof QueryNodeBase)) {
            return;
        }
        QueryNodeBase parentQuery = (QueryNodeBase)parent;
        QueryNodeBase nodeQuery = (QueryNodeBase)node;
        BaseTable placeholderTableinParent = ((QueryNodeWithPlaceHolders)parent).getPlaceholderTables().get(parent.getExecutableNodeBaseDependents().indexOf(node));
        ((QueryNodeWithPlaceHolders)parent).getPlaceholderTables().remove(placeholderTableinParent);
        boolean find = false;
        for (AbstractRelation abstractRelation : parentQuery.getSelectQuery().getFromList()) {
            if (abstractRelation instanceof BaseTable && abstractRelation.equals(placeholderTableinParent)) {
                int index = parentQuery.getSelectQuery().getFromList().indexOf(abstractRelation);
                nodeQuery.getSelectQuery().setAliasName((String)parentQuery.getSelectQuery().getFromList().get(index).getAliasName().get());
                parentQuery.getSelectQuery().getFromList().set(index, nodeQuery.getSelectQuery());
                find = true;
                break;
            }
            if (!(abstractRelation instanceof JoinTable)) continue;
            for (AbstractRelation joinTable : ((JoinTable)abstractRelation).getJoinList()) {
                if (!(joinTable instanceof BaseTable) || !joinTable.equals(placeholderTableinParent)) continue;
                int index = ((JoinTable)abstractRelation).getJoinList().indexOf(joinTable);
                nodeQuery.getSelectQuery().setAliasName((String)joinTable.getAliasName().get());
                ((JoinTable)abstractRelation).getJoinList().set(index, nodeQuery.getSelectQuery());
                find = true;
                break;
            }
            if (!find) continue;
            break;
        }
        if (!find) {
            List<SubqueryColumn> placeholderTablesinFilter = ((QueryNodeWithPlaceHolders)parent).getPlaceholderTablesinFilter();
            for (SubqueryColumn filter : placeholderTablesinFilter) {
                if (filter.getSubquery().getFromList().size() != 1 || !filter.getSubquery().getFromList().get(0).equals(placeholderTableinParent)) continue;
                filter.setSubquery(nodeQuery.getSelectQuery());
            }
        }
        ((QueryNodeWithPlaceHolders)parent).placeholderTables.addAll(((QueryNodeWithPlaceHolders)node).placeholderTables);
        parentQuery.cancelSubscriptionTo(nodeQuery);
        for (Pair pair : nodeQuery.getSourcesAndChannels()) {
            parentQuery.subscribeTo((ExecutableNodeBase)pair.getLeft(), (Integer)pair.getRight());
        }
    }

    static boolean isSharingQueue(ExecutableNodeBase node) {
        if (node.getExecutableNodeBaseParents().size() != 1 || node.getExecutableNodeBaseParents().get(0).getDependentNodeCount() <= 1) {
            return false;
        }
        for (ExecutableNodeBase dependent : node.getExecutableNodeBaseParents().get(0).getExecutableNodeBaseDependents()) {
            if (dependent.equals(node)) continue;
            for (ExecutableNode s1 : node.getSubscribers()) {
                for (ExecutableNode s2 : dependent.getSubscribers()) {
                    if (!s1.equals(s2)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

