/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying;

import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.querying.QueryExecutionPlan;
import org.verdictdb.core.querying.SelectAllExecutionNode;
import org.verdictdb.core.querying.TempIdCreatorInScratchpadSchema;
import org.verdictdb.core.scrambling.ScrambleMetaSet;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.exception.VerdictDBException;

public class QueryExecutionPlanFactory {
    public static QueryExecutionPlan create(String scratchpadSchemaName) {
        QueryExecutionPlan queryExecutionPlan = new QueryExecutionPlan();
        queryExecutionPlan.idCreator = new TempIdCreatorInScratchpadSchema(scratchpadSchemaName);
        return queryExecutionPlan;
    }

    public static QueryExecutionPlan create(String scratchpadSchemaName, ScrambleMetaSet scrambleMeta) {
        QueryExecutionPlan queryExecutionPlan = new QueryExecutionPlan();
        queryExecutionPlan.idCreator = new TempIdCreatorInScratchpadSchema(scratchpadSchemaName);
        queryExecutionPlan.scrambleMeta = scrambleMeta;
        return queryExecutionPlan;
    }

    public static QueryExecutionPlan create(String scratchpadSchemaName, ScrambleMetaSet scrambleMeta, SelectQuery query) throws VerdictDBException {
        QueryExecutionPlan queryExecutionPlan = new QueryExecutionPlan();
        queryExecutionPlan.idCreator = new TempIdCreatorInScratchpadSchema(scratchpadSchemaName);
        queryExecutionPlan.scrambleMeta = scrambleMeta;
        queryExecutionPlan.root = SelectAllExecutionNode.create(queryExecutionPlan.idCreator, query);
        return queryExecutionPlan;
    }

    public static QueryExecutionPlan create(String scratchpadSchemaName, ExecutableNodeBase root) {
        QueryExecutionPlan queryExecutionPlan = QueryExecutionPlanFactory.create(scratchpadSchemaName);
        queryExecutionPlan.root = root;
        return queryExecutionPlan;
    }

    static ExecutableNodeBase createRootAndItsDependents(SelectQuery query) {
        return null;
    }

    static SelectAllExecutionNode createSelectAllExecutionNodeAndItsDependents(SelectQuery query) {
        return null;
    }
}

