/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.core.execplan.ExecutableNode;
import org.verdictdb.core.execplan.ExecutablePlan;
import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.querying.IdCreator;
import org.verdictdb.core.querying.SelectAllExecutionNode;
import org.verdictdb.core.querying.TempIdCreatorInScratchpadSchema;
import org.verdictdb.core.scrambling.ScrambleMetaSet;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.exception.VerdictDBException;

public class QueryExecutionPlan
implements ExecutablePlan,
IdCreator,
Serializable {
    private static final long serialVersionUID = 8377795890801468660L;
    protected ScrambleMetaSet scrambleMeta;
    protected ExecutableNodeBase root;
    protected IdCreator idCreator;

    public QueryExecutionPlan() {
    }

    public QueryExecutionPlan(String scratchpadSchemaName) {
        this.scrambleMeta = new ScrambleMetaSet();
        this.idCreator = new TempIdCreatorInScratchpadSchema(scratchpadSchemaName);
    }

    public QueryExecutionPlan(String scratchpadSchemaName, ScrambleMetaSet scrambleMeta) {
        this.idCreator = new TempIdCreatorInScratchpadSchema(scratchpadSchemaName);
        this.scrambleMeta = scrambleMeta;
    }

    public int getSerialNumber() {
        return ((TempIdCreatorInScratchpadSchema)this.idCreator).getSerialNumber();
    }

    public ScrambleMetaSet getScrambleMeta() {
        return this.scrambleMeta;
    }

    public void setScrambleMeta(ScrambleMetaSet scrambleMeta) {
        this.scrambleMeta = scrambleMeta;
    }

    public String getScratchpadSchemaName() {
        return ((TempIdCreatorInScratchpadSchema)this.idCreator).getScratchpadSchemaName();
    }

    public ExecutableNodeBase getRootNode() {
        return this.root;
    }

    public void setRootNode(ExecutableNodeBase root) {
        this.root = root;
    }

    ExecutableNodeBase makePlan(SelectQuery query) throws VerdictDBException {
        SelectAllExecutionNode root = SelectAllExecutionNode.create(this.idCreator, query);
        return root;
    }

    public void cleanUp() {
        ((TempIdCreatorInScratchpadSchema)this.idCreator).reset();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE).append("root", (Object)this.root).append("scrambleMeta", (Object)this.scrambleMeta).toString();
    }

    public ExecutableNodeBase getRoot() {
        return this.root;
    }

    List<ExecutableNodeBase> retrieveAllDescendant(ExecutableNodeBase root) {
        ArrayList<ExecutableNodeBase> nodes = new ArrayList<ExecutableNodeBase>();
        LinkedList<ExecutableNodeBase> pool = new LinkedList<ExecutableNodeBase>();
        pool.add(root);
        while (!pool.isEmpty()) {
            ExecutableNodeBase n = (ExecutableNodeBase)pool.remove(0);
            if (nodes.contains(n)) continue;
            nodes.add(n);
            pool.addAll(n.getExecutableNodeBaseDependents());
        }
        return nodes;
    }

    @Override
    public Set<Integer> getNodeGroupIDs() {
        HashSet<Integer> groupIDs = new HashSet<Integer>();
        List<ExecutableNodeBase> nodes = this.retrieveAllDescendant(this.root);
        for (ExecutableNodeBase n : nodes) {
            groupIDs.add(n.getGroupId());
        }
        return groupIDs;
    }

    @Override
    public List<ExecutableNode> getNodesInGroup(int groupId) {
        ArrayList<ExecutableNode> relevantNodes = new ArrayList<ExecutableNode>();
        List<ExecutableNodeBase> allNodes = this.retrieveAllDescendant(this.root);
        for (ExecutableNodeBase n : allNodes) {
            if (n.getGroupId() != groupId) continue;
            relevantNodes.add(n);
        }
        return relevantNodes;
    }

    public List<ExecutableNode> getAllNodes() {
        ArrayList<ExecutableNode> allNodes = new ArrayList<ExecutableNode>();
        Set<Integer> groups = this.getNodeGroupIDs();
        for (int g : groups) {
            allNodes.addAll(this.getNodesInGroup(g));
        }
        return allNodes;
    }

    @Override
    public ExecutableNode getReportingNode() {
        return this.root;
    }

    @Override
    public String generateAliasName() {
        return this.idCreator.generateAliasName();
    }

    @Override
    public Pair<String, String> generateTempTableName() {
        return this.idCreator.generateTempTableName();
    }

    public QueryExecutionPlan deepcopy() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            return (QueryExecutionPlan)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

