/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.execplan.ExecutableNode;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.execplan.ExecutionTokenQueue;
import org.verdictdb.core.execplan.MethodInvocationInformation;
import org.verdictdb.core.querying.SubscriptionTicket;
import org.verdictdb.core.querying.ola.AggMeta;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.exception.VerdictDBException;

public class ExecutableNodeBase
implements ExecutableNode,
Serializable {
    private static final long serialVersionUID = 1424215482199124961L;
    List<ExecutableNodeBase> subscribers = new ArrayList<ExecutableNodeBase>();
    List<Pair<ExecutableNodeBase, Integer>> sources = new ArrayList<Pair<ExecutableNodeBase, Integer>>();
    Map<Integer, ExecutionTokenQueue> channels = new TreeMap<Integer, ExecutionTokenQueue>();
    AggMeta aggMeta = new AggMeta();
    private final String uniqueId = RandomStringUtils.randomAlphanumeric((int)10);
    private int groupId = Integer.valueOf(RandomStringUtils.randomNumeric((int)5));

    public static ExecutableNodeBase create() {
        return new ExecutableNodeBase();
    }

    public int getGroupId() {
        return this.groupId;
    }

    public SubscriptionTicket createSubscriptionTicket() {
        return new SubscriptionTicket(this);
    }

    public void registerSubscriber(SubscriptionTicket ticket) {
        if (ticket.getChannel().isPresent()) {
            ticket.getSubscriber().subscribeTo(this, (Integer)ticket.getChannel().get());
        } else {
            ticket.getSubscriber().subscribeTo(this);
        }
    }

    public void subscribeTo(ExecutableNodeBase node) {
        int channel = 0;
        while (true) {
            if (!this.channels.containsKey(channel)) break;
            ++channel;
        }
        this.subscribeTo(node, channel);
    }

    public void subscribeTo(ExecutableNodeBase node, int channel) {
        node.addSubscriber(this);
        this.sources.add((Pair<ExecutableNodeBase, Integer>)Pair.of((Object)node, (Object)channel));
        if (!this.channels.containsKey(channel)) {
            this.channels.put(channel, new ExecutionTokenQueue());
        }
    }

    private void addSubscriber(ExecutableNodeBase node) {
        this.subscribers.add(node);
    }

    public void cancelSubscriptionTo(ExecutableNodeBase node) {
        ArrayList<Pair<ExecutableNodeBase, Integer>> newSources = new ArrayList<Pair<ExecutableNodeBase, Integer>>();
        HashSet<Object> leftChannels = new HashSet<Object>();
        for (Pair<ExecutableNodeBase, Integer> pair : this.sources) {
            if (((ExecutableNodeBase)pair.getLeft()).equals(node)) continue;
            newSources.add(pair);
            leftChannels.add(pair.getRight());
        }
        this.sources = newSources;
        if (leftChannels.size() > 0) {
            for (Integer n : leftChannels) {
                if (this.channels.containsKey(n)) continue;
                this.channels.remove(n);
            }
        } else {
            this.channels.clear();
        }
        node.removeSubscriber(this);
    }

    private void removeSubscriber(ExecutableNodeBase node) {
        this.subscribers.remove(node);
    }

    public void cancelSubscriptionsFromAllSubscribers() {
        ArrayList<ExecutableNodeBase> copiedSubscribiers = new ArrayList<ExecutableNodeBase>();
        for (ExecutableNodeBase s : this.subscribers) {
            copiedSubscribiers.add(s);
        }
        for (ExecutableNodeBase s : copiedSubscribiers) {
            s.cancelSubscriptionTo(this);
        }
    }

    @Override
    public void getNotified(ExecutableNode source, ExecutionInfoToken token) {
        for (Pair<ExecutableNodeBase, Integer> a : this.sources) {
            if (!source.equals(a.getLeft())) continue;
            int channel = (Integer)a.getRight();
            this.channels.get(channel).add(token);
        }
    }

    @Override
    public List<ExecutionTokenQueue> getSourceQueues() {
        return new ArrayList<ExecutionTokenQueue>(this.channels.values());
    }

    @Override
    public List<ExecutableNode> getSubscribers() {
        ArrayList<ExecutableNode> nodes = new ArrayList<ExecutableNode>();
        for (ExecutableNodeBase s : this.subscribers) {
            nodes.add(s);
        }
        return nodes;
    }

    @Override
    public SqlConvertible createQuery(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        return null;
    }

    @Override
    public ExecutionInfoToken createToken(DbmsQueryResult result) {
        return null;
    }

    @Override
    public int getDependentNodeCount() {
        return this.sources.size();
    }

    @Override
    public Map<String, MethodInvocationInformation> getMethodsToInvokeOnConnection() {
        return new HashMap<String, MethodInvocationInformation>();
    }

    public List<ExecutableNodeBase> getSources() {
        List<Pair<ExecutableNodeBase, Integer>> temp = this.getSourcesAndChannels();
        Collections.sort(temp, new Comparator<Pair<ExecutableNodeBase, Integer>>(){

            @Override
            public int compare(Pair<ExecutableNodeBase, Integer> o1, Pair<ExecutableNodeBase, Integer> o2) {
                return (Integer)o1.getRight() - (Integer)o2.getRight();
            }
        });
        ArrayList<ExecutableNodeBase> ss = new ArrayList<ExecutableNodeBase>();
        for (Pair<ExecutableNodeBase, Integer> s : temp) {
            ss.add((ExecutableNodeBase)s.getKey());
        }
        return ss;
    }

    public Integer getChannelForSource(ExecutableNodeBase node) {
        for (Pair<ExecutableNodeBase, Integer> s : this.sources) {
            if (!((ExecutableNodeBase)s.getLeft()).equals(node)) continue;
            return (Integer)s.getRight();
        }
        return null;
    }

    public List<Pair<ExecutableNodeBase, Integer>> getSourcesAndChannels() {
        ArrayList<Pair<ExecutableNodeBase, Integer>> sourceAndChannel = new ArrayList<Pair<ExecutableNodeBase, Integer>>();
        for (Pair<ExecutableNodeBase, Integer> s : this.sources) {
            sourceAndChannel.add((Pair<ExecutableNodeBase, Integer>)Pair.of((Object)s.getKey(), (Object)s.getValue()));
        }
        return sourceAndChannel;
    }

    public List<ExecutableNodeBase> getExecutableNodeBaseParents() {
        ArrayList<ExecutableNodeBase> parents = new ArrayList<ExecutableNodeBase>();
        for (ExecutableNode executableNode : this.subscribers) {
            parents.add((ExecutableNodeBase)executableNode);
        }
        return parents;
    }

    public List<ExecutableNodeBase> getExecutableNodeBaseDependents() {
        return this.getSources();
    }

    public ExecutableNodeBase getExecutableNodeBaseDependent(int idx) {
        return this.getExecutableNodeBaseDependents().get(idx);
    }

    public ExecutableNodeBase deepcopy() {
        ExecutableNodeBase node = ExecutableNodeBase.create();
        this.copyFields(this, node);
        return node;
    }

    protected void copyFields(ExecutableNodeBase from, ExecutableNodeBase to) {
        to.subscribers = new ArrayList<ExecutableNodeBase>(from.subscribers);
        to.sources = new ArrayList<Pair<ExecutableNodeBase, Integer>>(from.sources);
        to.channels = new TreeMap<Integer, ExecutionTokenQueue>();
        for (Map.Entry<Integer, ExecutionTokenQueue> a : from.channels.entrySet()) {
            to.channels.put(a.getKey(), new ExecutionTokenQueue());
        }
        to.groupId = from.groupId;
    }

    public void print() {
        this.print(0);
    }

    void print(int indentSpace) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indentSpace; ++i) {
            builder.append(" ");
        }
        builder.append(this.toString());
        System.out.println(builder.toString());
        for (ExecutableNodeBase dep : this.getExecutableNodeBaseDependents()) {
            dep.print(indentSpace + 2);
        }
    }

    public AggMeta getAggMeta() {
        return this.aggMeta;
    }

    public void setAggMeta(AggMeta aggMeta) {
        this.aggMeta = aggMeta;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.uniqueId).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ExecutableNodeBase rhs = (ExecutableNodeBase)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.uniqueId, (Object)rhs.uniqueId).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE).append("subscriberCount", this.subscribers.size()).append("sourcCount", this.sources.size()).toString();
    }
}

