/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.querying;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.querying.IdCreator;
import org.verdictdb.core.querying.QueryNodeWithPlaceHolders;
import org.verdictdb.core.sqlobject.CreateTableAsSelectQuery;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.exception.VerdictDBException;

public class CreateTableAsSelectNode
extends QueryNodeWithPlaceHolders {
    private static final long serialVersionUID = -8722221355083655181L;
    IdCreator namer;
    String newTableSchemaName;
    String newTableName;
    List<String> partitionColumns = new ArrayList<String>();
    boolean ifNotExists = false;

    public CreateTableAsSelectNode(IdCreator namer, SelectQuery query) {
        super(query);
        this.namer = namer;
    }

    public static CreateTableAsSelectNode create(IdCreator namer, SelectQuery query) {
        CreateTableAsSelectNode node = new CreateTableAsSelectNode(namer, query);
        return node;
    }

    public IdCreator getNamer() {
        return this.namer;
    }

    public void setNamer(IdCreator namer) {
        this.namer = namer;
    }

    public void addPartitionColumn(String column) {
        this.partitionColumns.add(column);
    }

    @Override
    public SqlConvertible createQuery(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        super.createQuery(tokens);
        Pair<String, String> tempTableFullName = this.namer.generateTempTableName();
        this.newTableSchemaName = (String)tempTableFullName.getLeft();
        this.newTableName = (String)tempTableFullName.getRight();
        CreateTableAsSelectQuery createQuery = new CreateTableAsSelectQuery(this.newTableSchemaName, this.newTableName, this.selectQuery);
        for (String col : this.partitionColumns) {
            createQuery.addPartitionColumn(col);
        }
        return createQuery;
    }

    @Override
    public ExecutionInfoToken createToken(DbmsQueryResult result) {
        ExecutionInfoToken token = new ExecutionInfoToken();
        token.setKeyValue("schemaName", this.newTableSchemaName);
        token.setKeyValue("tableName", this.newTableName);
        return token;
    }

    @Override
    public ExecutableNodeBase deepcopy() {
        CreateTableAsSelectNode node = new CreateTableAsSelectNode(this.namer, this.selectQuery);
        this.copyFields(this, node);
        return node;
    }

    void copyFields(CreateTableAsSelectNode from, CreateTableAsSelectNode to) {
        super.copyFields(from, to);
    }
}

