/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.execplan;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ExecutionInfoToken
implements Serializable {
    private static final long serialVersionUID = 4467660505348718275L;
    Map<String, Object> data = new HashMap<String, Object>();

    public static ExecutionInfoToken empty() {
        return new ExecutionInfoToken();
    }

    public boolean isStatusToken() {
        return this.data.containsKey("status");
    }

    public static ExecutionInfoToken successToken() {
        ExecutionInfoToken token = new ExecutionInfoToken();
        token.setKeyValue("status", "success");
        return token;
    }

    public static ExecutionInfoToken failureToken() {
        ExecutionInfoToken token = new ExecutionInfoToken();
        token.setKeyValue("status", "failed");
        return token;
    }

    public static ExecutionInfoToken failureToken(Exception e) {
        ExecutionInfoToken token = new ExecutionInfoToken();
        token.setKeyValue("status", "failed");
        token.setKeyValue("errorMessage", e);
        return token;
    }

    public boolean isSuccessToken() {
        return this.data.containsKey("status") && this.data.get("status").equals("success");
    }

    public boolean isFailureToken() {
        return this.data.containsKey("status") && this.data.get("status").equals("failed");
    }

    public Object getValue(String key) {
        return this.data.get(key);
    }

    public void setKeyValue(String key, Object value) {
        this.data.put(key, value);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public Iterable<Map.Entry<String, Object>> entrySet() {
        return this.data.entrySet();
    }

    public boolean containsKey(String key) {
        return this.data.containsKey(key);
    }

    public ExecutionInfoToken deepcopy() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            ExecutionInfoToken copiedToken = (ExecutionInfoToken)in.readObject();
            return copiedToken;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NotSerializableException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

