/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.execplan;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.verdictdb.connection.DbmsConnection;
import org.verdictdb.core.execplan.ExecutableNode;
import org.verdictdb.core.execplan.ExecutableNodeRunner;
import org.verdictdb.core.execplan.ExecutablePlan;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.resulthandler.ExecutionResultReader;
import org.verdictdb.core.resulthandler.ExecutionTokenReader;
import org.verdictdb.exception.VerdictDBException;

public class ExecutablePlanRunner {
    private DbmsConnection conn;
    private ExecutablePlan plan;
    private int nThreads = 2;

    public ExecutablePlanRunner(DbmsConnection conn, ExecutablePlan plan) {
        this.conn = conn;
        this.plan = plan;
    }

    public static ExecutionTokenReader getTokenReader(DbmsConnection conn, ExecutablePlan plan) {
        return new ExecutablePlanRunner(conn, plan).getTokenReader();
    }

    public static ExecutionResultReader getResultReader(DbmsConnection conn, ExecutablePlan plan) {
        return new ExecutablePlanRunner(conn, plan).getResultReader();
    }

    public static void runTillEnd(DbmsConnection conn, ExecutablePlan plan) throws VerdictDBException {
        ExecutionInfoToken token;
        ExecutionTokenReader reader = new ExecutablePlanRunner(conn, plan).getTokenReader();
        while ((token = reader.next()) != null) {
        }
    }

    public ExecutionTokenReader getTokenReader() {
        ExecutionTokenReader reader;
        if (this.plan.getReportingNode() != null) {
            ExecutableNodeBase node = ExecutableNodeBase.create();
            node.subscribeTo((ExecutableNodeBase)this.plan.getReportingNode());
            reader = new ExecutionTokenReader(node.getSourceQueues().get(0));
        } else {
            reader = new ExecutionTokenReader();
        }
        HashMap<Integer, ExecutorService> executorPool = new HashMap<Integer, ExecutorService>();
        Set<Integer> groupIds = this.plan.getNodeGroupIDs();
        for (int gid : groupIds) {
            List<ExecutableNode> nodes = this.plan.getNodesInGroup(gid);
            ExecutorService executor = Executors.newFixedThreadPool(this.nThreads);
            for (ExecutableNode n : nodes) {
                executor.submit(new ExecutableNodeRunner(this.conn, n));
            }
            executorPool.put(gid, executor);
        }
        return reader;
    }

    public ExecutionResultReader getResultReader() {
        ExecutionTokenReader reader = this.getTokenReader();
        return new ExecutionResultReader(reader);
    }
}

