/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.execplan;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.verdictdb.connection.DbmsConnection;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.execplan.ExecutableNode;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.execplan.ExecutionTokenQueue;
import org.verdictdb.core.execplan.MethodInvocationInformation;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.exception.VerdictDBValueException;
import org.verdictdb.sqlwriter.QueryToSql;

public class ExecutableNodeRunner
implements Runnable {
    DbmsConnection conn;
    ExecutableNode node;
    int successSourceCount = 0;
    int dependentCount;

    public ExecutableNodeRunner(DbmsConnection conn, ExecutableNode node) {
        this.conn = conn;
        this.node = node;
        this.dependentCount = node.getDependentNodeCount();
    }

    public static ExecutionInfoToken execute(DbmsConnection conn, ExecutableNode node) throws VerdictDBException {
        return ExecutableNodeRunner.execute(conn, node, Arrays.asList(new ExecutionInfoToken[0]));
    }

    public static ExecutionInfoToken execute(DbmsConnection conn, ExecutableNode node, List<ExecutionInfoToken> tokens) throws VerdictDBException {
        return new ExecutableNodeRunner(conn, node).execute(tokens);
    }

    @Override
    public void run() {
        if (this.node.getSourceQueues().size() == 0) {
            try {
                this.executeAndBroadcast(Arrays.asList(new ExecutionInfoToken[0]));
                this.broadcast(ExecutionInfoToken.successToken());
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.broadcast(ExecutionInfoToken.failureToken(e));
            }
        }
        while (true) {
            List<ExecutionInfoToken> tokens;
            if ((tokens = this.retrieve()) == null) {
                continue;
            }
            ExecutionInfoToken failureToken = this.getFailureTokenIfExists(tokens);
            if (failureToken != null) {
                this.broadcast(failureToken);
                break;
            }
            if (this.areAllSuccess(tokens)) {
                this.broadcast(ExecutionInfoToken.successToken());
                break;
            }
            try {
                this.executeAndBroadcast(tokens);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.broadcast(ExecutionInfoToken.failureToken(e));
                break;
            }
        }
    }

    List<ExecutionInfoToken> retrieve() {
        List<ExecutionTokenQueue> sourceQueues = this.node.getSourceQueues();
        for (int i = 0; i < sourceQueues.size(); ++i) {
            ExecutionInfoToken rs = sourceQueues.get(i).peek();
            if (rs != null) continue;
            return null;
        }
        ArrayList<ExecutionInfoToken> results = new ArrayList<ExecutionInfoToken>();
        for (int i = 0; i < sourceQueues.size(); ++i) {
            ExecutionInfoToken rs = sourceQueues.get(i).take();
            results.add(rs);
        }
        return results;
    }

    void broadcast(ExecutionInfoToken token) {
        for (ExecutableNode dest : this.node.getSubscribers()) {
            ExecutionInfoToken copiedToken = token.deepcopy();
            dest.getNotified(this.node, copiedToken);
        }
    }

    void executeAndBroadcast(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        ExecutionInfoToken resultToken = this.execute(tokens);
        if (resultToken != null) {
            this.broadcast(resultToken);
        }
    }

    public ExecutionInfoToken execute(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        ExecutionInfoToken token;
        if (tokens.size() > 0 && tokens.get(0).isStatusToken()) {
            return null;
        }
        SqlConvertible sqlObj = this.node.createQuery(tokens);
        DbmsQueryResult intermediate = null;
        if (sqlObj != null) {
            String sql = QueryToSql.convert(this.conn.getSyntax(), sqlObj);
            intermediate = this.conn.execute(sql);
        }
        if ((token = this.node.createToken(intermediate)) == null) {
            token = new ExecutionInfoToken();
        }
        Map<String, MethodInvocationInformation> tokenKeysAndmethodsToInvoke = this.node.getMethodsToInvokeOnConnection();
        for (Map.Entry<String, MethodInvocationInformation> keyAndMethod : tokenKeysAndmethodsToInvoke.entrySet()) {
            String tokenKey = keyAndMethod.getKey();
            MethodInvocationInformation methodInfo = keyAndMethod.getValue();
            String methodName = methodInfo.getMethodName();
            Class<?>[] methodParameters = methodInfo.getMethodParameters();
            Object[] methodArguments = methodInfo.getArguments();
            try {
                Method method = this.conn.getClass().getMethod(methodName, methodParameters);
                Object ret = method.invoke((Object)this.conn, methodArguments);
                token.setKeyValue(tokenKey, ret);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                throw new VerdictDBValueException(e);
            }
        }
        return token;
    }

    ExecutionInfoToken getFailureTokenIfExists(List<ExecutionInfoToken> tokens) {
        for (ExecutionInfoToken t : tokens) {
            if (!t.isFailureToken()) continue;
            return t;
        }
        return null;
    }

    boolean areAllSuccess(List<ExecutionInfoToken> latestResults) {
        for (ExecutionInfoToken t : latestResults) {
            if (t.isSuccessToken()) {
                ++this.successSourceCount;
                continue;
            }
            return false;
        }
        return this.successSourceCount == this.dependentCount;
    }
}

