/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.aggresult;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.verdictdb.exception.VerdictDBValueException;

public class AggregateMeasures
implements Serializable {
    List<String> attributeNames;
    List<Object> attributeValues;

    public AggregateMeasures() {
        this.attributeNames = new ArrayList<String>();
        this.attributeValues = new ArrayList<Object>();
    }

    public AggregateMeasures(List<String> attributeNames, List<Object> attributeValues) {
        this.attributeNames = attributeNames;
        this.attributeValues = attributeValues;
    }

    public void addMeasure(String attributeName, Object attributeValue) {
        this.attributeNames.add(attributeName);
        this.attributeValues.add(attributeValue);
    }

    public int getIndexOfAttributeName(String attributeName) throws VerdictDBValueException {
        int index = this.attributeNames.indexOf(attributeName);
        if (index == -1) {
            throw new VerdictDBValueException(attributeName + " does not appear in " + this.attributeNames);
        }
        return index;
    }

    public Object getAttributeValueAt(int index) {
        return this.attributeValues.get(index);
    }

    public Object getAttributeValue(String attributeName) throws VerdictDBValueException {
        return this.attributeValues.get(this.getIndexOfAttributeName(attributeName));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeNames == null ? 0 : this.attributeNames.hashCode());
        result = 31 * result + (this.attributeValues == null ? 0 : this.attributeValues.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggregateMeasures other = (AggregateMeasures)obj;
        if (this.attributeNames == null ? other.attributeNames != null : !this.attributeNames.equals(other.attributeNames)) {
            return false;
        }
        return !(this.attributeValues == null ? other.attributeValues != null : !this.attributeValues.equals(other.attributeValues));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

