/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.aggresult;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.verdictdb.commons.AttributeValueRetrievalHelper;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.connection.DbmsQueryResultMetaData;
import org.verdictdb.core.aggresult.AggregateFrame;
import org.verdictdb.core.aggresult.AggregateGroup;
import org.verdictdb.core.aggresult.AggregateMeasures;

public class AggregateFrameQueryResult
extends AttributeValueRetrievalHelper
implements DbmsQueryResult {
    private AggregateFrame aggregateFrame;
    private transient Iterator it;
    private Map.Entry currentEntry;
    private List<Integer> orderedColumnIndex = new ArrayList<Integer>();

    public AggregateFrameQueryResult(AggregateFrame aggregateFrame) {
        this.aggregateFrame = aggregateFrame;
        this.it = aggregateFrame.data.entrySet().iterator();
        List<String> orderedColumnName = aggregateFrame.getColumnNames();
        if (!aggregateFrame.data.entrySet().isEmpty()) {
            int i;
            AggregateGroup group = (AggregateGroup)aggregateFrame.data.keySet().toArray()[0];
            AggregateMeasures measures = (AggregateMeasures)aggregateFrame.data.values().toArray()[0];
            for (i = 0; i < group.attributeNames.size(); ++i) {
                this.orderedColumnIndex.add(orderedColumnName.indexOf(group.attributeNames.get(i)));
            }
            for (i = 0; i < measures.attributeNames.size(); ++i) {
                this.orderedColumnIndex.add(orderedColumnName.indexOf(measures.attributeNames.get(i)));
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.it = this.aggregateFrame.data.entrySet().iterator();
    }

    public void setAggregateFrame(AggregateFrame aggregateFrame) {
        this.aggregateFrame = aggregateFrame;
        this.it = aggregateFrame.data.entrySet().iterator();
    }

    public AggregateFrame getAggregateFrame() {
        return this.aggregateFrame;
    }

    @Override
    public DbmsQueryResultMetaData getMetaData() {
        return this.aggregateFrame.dbmsQueryResultMetaData;
    }

    @Override
    public int getColumnCount() {
        return this.aggregateFrame.getColumnNames().size();
    }

    @Override
    public String getColumnName(int index) {
        return this.aggregateFrame.getColumnNames().get(index);
    }

    @Override
    public int getColumnType(int index) {
        return this.aggregateFrame.getColumnTypes().get(index);
    }

    @Override
    public boolean next() {
        if (this.it.hasNext()) {
            this.currentEntry = (Map.Entry)this.it.next();
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(int index) {
        if ((index = this.orderedColumnIndex.get(index).intValue()) < ((AggregateGroup)this.currentEntry.getKey()).attributeValues.size()) {
            return ((AggregateGroup)this.currentEntry.getKey()).attributeValues.get(index);
        }
        return ((AggregateMeasures)this.currentEntry.getValue()).attributeValues.get(index - ((AggregateGroup)this.currentEntry.getKey()).attributeValues.size());
    }

    @Override
    public void printContent() {
        boolean isFirstCol = true;
        StringBuilder row = new StringBuilder();
        for (String col : this.aggregateFrame.getColumnNames()) {
            if (isFirstCol) {
                row.append(col);
                isFirstCol = false;
                continue;
            }
            row.append("\t" + col);
        }
        System.out.println(row.toString());
        int colCount = this.getColumnCount();
        while (this.next()) {
            row = new StringBuilder();
            for (int i = 0; i < colCount; ++i) {
                if (i == 0) {
                    row.append(this.getValue(i).toString());
                    continue;
                }
                row.append("\t");
                row.append(this.getValue(i).toString());
            }
            System.out.println(row.toString());
        }
    }

    @Override
    public void rewind() {
    }

    @Override
    public long getRowCount() {
        return 0L;
    }
}

