/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.aggresult;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.connection.DbmsQueryResultMetaData;
import org.verdictdb.core.aggresult.AggregateFrameQueryResult;
import org.verdictdb.core.aggresult.AggregateGroup;
import org.verdictdb.core.aggresult.AggregateMeasures;
import org.verdictdb.core.rewriter.aggresult.AggNameAndType;
import org.verdictdb.exception.VerdictDBValueException;

public class AggregateFrame
implements Serializable {
    String aggFrameType = "raw";
    List<String> orderedColumnNames;
    List<Integer> columnTypes = new ArrayList<Integer>();
    DbmsQueryResultMetaData dbmsQueryResultMetaData = new DbmsQueryResultMetaData();
    Map<AggregateGroup, AggregateMeasures> data = new HashMap<AggregateGroup, AggregateMeasures>();

    public AggregateFrame(List<String> orderedColumnNames) throws VerdictDBValueException {
        this.orderedColumnNames = orderedColumnNames;
        HashSet<String> colNames = new HashSet<String>(orderedColumnNames);
        if (colNames.size() != orderedColumnNames.size()) {
            throw new VerdictDBValueException("The column names seem to include duplicates.");
        }
    }

    public static AggregateFrame empty() {
        try {
            return new AggregateFrame(new ArrayList<String>());
        }
        catch (VerdictDBValueException e) {
            return null;
        }
    }

    public static AggregateFrame fromDmbsQueryResult(DbmsQueryResult result, List<String> nonaggColumns, List<AggNameAndType> aggColumns) throws VerdictDBValueException {
        ArrayList<String> colName = new ArrayList<String>();
        ArrayList<String> nonaggColumnsName = new ArrayList<String>();
        ArrayList<String> aggColumnsName = new ArrayList<String>();
        for (String col : nonaggColumns) {
            nonaggColumnsName.add(col.toLowerCase());
        }
        for (AggNameAndType pair : aggColumns) {
            aggColumnsName.add(pair.getName().toLowerCase());
        }
        HashSet aggColumnsSet = new HashSet(aggColumnsName);
        HashSet nonaggColumnsSet = new HashSet(nonaggColumnsName);
        ArrayList<Integer> aggColumnIndex = new ArrayList<Integer>();
        ArrayList<Integer> nonaggColumnIndex = new ArrayList<Integer>();
        ArrayList<String> orderedAggColumnName = new ArrayList<String>();
        ArrayList<String> orderedNonaggColumnName = new ArrayList<String>();
        ArrayList<Integer> columnTypes = new ArrayList<Integer>();
        for (int i = 0; i < result.getColumnCount(); ++i) {
            String col = result.getColumnName(i).toLowerCase();
            colName.add(col);
            columnTypes.add(result.getColumnType(i));
            if (aggColumnsSet.contains(col)) {
                orderedAggColumnName.add(col);
                aggColumnIndex.add(i);
                continue;
            }
            if (nonaggColumnsSet.contains(col)) {
                orderedNonaggColumnName.add(col);
                nonaggColumnIndex.add(i);
                continue;
            }
            throw new VerdictDBValueException(String.format("An existing column (%s) does not belong to any of specified columns.", col));
        }
        AggregateFrame aggregateFrame = new AggregateFrame(colName);
        aggregateFrame.setColumnTypes(columnTypes);
        aggregateFrame.dbmsQueryResultMetaData = result.getMetaData();
        while (result.next()) {
            int i;
            ArrayList<Object> aggValue = new ArrayList<Object>();
            ArrayList<Object> nonaggValue = new ArrayList<Object>();
            Iterator iterator = aggColumnIndex.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                aggValue.add(result.getValue(i));
            }
            iterator = nonaggColumnIndex.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                nonaggValue.add(result.getValue(i));
            }
            aggregateFrame.addRow(new AggregateGroup(orderedNonaggColumnName, nonaggValue), new AggregateMeasures(orderedAggColumnName, aggValue));
        }
        return aggregateFrame;
    }

    public DbmsQueryResult toDbmsQueryResult() {
        return new AggregateFrameQueryResult(this);
    }

    public void setColumnTypes(List<Integer> columnTypes) {
        this.columnTypes = columnTypes;
    }

    public List<Integer> getColumnTypes() {
        return this.columnTypes;
    }

    public List<String> getColumnNames() {
        return this.orderedColumnNames;
    }

    public void addRow(AggregateGroup group, AggregateMeasures measures) {
        this.data.put(group, measures);
    }

    public void addRow(AggregateMeasures measures) {
        this.data.put(AggregateGroup.empty(), measures);
    }

    public AggregateMeasures getMeasures(AggregateGroup group) {
        return this.data.get(group);
    }

    public AggregateMeasures getMeasures() throws VerdictDBValueException {
        if (this.data.size() > 1) {
            throw new VerdictDBValueException("The number of rows is larger than 1. A group must be specified.");
        }
        return this.data.get(AggregateGroup.empty());
    }

    public Set<Map.Entry<AggregateGroup, AggregateMeasures>> groupAndMeasuresSet() {
        return this.data.entrySet();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

