/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.coordinator;

import com.google.common.base.Optional;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.verdictdb.commons.AttributeValueRetrievalHelper;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.connection.DbmsQueryResultMetaData;

public class VerdictSingleResult
extends AttributeValueRetrievalHelper {
    private Optional<DbmsQueryResult> result;
    private Object lastValueRead;

    public VerdictSingleResult(DbmsQueryResult result) {
        if (result == null) {
            this.result = Optional.absent();
        } else {
            DbmsQueryResult copied = this.copyResult(result);
            copied.rewind();
            this.result = Optional.of((Object)copied);
        }
    }

    public VerdictSingleResult(DbmsQueryResult result, boolean asIs) {
        if (result == null) {
            this.result = Optional.absent();
        } else if (asIs) {
            this.result = Optional.of((Object)result);
        } else {
            DbmsQueryResult copied = this.copyResult(result);
            copied.rewind();
            this.result = Optional.of((Object)copied);
        }
    }

    public static VerdictSingleResult empty() {
        return new VerdictSingleResult(null);
    }

    public boolean isEmpty() {
        return !this.result.isPresent();
    }

    private DbmsQueryResult copyResult(DbmsQueryResult result) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(result);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            DbmsQueryResult copied = (DbmsQueryResult)in.readObject();
            return copied;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NotSerializableException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public DbmsQueryResultMetaData getMetaData() {
        return this.result.isPresent() ? ((DbmsQueryResult)this.result.get()).getMetaData() : null;
    }

    @Override
    public int getColumnCount() {
        if (!this.result.isPresent()) {
            return 0;
        }
        return ((DbmsQueryResult)this.result.get()).getColumnCount();
    }

    @Override
    public String getColumnName(int index) {
        if (!this.result.isPresent()) {
            throw new RuntimeException("An empty result is accessed.");
        }
        return ((DbmsQueryResult)this.result.get()).getColumnName(index);
    }

    public int getColumnType(int index) {
        if (!this.result.isPresent()) {
            throw new RuntimeException("An empty result is accessed.");
        }
        return ((DbmsQueryResult)this.result.get()).getColumnType(index);
    }

    public long getRowCount() {
        if (!this.result.isPresent()) {
            return 0L;
        }
        return ((DbmsQueryResult)this.result.get()).getRowCount();
    }

    @Override
    public Object getValue(int index) {
        Object value;
        if (!this.result.isPresent()) {
            throw new RuntimeException("An empty result is accessed.");
        }
        this.lastValueRead = value = ((DbmsQueryResult)this.result.get()).getValue(index);
        return value;
    }

    public boolean wasNull() {
        return this.lastValueRead == null;
    }

    public boolean next() {
        if (!this.result.isPresent()) {
            return false;
        }
        return ((DbmsQueryResult)this.result.get()).next();
    }

    public void rewind() {
        if (this.result.isPresent()) {
            ((DbmsQueryResult)this.result.get()).rewind();
        }
    }
}

