/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.coordinator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DataTypeConverter;
import org.verdictdb.connection.DbmsConnection;
import org.verdictdb.connection.MetaDataProvider;
import org.verdictdb.connection.StaticMetaData;
import org.verdictdb.core.execplan.ExecutablePlanRunner;
import org.verdictdb.core.querying.QueryExecutionPlan;
import org.verdictdb.core.querying.QueryExecutionPlanFactory;
import org.verdictdb.core.querying.QueryExecutionPlanSimplifier;
import org.verdictdb.core.querying.ola.AsyncQueryExecutionPlan;
import org.verdictdb.core.resulthandler.ExecutionResultReader;
import org.verdictdb.core.scrambling.ScrambleMetaSet;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.JoinTable;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SubqueryColumn;
import org.verdictdb.core.sqlobject.UnnamedColumn;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.sqlreader.NonValidatingSQLParser;
import org.verdictdb.sqlreader.RelationStandardizer;

public class SelectQueryCoordinator {
    DbmsConnection conn;
    ScrambleMetaSet scrambleMetaSet;
    String scratchpadSchema;

    public SelectQueryCoordinator(DbmsConnection conn) {
        this(conn, new ScrambleMetaSet());
    }

    public SelectQueryCoordinator(DbmsConnection conn, ScrambleMetaSet scrambleMetaSet) {
        this(conn, scrambleMetaSet, conn.getDefaultSchema());
    }

    public SelectQueryCoordinator(DbmsConnection conn, ScrambleMetaSet scrambleMetaSet, String scratchpadSchema) {
        this.conn = conn;
        this.scrambleMetaSet = scrambleMetaSet;
        this.scratchpadSchema = scratchpadSchema;
    }

    public ScrambleMetaSet getScrambleMetaSet() {
        return this.scrambleMetaSet;
    }

    public void setScrambleMetaSet(ScrambleMetaSet scrambleMetaSet) {
        this.scrambleMetaSet = scrambleMetaSet;
    }

    public ExecutionResultReader process(String query) throws VerdictDBException {
        SelectQuery selectQuery = this.standardizeQuery(query);
        QueryExecutionPlan plan = QueryExecutionPlanFactory.create(this.scratchpadSchema, this.scrambleMetaSet, selectQuery);
        AsyncQueryExecutionPlan asyncPlan = AsyncQueryExecutionPlan.create(plan);
        QueryExecutionPlan simplifiedAsyncPlan = QueryExecutionPlanSimplifier.simplify(asyncPlan);
        ExecutionResultReader reader = ExecutablePlanRunner.getResultReader(this.conn, simplifiedAsyncPlan);
        return reader;
    }

    private SelectQuery standardizeQuery(String query) throws VerdictDBException {
        RelationStandardizer.resetItemID();
        NonValidatingSQLParser sqlToRelation = new NonValidatingSQLParser();
        SelectQuery relation = (SelectQuery)sqlToRelation.toRelation(query);
        MetaDataProvider metaData = this.createMetaDataFor(relation);
        RelationStandardizer gen = new RelationStandardizer(metaData);
        relation = gen.standardize(relation);
        return relation;
    }

    private MetaDataProvider createMetaDataFor(SelectQuery relation) throws VerdictDBException {
        StaticMetaData meta = new StaticMetaData();
        String defaultSchema = this.conn.getDefaultSchema();
        meta.setDefaultSchema(defaultSchema);
        HashSet<BaseTable> tables = new HashSet<BaseTable>();
        ArrayList<SelectQuery> queries = new ArrayList<SelectQuery>();
        queries.add(relation);
        while (!queries.isEmpty()) {
            SelectQuery query = (SelectQuery)queries.get(0);
            queries.remove(0);
            for (AbstractRelation t : query.getFromList()) {
                if (t instanceof BaseTable) {
                    tables.add((BaseTable)t);
                    continue;
                }
                if (t instanceof SelectQuery) {
                    queries.add((SelectQuery)t);
                    continue;
                }
                if (!(t instanceof JoinTable)) continue;
                for (AbstractRelation join : ((JoinTable)t).getJoinList()) {
                    if (join instanceof BaseTable) {
                        tables.add((BaseTable)join);
                        continue;
                    }
                    if (!(join instanceof SelectQuery)) continue;
                    queries.add((SelectQuery)join);
                }
            }
            if (!query.getFilter().isPresent()) continue;
            UnnamedColumn where = (UnnamedColumn)query.getFilter().get();
            ArrayList<UnnamedColumn> toCheck = new ArrayList<UnnamedColumn>();
            toCheck.add(where);
            while (!toCheck.isEmpty()) {
                UnnamedColumn col = (UnnamedColumn)toCheck.get(0);
                toCheck.remove(0);
                if (col instanceof ColumnOp) {
                    toCheck.addAll(((ColumnOp)col).getOperands());
                    continue;
                }
                if (!(col instanceof SubqueryColumn)) continue;
                queries.add(((SubqueryColumn)col).getSubquery());
            }
        }
        for (BaseTable t : tables) {
            StaticMetaData.TableInfo tableInfo;
            List<Pair<String, String>> columns;
            if (t.getSchemaName() == null) {
                columns = this.conn.getColumns(defaultSchema, t.getTableName());
                tableInfo = new StaticMetaData.TableInfo(defaultSchema, t.getTableName());
            } else {
                columns = this.conn.getColumns(t.getSchemaName(), t.getTableName());
                tableInfo = new StaticMetaData.TableInfo(t.getSchemaName(), t.getTableName());
            }
            ArrayList<Pair<String, Integer>> colInfo = new ArrayList<Pair<String, Integer>>();
            for (Pair<String, String> col : columns) {
                colInfo.add((Pair<String, Integer>)new ImmutablePair(col.getLeft(), (Object)DataTypeConverter.typeInt(((String)col.getRight()).toLowerCase())));
            }
            meta.addTableData(tableInfo, colInfo);
        }
        return meta;
    }
}

