/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.coordinator;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.verdictdb.connection.DbmsConnection;
import org.verdictdb.core.execplan.ExecutablePlanRunner;
import org.verdictdb.core.scrambling.FastConvergeScramblingMethod;
import org.verdictdb.core.scrambling.ScrambleMeta;
import org.verdictdb.core.scrambling.ScramblingMethodBase;
import org.verdictdb.core.scrambling.ScramblingPlan;
import org.verdictdb.core.scrambling.UniformScramblingMethod;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.exception.VerdictDBValueException;

public class ScramblingCoordinator {
    private final Set<String> scramblingMethods = new HashSet<String>(Arrays.asList("uniform", "fastconverge"));
    private final Map<String, String> options = new HashMap<String, String>(){
        private static final long serialVersionUID = -4491518418086939738L;
        {
            this.put("tierColumnName", "verdictdbtier");
            this.put("blockColumnName", "verdictdbblock");
            this.put("scrambleTableSuffix", "_scrambled");
            this.put("scrambleTableBlockSize", "1e6");
        }
    };
    Optional<String> scrambleSchema;
    DbmsConnection conn;
    Optional<String> scratchpadSchema;

    public ScramblingCoordinator(DbmsConnection conn) {
        this(conn, null);
    }

    public ScramblingCoordinator(DbmsConnection conn, String scrambleSchema) {
        this(conn, scrambleSchema, scrambleSchema);
    }

    public ScramblingCoordinator(DbmsConnection conn, String scrambleSchema, String scratchpadSchema) {
        this(conn, scrambleSchema, scratchpadSchema, null);
    }

    public ScramblingCoordinator(DbmsConnection conn, String scrambleSchema, String scratchpadSchema, Long blockSize) {
        this.conn = conn;
        this.scratchpadSchema = Optional.fromNullable((Object)scratchpadSchema);
        this.scrambleSchema = Optional.fromNullable((Object)scrambleSchema);
        if (blockSize != null) {
            this.options.put("scrambleTableBlockSize", String.valueOf(blockSize));
        }
    }

    public ScrambleMeta scramble(String originalSchema, String originalTable) throws VerdictDBException {
        String newSchema = this.scrambleSchema.isPresent() ? (String)this.scrambleSchema.get() : originalSchema;
        String newTable = originalTable + this.options.get("scrambleTableSuffix");
        ScrambleMeta meta = this.scramble(originalSchema, originalTable, newSchema, newTable);
        return meta;
    }

    public ScrambleMeta scramble(String originalSchema, String originalTable, String newSchema, String newTable) throws VerdictDBException {
        String methodName = "uniform";
        String primaryColumn = null;
        ScrambleMeta meta = this.scramble(originalSchema, originalTable, newSchema, newTable, methodName, primaryColumn);
        return meta;
    }

    public ScrambleMeta scramble(String originalSchema, String originalTable, String newSchema, String newTable, String methodName) throws VerdictDBException {
        String primaryColumn = null;
        ScrambleMeta meta = this.scramble(originalSchema, originalTable, newSchema, newTable, methodName, primaryColumn);
        return meta;
    }

    public ScrambleMeta scramble(String originalSchema, String originalTable, String newSchema, String newTable, String methodName, String primaryColumn) throws VerdictDBException {
        HashMap<String, String> customOptions = new HashMap<String, String>(this.options);
        ScrambleMeta meta = this.scramble(originalSchema, originalTable, newSchema, newTable, methodName, primaryColumn, customOptions);
        return meta;
    }

    public ScrambleMeta scramble(String originalSchema, String originalTable, String newSchema, String newTable, String methodName, String primaryColumn, Map<String, String> customOptions) throws VerdictDBException {
        ScramblingMethodBase scramblingMethod;
        if (!this.scramblingMethods.contains(methodName.toLowerCase())) {
            throw new VerdictDBValueException("Not supported scrambling method: " + methodName);
        }
        HashMap<String, String> effectiveOptions = new HashMap<String, String>();
        for (Map.Entry<String, String> o : this.options.entrySet()) {
            effectiveOptions.put(o.getKey(), o.getValue());
        }
        for (Map.Entry<String, String> o : customOptions.entrySet()) {
            effectiveOptions.put(o.getKey(), o.getValue());
        }
        long blockSize = Double.valueOf((String)effectiveOptions.get("scrambleTableBlockSize")).longValue();
        if (methodName.equalsIgnoreCase("uniform")) {
            scramblingMethod = new UniformScramblingMethod(blockSize);
        } else if (methodName.equalsIgnoreCase("FastConverge") && primaryColumn == null) {
            scramblingMethod = new FastConvergeScramblingMethod(blockSize, (String)this.scratchpadSchema.get());
        } else if (methodName.equalsIgnoreCase("FastConverge") && primaryColumn != null) {
            scramblingMethod = new FastConvergeScramblingMethod(blockSize, (String)this.scratchpadSchema.get(), primaryColumn);
        } else {
            throw new VerdictDBValueException("Invalid scrambling method: " + methodName);
        }
        ScramblingPlan plan = ScramblingPlan.create(newSchema, newTable, originalSchema, originalTable, scramblingMethod, effectiveOptions);
        ExecutablePlanRunner.runTillEnd(this.conn, plan);
        String blockColumn = (String)effectiveOptions.get("blockColumnName");
        int blockCount = scramblingMethod.getBlockCount();
        String tierColumn = (String)effectiveOptions.get("tierColumnName");
        int tierCount = scramblingMethod.getTierCount();
        HashMap<Integer, List<Double>> cumulativeDistribution = new HashMap<Integer, List<Double>>();
        for (int i = 0; i < tierCount; ++i) {
            List<Double> dist = scramblingMethod.getStoredCumulativeProbabilityDistributionForTier(i);
            cumulativeDistribution.put(i, dist);
        }
        ScrambleMeta meta = new ScrambleMeta(newSchema, newTable, originalSchema, originalTable, blockColumn, blockCount, tierColumn, tierCount, cumulativeDistribution);
        return meta;
    }
}

