/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.coordinator;

import org.antlr.v4.runtime.tree.ParseTree;
import org.verdictdb.VerdictContext;
import org.verdictdb.coordinator.ScramblingCoordinator;
import org.verdictdb.coordinator.SelectQueryCoordinator;
import org.verdictdb.coordinator.VerdictResultStream;
import org.verdictdb.coordinator.VerdictSingleResult;
import org.verdictdb.core.resulthandler.ExecutionResultReader;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.exception.VerdictDBTypeException;
import org.verdictdb.parser.VerdictSQLParser;
import org.verdictdb.parser.VerdictSQLParserBaseVisitor;
import org.verdictdb.sqlreader.NonValidatingSQLParser;

public class ExecutionContext {
    private VerdictContext context;
    private final long serialNumber;

    public ExecutionContext(VerdictContext context, long serialNumber) {
        this.context = context;
        this.serialNumber = serialNumber;
    }

    public long getExecutionContextSerialNumber() {
        return this.serialNumber;
    }

    public VerdictSingleResult sql(String query) throws VerdictDBException {
        VerdictResultStream stream = this.streamsql(query);
        if (stream == null) {
            return null;
        }
        VerdictSingleResult result = stream.next();
        stream.close();
        return result;
    }

    public VerdictResultStream streamsql(String query) throws VerdictDBException {
        QueryType queryType = this.identifyQueryType(query);
        if (queryType.equals((Object)QueryType.select)) {
            SelectQueryCoordinator coordinator = new SelectQueryCoordinator(this.context.getCopiedConnection());
            ExecutionResultReader reader = coordinator.process(query);
            VerdictResultStream stream = new VerdictResultStream(reader, this);
            return stream;
        }
        if (queryType.equals((Object)QueryType.scrambling)) {
            ScramblingCoordinator coordinator = new ScramblingCoordinator(this.context.getCopiedConnection());
            return null;
        }
        if (queryType.equals((Object)QueryType.set_default_schema)) {
            this.updateDefaultSchemaFromQuery(query);
            return null;
        }
        throw new VerdictDBTypeException("Unexpected type of query: " + query);
    }

    private void updateDefaultSchemaFromQuery(String query) {
        VerdictSQLParser parser = NonValidatingSQLParser.parserOf(query);
        String schema = parser.use_statement().database.getText();
        this.context.getConnection().setDefaultSchema(schema);
    }

    public void terminate() {
    }

    private QueryType identifyQueryType(String query) {
        VerdictSQLParser parser = NonValidatingSQLParser.parserOf(query);
        VerdictSQLParserBaseVisitor<QueryType> visitor = new VerdictSQLParserBaseVisitor<QueryType>(){

            @Override
            public QueryType visitSelect_statement(VerdictSQLParser.Select_statementContext ctx) {
                return QueryType.select;
            }

            @Override
            public QueryType visitCreate_scramble_statement(VerdictSQLParser.Create_scramble_statementContext ctx) {
                return QueryType.scrambling;
            }

            @Override
            public QueryType visitUse_statement(VerdictSQLParser.Use_statementContext ctx) {
                return QueryType.set_default_schema;
            }
        };
        QueryType type = (QueryType)((Object)visitor.visit((ParseTree)parser.verdict_statement()));
        return type;
    }

    private static enum QueryType {
        select,
        scrambling,
        set_default_schema,
        unknown;

    }
}

