/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.connection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DataTypeConverter;
import org.verdictdb.connection.MetaDataProvider;

public class StaticMetaData
implements MetaDataProvider {
    private String defaultSchema = "";
    private HashMap<TableInfo, List<Pair<String, Integer>>> tablesData = new HashMap();
    private List<String> schemas = new ArrayList<String>();
    private HashMap<String, List<String>> tables = new HashMap();
    private HashMap<Pair<String, String>, List<Pair<String, Integer>>> columns = new HashMap();
    private HashMap<Pair<String, String>, List<String>> partitions = new HashMap();

    public StaticMetaData() {
    }

    public StaticMetaData(HashMap<TableInfo, List<Pair<String, Integer>>> tablesData) {
        this.tablesData = tablesData;
        for (Map.Entry<TableInfo, List<Pair<String, Integer>>> entry : tablesData.entrySet()) {
            if (!this.schemas.contains(entry.getKey().schema)) {
                this.schemas.add(entry.getKey().schema);
            }
            this.tables.get(entry.getKey().schema).add(entry.getKey().tablename);
            this.columns.put((Pair<String, String>)new ImmutablePair((Object)entry.getKey().schema, (Object)entry.getKey().tablename), entry.getValue());
        }
    }

    public void addTableData(TableInfo table, List<Pair<String, Integer>> column) {
        this.tablesData.put(table, column);
        if (!this.schemas.contains(table.schema)) {
            this.schemas.add(table.schema);
            this.tables.put(table.schema, new ArrayList());
        }
        this.tables.get(table.schema).add(table.tablename);
        this.columns.put((Pair<String, String>)new ImmutablePair((Object)table.schema, (Object)table.tablename), column);
    }

    public void addPartition(TableInfo table, List<String> column) {
        this.partitions.put((Pair<String, String>)new ImmutablePair((Object)table.schema, (Object)table.tablename), column);
    }

    @Override
    public void setDefaultSchema(String schema) {
        this.defaultSchema = schema;
    }

    @Override
    public List<String> getSchemas() {
        return this.schemas;
    }

    @Override
    public List<String> getTables(String schema) {
        return this.tables.get(schema);
    }

    @Override
    public List<Pair<String, String>> getColumns(String schema, String table) {
        ArrayList<Pair<String, String>> nameAndType = new ArrayList<Pair<String, String>>();
        List<Pair<String, Integer>> nameAndIntType = this.columns.get(new ImmutablePair((Object)schema, (Object)table));
        for (Pair<String, Integer> a : nameAndIntType) {
            nameAndType.add((Pair<String, String>)Pair.of((Object)a.getLeft(), (Object)DataTypeConverter.typeName((Integer)a.getRight())));
        }
        return nameAndType;
    }

    @Override
    public List<String> getPartitionColumns(String schema, String table) {
        return this.partitions.get(new ImmutablePair((Object)schema, (Object)table));
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public HashMap<TableInfo, List<Pair<String, Integer>>> getTablesData() {
        return this.tablesData;
    }

    public static class TableInfo {
        String schema;
        String tablename;

        public TableInfo(String schema, String tablename) {
            this.schema = schema;
            this.tablename = tablename;
        }

        public static TableInfo getTableInfo(String schema, String tablename) {
            return new TableInfo(schema, tablename);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

