/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.connection;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.verdictdb.commons.AttributeValueRetrievalHelper;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.connection.DbmsQueryResultMetaData;
import org.verdictdb.connection.SparkDataTypeConverter;

public class SparkQueryResult
extends AttributeValueRetrievalHelper
implements DbmsQueryResult {
    private static final long serialVersionUID = 668595110560739261L;
    List<String> columnNames = new ArrayList<String>();
    List<Integer> columnTypes = new ArrayList<Integer>();
    List<Row> result = new ArrayList<Row>();
    DbmsQueryResultMetaData dbmsQueryResultMetaData = new DbmsQueryResultMetaData();
    int cursor = -1;

    public SparkQueryResult(Dataset<Row> dataset) {
        ArrayList<Integer> nullable = new ArrayList<Integer>();
        ArrayList<String> columnClassName = new ArrayList<String>();
        for (StructField structField : dataset.schema().fields()) {
            if (structField.nullable()) {
                nullable.add(1);
            } else {
                nullable.add(0);
            }
            this.columnNames.add(structField.name());
            int type = SparkDataTypeConverter.typeInt(structField.dataType());
            this.columnTypes.add(type);
            columnClassName.add(SparkDataTypeConverter.typeClassName(type));
        }
        this.dbmsQueryResultMetaData.isNullable = nullable;
        this.dbmsQueryResultMetaData.columnClassName = columnClassName;
        this.result = dataset.collectAsList();
    }

    @Override
    public DbmsQueryResultMetaData getMetaData() {
        return this.dbmsQueryResultMetaData;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int index) {
        return this.columnNames.get(index);
    }

    @Override
    public int getColumnType(int index) {
        return this.columnTypes.get(index);
    }

    @Override
    public boolean next() {
        if (this.cursor < this.result.size() - 1) {
            ++this.cursor;
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(int index) {
        Object value = null;
        try {
            value = this.result.get(this.cursor).get(index);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public void printContent() {
        boolean isFirstCol = true;
        StringBuilder row = new StringBuilder();
        for (String col : this.columnNames) {
            if (isFirstCol) {
                row.append(col);
                isFirstCol = false;
                continue;
            }
            row.append("\t" + col);
        }
        System.out.println(row.toString());
        int colCount = this.getColumnCount();
        while (this.next()) {
            row = new StringBuilder();
            for (int i = 0; i < colCount; ++i) {
                if (i == 0) {
                    row.append(this.getValue(i).toString());
                    continue;
                }
                row.append("\t");
                row.append(this.getValue(i).toString());
            }
            System.out.println(row.toString());
        }
    }

    @Override
    public void rewind() {
        this.cursor = -1;
    }

    @Override
    public long getRowCount() {
        return this.result.size();
    }
}

