/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.connection;

import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;

public class SparkDataTypeConverter {
    public static int typeInt(DataType type) {
        if (type instanceof BinaryType) {
            return -7;
        }
        if (type instanceof BooleanType) {
            return 16;
        }
        if (type instanceof DateType) {
            return 91;
        }
        if (type instanceof StringType) {
            return 12;
        }
        if (type instanceof TimestampType) {
            return 93;
        }
        if (type instanceof DecimalType) {
            return 3;
        }
        if (type instanceof DoubleType) {
            return 8;
        }
        if (type instanceof FloatType) {
            return 6;
        }
        if (type instanceof ByteType) {
            return 5;
        }
        if (type instanceof IntegerType) {
            return 4;
        }
        if (type instanceof LongType) {
            return -5;
        }
        if (type instanceof ShortType) {
            return 5;
        }
        if (type instanceof ArrayType) {
            return 2003;
        }
        if (type instanceof StructType) {
            return 2002;
        }
        return 1111;
    }

    public static String typeClassName(int type) {
        if (type == 12) {
            return "java.lang.String";
        }
        if (type == -7 || type == 16) {
            return "java.lang.Boolean";
        }
        if (type == 91) {
            return "java.sql.Date";
        }
        if (type == 93) {
            return "java.sql.Timestamp";
        }
        if (type == 3) {
            return "java.math.BigDecimal";
        }
        if (type == 8) {
            return "java.lang.Double";
        }
        if (type == 6) {
            return "java.lang.Float";
        }
        if (type == 5) {
            return "java.lang.Short";
        }
        if (type == 4) {
            return "java.lang.Integer";
        }
        if (type == -5) {
            return "java.lang.Long";
        }
        return "java.lang.Object";
    }
}

