/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.connection;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.verdictdb.connection.DbmsConnection;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.connection.SparkQueryResult;
import org.verdictdb.exception.VerdictDBDbmsException;
import org.verdictdb.sqlsyntax.SparkSyntax;
import org.verdictdb.sqlsyntax.SqlSyntax;

public class SparkConnection
implements DbmsConnection {
    SparkSession sc;
    SqlSyntax syntax;
    String currentSchema;

    public SparkConnection(SparkSession sc) {
        this.sc = sc;
        this.syntax = new SparkSyntax();
    }

    public SparkConnection(SparkSession sc, SqlSyntax syntax) {
        this.sc = sc;
        this.syntax = syntax;
    }

    @Override
    public List<String> getSchemas() throws VerdictDBDbmsException {
        ArrayList<String> schemas = new ArrayList<String>();
        DbmsQueryResult queryResult = this.execute(this.syntax.getSchemaCommand());
        while (queryResult.next()) {
            schemas.add((String)queryResult.getValue(this.syntax.getSchemaNameColumnIndex()));
        }
        return schemas;
    }

    @Override
    public List<String> getTables(String schema) throws VerdictDBDbmsException {
        ArrayList<String> tables = new ArrayList<String>();
        DbmsQueryResult queryResult = this.execute(this.syntax.getTableCommand(schema));
        while (queryResult.next()) {
            tables.add((String)queryResult.getValue(this.syntax.getTableNameColumnIndex()));
        }
        return tables;
    }

    @Override
    public List<Pair<String, String>> getColumns(String schema, String table) throws VerdictDBDbmsException {
        ArrayList<Pair<String, String>> columns = new ArrayList<Pair<String, String>>();
        DbmsQueryResult queryResult = this.execute(this.syntax.getColumnsCommand(schema, table));
        while (queryResult.next()) {
            String name = queryResult.getString(this.syntax.getColumnNameColumnIndex());
            String type = queryResult.getString(this.syntax.getColumnTypeColumnIndex());
            type = type.toLowerCase();
            if (name.equalsIgnoreCase("# Partition Information")) break;
            columns.add((Pair<String, String>)new ImmutablePair((Object)name, (Object)type));
        }
        return columns;
    }

    @Override
    public List<String> getPartitionColumns(String schema, String table) throws VerdictDBDbmsException {
        ArrayList<String> partition = new ArrayList<String>();
        DbmsQueryResult queryResult = this.execute(this.syntax.getPartitionCommand(schema, table));
        boolean hasPartitionInfoStarted = false;
        while (queryResult.next()) {
            String name = queryResult.getString(0);
            if (hasPartitionInfoStarted && !name.equalsIgnoreCase("# col_name")) {
                partition.add(name);
                continue;
            }
            if (!name.equalsIgnoreCase("# Partition Information")) continue;
            hasPartitionInfoStarted = true;
        }
        return partition;
    }

    @Override
    public String getDefaultSchema() {
        return this.currentSchema;
    }

    @Override
    public void setDefaultSchema(String schema) {
        this.currentSchema = schema;
    }

    @Override
    public DbmsQueryResult execute(String query) throws VerdictDBDbmsException {
        try {
            SparkQueryResult srs = null;
            Dataset result = this.sc.sql(query);
            if (result != null) {
                srs = new SparkQueryResult((Dataset<Row>)result);
            }
            return srs;
        }
        catch (Exception e) {
            throw new VerdictDBDbmsException(e.getMessage());
        }
    }

    @Override
    public SqlSyntax getSyntax() {
        return this.syntax;
    }

    @Override
    public void close() {
        try {
            this.sc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SparkSession getSparkSession() {
        return this.sc;
    }

    @Override
    public DbmsConnection copy() {
        SparkConnection newConn = new SparkConnection(this.sc, this.syntax);
        newConn.setDefaultSchema(this.currentSchema);
        return newConn;
    }
}

