/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.connection;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.verdictdb.commons.AttributeValueRetrievalHelper;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.connection.DbmsQueryResultMetaData;

public class JdbcQueryResult
extends AttributeValueRetrievalHelper
implements DbmsQueryResult {
    private static final long serialVersionUID = 2576550992419489091L;
    List<String> columnNames = new ArrayList<String>();
    List<Integer> columnTypes = new ArrayList<Integer>();
    List<List<Object>> result = new ArrayList<List<Object>>();
    int cursor = -1;
    DbmsQueryResultMetaData dbmsQueryResultMetaData = new DbmsQueryResultMetaData();

    public JdbcQueryResult(ResultSet resultSet) throws SQLException {
        ArrayList<Boolean> isCurrency = new ArrayList<Boolean>();
        ArrayList<Integer> isNullable = new ArrayList<Integer>();
        ArrayList<Integer> precision = new ArrayList<Integer>();
        ArrayList<Integer> scale = new ArrayList<Integer>();
        ArrayList<Integer> columnDisplaySize = new ArrayList<Integer>();
        ArrayList<Boolean> isAutoIncrement = new ArrayList<Boolean>();
        ArrayList<String> columnClassName = new ArrayList<String>();
        ResultSetMetaData meta = resultSet.getMetaData();
        int columnCount = meta.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.columnNames.add(meta.getColumnLabel(i + 1).toLowerCase());
            this.columnTypes.add(meta.getColumnType(i + 1));
            precision.add(meta.getPrecision(i + 1));
            scale.add(meta.getScale(i + 1));
            columnDisplaySize.add(meta.getColumnDisplaySize(i + 1));
            isNullable.add(meta.isNullable(i + 1));
            isCurrency.add(meta.isCurrency(i + 1));
            isAutoIncrement.add(meta.isAutoIncrement(i + 1));
            columnClassName.add(meta.getColumnClassName(i + 1));
        }
        this.dbmsQueryResultMetaData.columnDisplaySize = columnDisplaySize;
        this.dbmsQueryResultMetaData.isAutoIncrement = isAutoIncrement;
        this.dbmsQueryResultMetaData.isCurrency = isCurrency;
        this.dbmsQueryResultMetaData.isNullable = isNullable;
        this.dbmsQueryResultMetaData.precision = precision;
        this.dbmsQueryResultMetaData.scale = scale;
        this.dbmsQueryResultMetaData.columnClassName = columnClassName;
        while (resultSet.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int i = 0; i < columnCount; ++i) {
                Object value = resultSet.getObject(i + 1);
                row.add(value);
            }
            this.result.add(row);
        }
    }

    @Override
    public DbmsQueryResultMetaData getMetaData() {
        return this.dbmsQueryResultMetaData;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int index) {
        return this.columnNames.get(index);
    }

    @Override
    public int getColumnType(int index) {
        return this.columnTypes.get(index);
    }

    @Override
    public boolean next() {
        if (this.cursor < this.result.size() - 1) {
            ++this.cursor;
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(int index) {
        Object value = null;
        try {
            value = this.result.get(this.cursor).get(index);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public void printContent() {
        int oldCursor = this.cursor;
        this.rewind();
        boolean isFirstCol = true;
        StringBuilder row = new StringBuilder();
        for (String col : this.columnNames) {
            if (isFirstCol) {
                row.append(col);
                isFirstCol = false;
                continue;
            }
            row.append("\t" + col);
        }
        System.out.println(row.toString());
        int colCount = this.getColumnCount();
        while (this.next()) {
            row = new StringBuilder();
            for (int i = 0; i < colCount; ++i) {
                if (i == 0) {
                    row.append(this.getString(i));
                    continue;
                }
                row.append("\t");
                row.append(this.getString(i));
            }
            System.out.println(row.toString());
        }
        this.cursor = oldCursor;
    }

    public List<List<Object>> getResult() {
        return this.result;
    }

    @Override
    public void rewind() {
        this.cursor = -1;
    }

    @Override
    public long getRowCount() {
        return this.result.size();
    }
}

