/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.connection;

import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DbmsConnection;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.connection.JdbcQueryResult;
import org.verdictdb.exception.VerdictDBDbmsException;
import org.verdictdb.sqlsyntax.HiveSyntax;
import org.verdictdb.sqlsyntax.ImpalaSyntax;
import org.verdictdb.sqlsyntax.PostgresqlSyntax;
import org.verdictdb.sqlsyntax.RedshiftSyntax;
import org.verdictdb.sqlsyntax.SparkSyntax;
import org.verdictdb.sqlsyntax.SqlSyntax;
import org.verdictdb.sqlsyntax.SqlSyntaxList;

public class JdbcConnection
implements DbmsConnection {
    Connection conn;
    SqlSyntax syntax;
    String currentSchema = null;
    JdbcQueryResult jrs = null;
    private boolean outputDebugMessage = false;

    public static JdbcConnection create(Connection conn) throws VerdictDBDbmsException {
        String connectionString = null;
        try {
            connectionString = conn.getMetaData().getURL();
        }
        catch (SQLException e) {
            throw new VerdictDBDbmsException(e);
        }
        SqlSyntax syntax = SqlSyntaxList.getSyntaxFromConnectionString(connectionString);
        JdbcConnection jdbcConn = new JdbcConnection(conn, syntax);
        return jdbcConn;
    }

    public JdbcConnection(Connection conn, SqlSyntax syntax) {
        this.conn = conn;
        try {
            this.currentSchema = syntax instanceof PostgresqlSyntax || syntax instanceof RedshiftSyntax ? conn.getSchema() : conn.getCatalog();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (this.currentSchema == null || this.currentSchema.length() == 0) {
            this.currentSchema = syntax.getFallbackDefaultSchema();
        }
        this.syntax = syntax;
    }

    @Override
    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DbmsQueryResult execute(String sql) throws VerdictDBDbmsException {
        if (this.outputDebugMessage) {
            System.out.println("About to issue this batch query: " + sql);
        }
        String quoteChars = "'\"";
        List<String> sqls = this.splitOnSemicolon(sql, quoteChars);
        DbmsQueryResult finalResult = null;
        for (String s : sqls) {
            finalResult = this.executeSingle(s);
        }
        return finalResult;
    }

    private List<String> splitOnSemicolon(String sql, String quoteChars) {
        String s;
        ArrayList<String> splitted = new ArrayList<String>();
        HashMap<Character, Integer> quoteCharCounts = new HashMap<Character, Integer>();
        HashSet quoteCharSet = Sets.newHashSet((Object[])ArrayUtils.toObject((char[])quoteChars.toCharArray()));
        Iterator iterator = quoteCharSet.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            quoteCharCounts.put(Character.valueOf(c), 0);
        }
        char delimiter = ';';
        StringBuilder beginConstructed = new StringBuilder();
        for (char c : sql.toCharArray()) {
            if (c == delimiter) {
                boolean oddCountQuoteExist = false;
                Iterator iterator2 = quoteCharCounts.values().iterator();
                while (iterator2.hasNext()) {
                    int count = (Integer)iterator2.next();
                    if (count % 2 != 1) continue;
                    oddCountQuoteExist = true;
                    break;
                }
                if (oddCountQuoteExist) continue;
                splitted.add(beginConstructed.toString());
                beginConstructed = new StringBuilder();
                continue;
            }
            beginConstructed.append(c);
            if (!quoteCharSet.contains(Character.valueOf(c))) continue;
            quoteCharCounts.put(Character.valueOf(c), (Integer)quoteCharCounts.get(Character.valueOf(c)) + 1);
        }
        if (beginConstructed.length() > 0 && (s = beginConstructed.toString()).trim().length() > 0) {
            splitted.add(s);
        }
        return splitted;
    }

    public DbmsQueryResult executeSingle(String sql) throws VerdictDBDbmsException {
        if (this.outputDebugMessage) {
            System.out.println("About to issue this query: " + sql);
        }
        try {
            Statement stmt = this.conn.createStatement();
            JdbcQueryResult jrs = null;
            boolean doesResultExist = stmt.execute(sql);
            if (doesResultExist) {
                ResultSet rs = stmt.getResultSet();
                jrs = new JdbcQueryResult(rs);
                rs.close();
            } else {
                jrs = null;
            }
            stmt.close();
            return jrs;
        }
        catch (SQLException e) {
            throw new VerdictDBDbmsException(e.getMessage());
        }
    }

    public DbmsQueryResult executeQuery(String sql) throws VerdictDBDbmsException {
        return this.execute(sql);
    }

    @Override
    public SqlSyntax getSyntax() {
        return this.syntax;
    }

    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public List<String> getSchemas() throws VerdictDBDbmsException {
        ArrayList<String> schemas = new ArrayList<String>();
        DbmsQueryResult queryResult = this.executeQuery(this.syntax.getSchemaCommand());
        while (queryResult.next()) {
            schemas.add(queryResult.getString(this.syntax.getSchemaNameColumnIndex()));
        }
        return schemas;
    }

    @Override
    public List<String> getTables(String schema) throws VerdictDBDbmsException {
        ArrayList<String> tables = new ArrayList<String>();
        DbmsQueryResult queryResult = this.executeQuery(this.syntax.getTableCommand(schema));
        while (queryResult.next()) {
            tables.add(queryResult.getString(this.syntax.getTableNameColumnIndex()));
        }
        return tables;
    }

    @Override
    public List<Pair<String, String>> getColumns(String schema, String table) throws VerdictDBDbmsException {
        ArrayList<Pair<String, String>> columns = new ArrayList<Pair<String, String>>();
        DbmsQueryResult queryResult = this.executeQuery(this.syntax.getColumnsCommand(schema, table));
        while (queryResult.next()) {
            String type;
            if (this.syntax instanceof PostgresqlSyntax) {
                type = queryResult.getString(this.syntax.getColumnTypeColumnIndex());
                if (queryResult.getInt(((PostgresqlSyntax)this.syntax).getCharacterMaximumLengthColumnIndex()) != 0) {
                    type = type + "(" + queryResult.getInt(((PostgresqlSyntax)this.syntax).getCharacterMaximumLengthColumnIndex()) + ")";
                }
            } else {
                type = queryResult.getString(this.syntax.getColumnTypeColumnIndex());
            }
            type = type.toLowerCase();
            columns.add((Pair<String, String>)new ImmutablePair((Object)queryResult.getString(this.syntax.getColumnNameColumnIndex()), (Object)type));
        }
        return columns;
    }

    @Override
    public List<String> getPartitionColumns(String schema, String table) throws VerdictDBDbmsException {
        ArrayList<String> partition;
        block11: {
            DbmsQueryResult queryResult;
            block10: {
                partition = new ArrayList<String>();
                if (this.syntax instanceof ImpalaSyntax) {
                    try {
                        String columnName;
                        DbmsQueryResult queryResult2 = this.executeQuery(this.syntax.getPartitionCommand(schema, table));
                        for (int i = 0; i < queryResult2.getColumnCount() && !(columnName = queryResult2.getColumnName(i)).equals("#rows"); ++i) {
                            partition.add(columnName);
                        }
                        return partition;
                    }
                    catch (Exception e) {
                        return partition;
                    }
                }
                queryResult = this.executeQuery(this.syntax.getPartitionCommand(schema, table));
                if (!(this.syntax instanceof PostgresqlSyntax)) break block10;
                if (!queryResult.next()) break block11;
                Object o = queryResult.getValue(0);
                String[] arr = o.toString().split(" ");
                List<Pair<String, String>> columns = this.getColumns(schema, table);
                for (int i = 0; i < arr.length; ++i) {
                    partition.add((String)columns.get(Integer.valueOf(arr[i]) - 1).getKey());
                }
                break block11;
            }
            if (this.syntax instanceof HiveSyntax || this.syntax instanceof SparkSyntax) {
                boolean hasPartitionInfoStarted = false;
                while (queryResult.next()) {
                    String name = queryResult.getString(0);
                    if (hasPartitionInfoStarted && !name.equalsIgnoreCase("# col_name")) {
                        partition.add(name);
                        continue;
                    }
                    if (!name.equalsIgnoreCase("# Partition Information")) continue;
                    hasPartitionInfoStarted = true;
                }
            } else {
                while (queryResult.next()) {
                    partition.add(queryResult.getString(0));
                }
            }
        }
        return partition;
    }

    @Override
    public String getDefaultSchema() {
        return this.currentSchema;
    }

    @Override
    public void setDefaultSchema(String schema) {
        this.currentSchema = schema;
    }

    public DatabaseMetaData getMetadata() throws VerdictDBDbmsException {
        try {
            return this.conn.getMetaData();
        }
        catch (SQLException e) {
            throw new VerdictDBDbmsException(e);
        }
    }

    public boolean isOutputDebugMessage() {
        return this.outputDebugMessage;
    }

    public void setOutputDebugMessage(boolean outputDebugMessage) {
        this.outputDebugMessage = outputDebugMessage;
    }

    @Override
    public DbmsConnection copy() {
        JdbcConnection newConn = new JdbcConnection(this.conn, this.syntax);
        newConn.setDefaultSchema(this.currentSchema);
        newConn.jrs = this.jrs;
        newConn.outputDebugMessage = this.outputDebugMessage;
        return newConn;
    }
}

