/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.connection;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DataTypeConverter {
    static final Map<Integer, String> intToStringMap = new HashMap<Integer, String>();
    static final Map<String, Integer> stringToIntMap;
    private static HashSet<Integer> numericTypes;

    public static String typeName(int inttype) {
        return intToStringMap.get(inttype);
    }

    public static int typeInt(String typename) {
        String type = typename.toLowerCase().replaceAll("\\(.*\\)", "");
        return stringToIntMap.get(type);
    }

    public static boolean isNumeric(String typename) {
        int type = DataTypeConverter.typeInt(typename);
        return numericTypes.contains(type);
    }

    static {
        intToStringMap.put(2003, "array");
        intToStringMap.put(-5, "bigint");
        intToStringMap.put(-2, "binary");
        intToStringMap.put(-7, "bit");
        intToStringMap.put(2004, "blob");
        intToStringMap.put(16, "boolean");
        intToStringMap.put(1, "char");
        intToStringMap.put(2005, "clob");
        intToStringMap.put(70, "datalink");
        intToStringMap.put(91, "date");
        intToStringMap.put(3, "decimal");
        intToStringMap.put(2001, "distinct");
        intToStringMap.put(6, "float");
        intToStringMap.put(4, "integer");
        intToStringMap.put(-16, "longnvarchar");
        intToStringMap.put(-4, "longvarbinary");
        intToStringMap.put(-1, "longvarJdchar");
        intToStringMap.put(-15, "nchar");
        intToStringMap.put(2011, "nclob");
        intToStringMap.put(0, "null");
        intToStringMap.put(2, "numeric");
        intToStringMap.put(-9, "nvarchar");
        intToStringMap.put(7, "real");
        intToStringMap.put(2006, "ref");
        intToStringMap.put(-8, "rowid");
        intToStringMap.put(5, "smallint");
        intToStringMap.put(2009, "xml");
        intToStringMap.put(2002, "struct");
        intToStringMap.put(92, "time");
        intToStringMap.put(93, "timestamp");
        intToStringMap.put(-6, "tinyint");
        intToStringMap.put(-3, "varbinary");
        intToStringMap.put(12, "varchar");
        intToStringMap.put(8, "double");
        stringToIntMap = new HashMap<String, Integer>();
        for (Map.Entry<Integer, String> pair : intToStringMap.entrySet()) {
            stringToIntMap.put(pair.getValue(), pair.getKey());
        }
        stringToIntMap.put("character varying", 12);
        stringToIntMap.put("character", 1);
        stringToIntMap.put("int", 4);
        stringToIntMap.put("mediumint", 4);
        stringToIntMap.put("text", -16);
        stringToIntMap.put("double precision", 8);
        stringToIntMap.put("smallserial", 4);
        stringToIntMap.put("serial", 4);
        stringToIntMap.put("bigserial", -5);
        stringToIntMap.put("string", 12);
        stringToIntMap.put("datetime", 93);
        stringToIntMap.put("timestamp", 93);
        stringToIntMap.put("timestamp without time zone", 93);
        stringToIntMap.put("tinyblob", 2004);
        stringToIntMap.put("mediumblob", 2004);
        stringToIntMap.put("longblob", 2004);
        stringToIntMap.put("tinytext", 12);
        stringToIntMap.put("mediumtext", 12);
        stringToIntMap.put("longtext", 12);
        stringToIntMap.put("enum", 1);
        stringToIntMap.put("set", 1);
        stringToIntMap.put("year", 91);
        stringToIntMap.put("bit varying", -2);
        stringToIntMap.put("box", 2004);
        stringToIntMap.put("bytea", -4);
        stringToIntMap.put("cidr", 12);
        stringToIntMap.put("circle", 2004);
        stringToIntMap.put("inet", 12);
        stringToIntMap.put("json", 2005);
        stringToIntMap.put("line", 2004);
        stringToIntMap.put("lseg", 2004);
        stringToIntMap.put("macaddr", 12);
        stringToIntMap.put("macaddr8", 12);
        stringToIntMap.put("money", 8);
        stringToIntMap.put("path", 2004);
        stringToIntMap.put("point", 2004);
        stringToIntMap.put("polygon", 2004);
        stringToIntMap.put("time without time zone", 92);
        stringToIntMap.put("time with time zone", 92);
        stringToIntMap.put("timestamp with time zone", 93);
        stringToIntMap.put("uuid", 12);
        numericTypes = new HashSet<Integer>(Arrays.asList(3, 6, 8, 7, 2, 4, -6, 5, -5));
    }
}

