/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.connection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.MetaDataProvider;
import org.verdictdb.exception.VerdictDBDbmsException;

public class CachedMetaDataProvider
implements MetaDataProvider {
    MetaDataProvider metaProvider;
    private List<String> schemaCache = new ArrayList<String>();
    private HashMap<String, List<String>> tablesCache = new HashMap();
    private HashMap<Pair<String, String>, List<String>> partitionCache = new HashMap();
    private HashMap<Pair<String, String>, List<Pair<String, String>>> columnsCache = new HashMap();

    public CachedMetaDataProvider(MetaDataProvider metaProvider) {
        this.metaProvider = metaProvider;
    }

    @Override
    public List<String> getSchemas() throws VerdictDBDbmsException {
        if (!this.schemaCache.isEmpty()) {
            return this.schemaCache;
        }
        this.schemaCache.addAll(this.metaProvider.getSchemas());
        return this.schemaCache;
    }

    @Override
    public List<String> getTables(String schema) throws VerdictDBDbmsException {
        if (this.tablesCache.containsKey(schema) && !this.tablesCache.get(schema).isEmpty()) {
            return this.tablesCache.get(schema);
        }
        this.tablesCache.put(schema, this.metaProvider.getTables(schema));
        return this.tablesCache.get(schema);
    }

    @Override
    public List<Pair<String, String>> getColumns(String schema, String table) throws VerdictDBDbmsException {
        ImmutablePair key = new ImmutablePair((Object)schema, (Object)table);
        if (this.columnsCache.containsKey(key) && !this.columnsCache.get(key).isEmpty()) {
            return this.columnsCache.get(key);
        }
        this.columnsCache.put((Pair<String, String>)key, this.metaProvider.getColumns(schema, table));
        return this.columnsCache.get(key);
    }

    @Override
    public List<String> getPartitionColumns(String schema, String table) throws VerdictDBDbmsException {
        ImmutablePair key = new ImmutablePair((Object)schema, (Object)table);
        if (this.columnsCache.containsKey(key) && !this.partitionCache.isEmpty()) {
            return this.partitionCache.get(key);
        }
        this.partitionCache.put((Pair<String, String>)key, this.metaProvider.getPartitionColumns(schema, table));
        return this.partitionCache.get(key);
    }

    @Override
    public String getDefaultSchema() {
        String schema = this.metaProvider.getDefaultSchema();
        return schema;
    }

    @Override
    public void setDefaultSchema(String schema) {
        this.metaProvider.setDefaultSchema(schema);
    }
}

