/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.commons;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;
import org.verdictdb.connection.TypeCasting;
import org.verdictdb.jdbc41.VerdictJdbcArray;

public abstract class AttributeValueRetrievalHelper {
    private Map<String, Integer> lazyLabel2IndexMap = null;

    protected Integer getIndexOf(String label) {
        if (this.lazyLabel2IndexMap == null) {
            this.constructLabel2IndexMap();
        }
        return this.lazyLabel2IndexMap.get(label);
    }

    private void constructLabel2IndexMap() {
        int columnCount = this.getColumnCount();
        this.lazyLabel2IndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < columnCount; ++i) {
            this.lazyLabel2IndexMap.put(this.getColumnName(i), i);
        }
    }

    public abstract String getColumnName(int var1);

    public abstract int getColumnCount();

    public abstract Object getValue(int var1);

    public Boolean getBoolean(int index) throws SQLException {
        Object value = this.getValue(index);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float) {
            int v = Integer.valueOf(value.toString());
            if (v == 1) {
                return true;
            }
            if (v == 0) {
                return false;
            }
        } else if (value instanceof String) {
            String v = value.toString();
            if (v.equals("1") || v.equals("t") || v.equals("true")) {
                return true;
            }
            if (v.equals("0") || v.equals("f") || v.equals("false")) {
                return false;
            }
        }
        throw new SQLException("Not a valid value for Boolean type: " + value);
    }

    public Boolean getBoolean(String label) throws SQLException {
        int index = this.getIndexOf(label);
        return this.getBoolean(index);
    }

    public String getString(int index) {
        Object value = this.getValue(index);
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }

    public String getString(String label) {
        int index = this.getIndexOf(label);
        return this.getString(index);
    }

    public int getInt(int index) {
        Object value = this.getValue(index);
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            String v = value.toString();
            if (v.equals("t") || v.equals("true")) {
                return 1;
            }
            if (v.equals("f") || v.equals("false")) {
                return 0;
            }
        }
        return TypeCasting.toInteger(value);
    }

    public int getInt(String label) {
        int index = this.getIndexOf(label);
        return this.getInt(index);
    }

    public long getLong(int index) {
        Object value = this.getValue(index);
        if (value == null) {
            return 0L;
        }
        if (value instanceof String) {
            String v = value.toString();
            if (v.equals("t") || v.equals("true")) {
                return 1L;
            }
            if (v.equals("f") || v.equals("false")) {
                return 0L;
            }
        }
        return TypeCasting.toLong(value);
    }

    public long getLong(String label) {
        int index = this.getIndexOf(label);
        return this.getLong(index);
    }

    public double getDouble(int index) {
        Object value = this.getValue(index);
        if (value == null) {
            return 0.0;
        }
        return TypeCasting.toDouble(value);
    }

    public double getDouble(String label) {
        int index = this.getIndexOf(label);
        return this.getDouble(index);
    }

    public float getFloat(int index) {
        Object value = this.getValue(index);
        if (value == null) {
            return 0.0f;
        }
        return TypeCasting.toFloat(value).floatValue();
    }

    public float getFloat(String label) {
        int index = this.getIndexOf(label);
        return this.getFloat(index);
    }

    public Date getDate(int index) {
        Object value = this.getValue(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Timestamp) {
            return new Date(((Timestamp)value).getTime());
        }
        if (value instanceof Time) {
            return new Date(((Time)value).getTime());
        }
        return null;
    }

    public Date getDate(String label) {
        int index = this.getIndexOf(label);
        return this.getDate(index);
    }

    public byte getByte(int index) {
        Object value = this.getValue(index);
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            String v = value.toString();
            if (v.equals("t") || v.equals("true")) {
                return 1;
            }
            if (v.equals("f") || v.equals("false")) {
                return 0;
            }
        }
        return TypeCasting.toByte(value);
    }

    public byte getByte(String label) {
        int index = this.getIndexOf(label);
        return this.getByte(index);
    }

    public Timestamp getTimestamp(int index) {
        Object value = this.getValue(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof Time) {
            return new Timestamp(((Time)value).getTime());
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        return null;
    }

    public Timestamp getTimestamp(String label) {
        int index = this.getIndexOf(label);
        return this.getTimestamp(index);
    }

    public short getShort(int index) {
        Object value = this.getValue(index);
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            String v = value.toString();
            if (v.equals("t") || v.equals("true")) {
                return 1;
            }
            if (v.equals("f") || v.equals("false")) {
                return 0;
            }
        }
        return TypeCasting.toShort(value);
    }

    public short getShort(String label) {
        int index = this.getIndexOf(label);
        return this.getShort(index);
    }

    public BigDecimal getBigDecimal(int index, int scale) {
        BigDecimal value = TypeCasting.toBigDecimal(this.getValue(index), scale);
        return value;
    }

    public BigDecimal getBigDecimal(String label, int scale) {
        int index = this.getIndexOf(label);
        return this.getBigDecimal(index, scale);
    }

    public BigDecimal getBigDecimal(int index) {
        BigDecimal value = TypeCasting.toBigDecimal(this.getValue(index));
        return value;
    }

    public BigDecimal getBigDecimal(String label) {
        int index = this.getIndexOf(label);
        return this.getBigDecimal(index);
    }

    public byte[] getBytes(int index) {
        Object value = this.getValue(index);
        return (byte[])value;
    }

    public byte[] getBytes(String label) {
        int index = this.getIndexOf(label);
        return this.getBytes(index);
    }

    public Time getTime(int index) {
        Object value = this.getValue(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return new Time(((Date)value).getTime());
        }
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof Timestamp) {
            return new Time(((Timestamp)value).getTime());
        }
        return null;
    }

    public Time getTime(String label) {
        int index = this.getIndexOf(label);
        return this.getTime(index);
    }

    public InputStream getAsciiStream(int index) {
        Object value = this.getValue(index);
        return (InputStream)value;
    }

    public InputStream getAsciiStream(String label) {
        int index = this.getIndexOf(label);
        return this.getAsciiStream(index);
    }

    public InputStream getUnicodeStream(int index) {
        Object value = this.getValue(index);
        return (InputStream)value;
    }

    public InputStream getUnicodeStream(String label) {
        int index = this.getIndexOf(label);
        return this.getUnicodeStream(index);
    }

    public InputStream getBinaryStream(int index) {
        Object value = this.getValue(index);
        if (value == null) {
            byte[] a = new byte[]{};
            return new ByteArrayInputStream(a);
        }
        if (value instanceof byte[]) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])value);
            return byteArrayInputStream;
        }
        return (InputStream)value;
    }

    public InputStream getBinaryStream(String label) {
        int index = this.getIndexOf(label);
        return this.getBinaryStream(index);
    }

    public Ref getRef(int index) {
        Object value = this.getValue(index);
        return (Ref)value;
    }

    public Ref getRef(String label) {
        int index = this.getIndexOf(label);
        return this.getRef(index);
    }

    public Blob getBlob(int index) throws SQLException {
        Object value = this.getValue(index);
        if (value == null) {
            return null;
        }
        if (value instanceof Blob) {
            return (Blob)value;
        }
        return new SerialBlob((byte[])value);
    }

    public Blob getBlob(String label) throws SQLException {
        int index = this.getIndexOf(label);
        return this.getBlob(index);
    }

    public Clob getClob(int index) {
        Object value = this.getValue(index);
        return (Clob)value;
    }

    public Clob getClob(String label) {
        int index = this.getIndexOf(label);
        return this.getClob(index);
    }

    public Array getArray(int index) {
        Object value = this.getValue(index);
        VerdictJdbcArray array = new VerdictJdbcArray((Object[])value);
        return array;
    }

    public Array getArray(String label) {
        int index = this.getIndexOf(label);
        return this.getArray(index);
    }

    public URL getURL(int index) {
        Object value = this.getValue(index);
        return (URL)value;
    }

    public URL getURL(String label) {
        int index = this.getIndexOf(label);
        return this.getURL(index);
    }

    public RowId getRowId(int index) {
        Object value = this.getValue(index);
        return (RowId)value;
    }

    public RowId getRowId(String label) {
        int index = this.getIndexOf(label);
        return this.getRowId(index);
    }

    public NClob getNClob(int index) {
        Object value = this.getValue(index);
        return (NClob)value;
    }

    public NClob getNClob(String label) {
        int index = this.getIndexOf(label);
        return this.getNClob(index);
    }

    public SQLXML getSQLXML(int index) {
        Object value = this.getValue(index);
        return (SQLXML)value;
    }

    public SQLXML getSQLXML(String label) {
        int index = this.getIndexOf(label);
        return this.getSQLXML(index);
    }
}

