/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.RandomStringUtils;
import org.verdictdb.connection.CachedDbmsConnection;
import org.verdictdb.connection.DbmsConnection;
import org.verdictdb.connection.JdbcConnection;
import org.verdictdb.coordinator.ExecutionContext;
import org.verdictdb.coordinator.VerdictResultStream;
import org.verdictdb.coordinator.VerdictSingleResult;
import org.verdictdb.exception.VerdictDBDbmsException;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.sqlsyntax.SqlSyntax;
import org.verdictdb.sqlsyntax.SqlSyntaxList;

public class VerdictContext {
    private DbmsConnection conn;
    private final String contextId;
    private long executionSerialNumber = 0L;
    private List<ExecutionContext> executionContexts = new LinkedList<ExecutionContext>();

    public VerdictContext(DbmsConnection conn) {
        this.conn = new CachedDbmsConnection(conn);
        this.contextId = RandomStringUtils.randomAlphanumeric((int)5);
    }

    public static VerdictContext fromJdbcConnection(Connection jdbcConn) throws VerdictDBDbmsException {
        JdbcConnection conn = JdbcConnection.create(jdbcConn);
        return new VerdictContext(conn);
    }

    public static VerdictContext fromConnectionString(String jdbcConnectionString) throws SQLException, VerdictDBDbmsException {
        VerdictContext.attemptLoadDriverClass(jdbcConnectionString);
        Connection jdbcConn = DriverManager.getConnection(jdbcConnectionString);
        return VerdictContext.fromJdbcConnection(jdbcConn);
    }

    public static VerdictContext fromConnectionString(String jdbcConnectionString, Properties info) throws SQLException, VerdictDBDbmsException {
        VerdictContext.attemptLoadDriverClass(jdbcConnectionString);
        Connection jdbcConn = DriverManager.getConnection(jdbcConnectionString, info);
        return VerdictContext.fromJdbcConnection(jdbcConn);
    }

    public static VerdictContext fromConnectionString(String jdbcConnectionString, String user, String password) throws SQLException, VerdictDBDbmsException {
        VerdictContext.attemptLoadDriverClass(jdbcConnectionString);
        Connection jdbcConn = DriverManager.getConnection(jdbcConnectionString, user, password);
        return VerdictContext.fromJdbcConnection(jdbcConn);
    }

    private static void attemptLoadDriverClass(String jdbcConnectionString) {
        SqlSyntax syntax = SqlSyntaxList.getSyntaxFromConnectionString(jdbcConnectionString);
        Collection<String> driverClassNames = syntax.getCandidateJDBCDriverClassNames();
        for (String className : driverClassNames) {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    public DbmsConnection getConnection() {
        return this.conn;
    }

    public DbmsConnection getCopiedConnection() {
        return this.conn.copy();
    }

    public String getContextId() {
        return this.contextId;
    }

    public ExecutionContext createNewExecutionContext() {
        long execSerialNumber = this.getNextExecutionSerialNumber();
        ExecutionContext exec = new ExecutionContext(this, execSerialNumber);
        this.executionContexts.add(exec);
        return exec;
    }

    private synchronized long getNextExecutionSerialNumber() {
        ++this.executionSerialNumber;
        return this.executionSerialNumber;
    }

    private void removeExecutionContext(ExecutionContext exec) {
        this.executionContexts.remove(exec);
    }

    public void abort() {
    }

    public void scramble(String originalSchema, String originalTable) {
    }

    public void scramble(String originalSchema, String originalTable, String newSchema, String newTable) {
    }

    public VerdictSingleResult sql(String query) throws VerdictDBException {
        ExecutionContext exec = this.createNewExecutionContext();
        VerdictSingleResult result = exec.sql(query);
        this.removeExecutionContext(exec);
        return result;
    }

    public VerdictResultStream streamsql(String query) throws VerdictDBException {
        ExecutionContext exec = this.createNewExecutionContext();
        VerdictResultStream stream = exec.streamsql(query);
        return stream;
    }
}

