/*
 *    Copyright 2018 University of Michigan
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package org.verdictdb.core.sqlobject;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class AsteriskColumn implements UnnamedColumn, SelectItem {

  private static final long serialVersionUID = -930230895524125223L;

  String tablename = null;

  public AsteriskColumn() {};

  public static AsteriskColumn create() {
    return new AsteriskColumn();
  }

  public AsteriskColumn(String tablename) {
    this.tablename = tablename;
  }

  public String getTablename() {
    return tablename;
  }

  public void setTablename(String tablename) {
    this.tablename = tablename;
  }

  @Override
  public int hashCode() {
    return HashCodeBuilder.reflectionHashCode(this);
  }

  @Override
  public boolean equals(Object obj) {
    return EqualsBuilder.reflectionEquals(this, obj);
  }

  @Override
  public boolean isAggregateColumn() {
    return false;
  }

  @Override
  public AsteriskColumn deepcopy() {
    return new AsteriskColumn();
  }

  @Override
  public String toString() {
    return this.getClass().getSimpleName();
  }
}
