/*
 * Decompiled with CFR 0.152.
 */
package au.edu.apsr.mtk.ch;

import au.edu.apsr.mtk.ch.DefaultMETSHandler;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ExternalContentMETSHandler
extends DefaultMETSHandler {
    private static Logger log = Logger.getLogger(ExternalContentMETSHandler.class);
    private Document doc = null;
    private Stack<Element> elements = new Stack();
    private Locator locator;

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Element e = null;
        Object prefix = null;
        e = uri.length() > 0 ? this.doc.createElementNS(uri, qName) : this.doc.createElement(qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            e.setAttribute(attributes.getQName(i), attributes.getValue(i));
        }
        this.elements.push(e);
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        String s = new String(chars, start, length);
        if (!s.matches("\\s+")) {
            Element e = this.elements.peek();
            if (e.getTextContent().length() == 0) {
                e.setTextContent(s);
            } else {
                e.setTextContent(e.getTextContent() + s);
            }
        }
    }

    public void skippedEntity(String name) throws SAXException {
        String s = "&" + name + ";";
        char[] text = s.toCharArray();
        this.characters(text, 0, text.length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        Element e = this.elements.pop();
        if (!this.elements.empty()) {
            this.elements.peek().appendChild(e);
        } else {
            this.doc.appendChild(e);
        }
    }

    private String printLocation(String s) {
        int line = this.locator.getLineNumber();
        int column = this.locator.getColumnNumber();
        return s + " at line " + line + "; column " + column;
    }

    public Document getDocument() {
        return this.doc;
    }
}

