/*
 * Decompiled with CFR 0.152.
 */
package au.edu.apsr.mtk.ch;

import au.edu.apsr.mtk.ch.METSHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultMETSHandler
extends DefaultHandler
implements METSHandler {
    private static Logger log = Logger.getLogger(DefaultMETSHandler.class);
    private static final String TEMP_PREFIX = "mets";
    private static final int BUFFER_SIZE = 4096;
    private Document doc = null;
    private Stack<Element> elements = new Stack();
    private Locator locator;
    private File currFile = null;
    private FileOutputStream fos = null;

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.endsWith("FContent")) {
            return;
        }
        Element e = null;
        Object prefix = null;
        if (uri.length() > 0) {
            if (qName.endsWith("binData") && !this.elements.peek().getTagName().endsWith("mdWrap")) {
                try {
                    this.currFile = File.createTempFile(TEMP_PREFIX, null);
                    this.fos = new FileOutputStream(this.currFile);
                    e = this.createFLocat(uri, qName.split(":")[0]);
                }
                catch (IOException ioe) {
                    throw new SAXException(ioe);
                }
            } else {
                e = this.doc.createElementNS(uri, qName);
            }
        } else {
            e = qName.endsWith("binData") && !this.elements.peek().getTagName().endsWith("mdWrap") ? this.createFLocat() : this.doc.createElement(qName);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            e.setAttribute(attributes.getQName(i), attributes.getValue(i));
        }
        this.elements.push(e);
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        String s = new String(chars, start, length);
        if (!s.matches("\\s+")) {
            Element e = this.elements.peek();
            if (e.getTagName().contains("FLocat")) {
                try {
                    this.fos.write(s.getBytes());
                    this.fos.flush();
                }
                catch (IOException ioe) {
                    throw new SAXException(ioe);
                }
                return;
            }
            if (e.getTextContent().length() == 0) {
                e.setTextContent(s);
            } else {
                e.setTextContent(e.getTextContent() + s);
            }
        }
    }

    public void skippedEntity(String name) throws SAXException {
        String s = "&" + name + ";";
        char[] text = s.toCharArray();
        this.characters(text, 0, text.length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.endsWith("FContent")) {
            return;
        }
        if (qName.endsWith("binData") && !this.elements.peek().getTagName().endsWith("mdWrap")) {
            try {
                this.fos.close();
                this.decode();
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
        Element e = this.elements.pop();
        if (!this.elements.empty()) {
            this.elements.peek().appendChild(e);
        } else {
            this.doc.appendChild(e);
        }
    }

    private String printLocation(String s) {
        int line = this.locator.getLineNumber();
        int column = this.locator.getColumnNumber();
        return s + " at line " + line + "; column " + column;
    }

    private Element createFLocat(String uri, String prefix) {
        Element e = this.doc.createElementNS(uri, prefix + ":" + "FLocat");
        e.setAttribute("LOCTYPE", "URL");
        e.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "file://" + this.currFile.getParentFile() + File.separator + "dec-" + this.currFile.getName());
        return e;
    }

    private Element createFLocat() {
        Element e = this.doc.createElement("FLocat");
        e.setAttribute("LOCTYPE", "URL");
        e.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "file://" + this.currFile.getParentFile() + File.separator + "dec-" + this.currFile.getName());
        return e;
    }

    private void decode() throws IOException, SAXException {
        File f = new File(this.currFile.getParentFile() + File.separator + "dec-" + this.currFile.getName());
        FileInputStream fis = new FileInputStream(this.currFile);
        FileOutputStream fos = new FileOutputStream(f);
        byte[] buffer = new byte[4096];
        byte[] chunk = new byte[4];
        int got = -1;
        int ready = 0;
        block0: while ((got = fis.read(buffer)) > 0) {
            int skipped = 0;
            while (skipped < got) {
                while (ready < 4) {
                    int ch;
                    if (skipped >= got) continue block0;
                    if ((ch = this.check(buffer[skipped++])) < 0) continue;
                    chunk[ready++] = (byte)ch;
                }
                if (chunk[2] == 65) {
                    fos.write(this.get1(chunk, 0));
                    return;
                }
                if (chunk[3] == 65) {
                    fos.write(this.get1(chunk, 0));
                    fos.write(this.get2(chunk, 0));
                    return;
                }
                fos.write(this.get1(chunk, 0));
                fos.write(this.get2(chunk, 0));
                fos.write(this.get3(chunk, 0));
                ready = 0;
            }
        }
        if (ready != 0) {
            throw new SAXException("Encoded data has invalid length");
        }
        fos.close();
        fis.close();
    }

    private final int check(int ch) {
        if (ch >= 65 && ch <= 90) {
            return ch - 65;
        }
        if (ch >= 97 && ch <= 122) {
            return ch - 97 + 26;
        }
        if (ch >= 48 && ch <= 57) {
            return ch - 48 + 52;
        }
        switch (ch) {
            case 61: {
                return 65;
            }
            case 43: {
                return 62;
            }
            case 47: {
                return 63;
            }
        }
        return -1;
    }

    private final int get1(byte[] buf, int off) {
        return (buf[off] & 0x3F) << 2 | (buf[off + 1] & 0x30) >>> 4;
    }

    private final int get2(byte[] buf, int off) {
        return (buf[off + 1] & 0xF) << 4 | (buf[off + 2] & 0x3C) >>> 2;
    }

    private final int get3(byte[] buf, int off) {
        return (buf[off + 2] & 3) << 6 | buf[off + 3] & 0x3F;
    }

    public Document getDocument() {
        return this.doc;
    }
}

