/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure.ds;

import com.google.common.base.Preconditions;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.SqlgPlugin;
import org.umlg.sqlg.sql.dialect.SqlDialect;
import org.umlg.sqlg.structure.SqlgDataSource;

public final class SqlgHikariDataSource
implements SqlgDataSource {
    private static final Logger logger = LoggerFactory.getLogger(SqlgHikariDataSource.class);
    private final HikariConfig config = new HikariConfig();
    private HikariDataSource dss;
    private final String jdbcUrl;
    private final SqlDialect sqlDialect;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public static SqlgHikariDataSource create(Configuration configuration) {
        Preconditions.checkState((boolean)configuration.containsKey("jdbc.url"));
        Preconditions.checkState((boolean)configuration.containsKey("jdbc.username"));
        Preconditions.checkState((boolean)configuration.containsKey("jdbc.password"));
        String jdbcUrl = configuration.getString("jdbc.url");
        SqlgPlugin sqlgPlugin = SqlgPlugin.load((String)jdbcUrl);
        jdbcUrl = sqlgPlugin.manageJdbcUrl(jdbcUrl);
        SqlDialect sqlDialect = sqlgPlugin.instantiateDialect();
        String driver = sqlgPlugin.getDriverFor(jdbcUrl);
        String username = configuration.getString("jdbc.username");
        String password = configuration.getString("jdbc.password");
        Properties props = new Properties();
        if (!StringUtils.isEmpty((CharSequence)username)) {
            props.setProperty("dataSource.user", username);
        }
        if (!StringUtils.isEmpty((CharSequence)password)) {
            props.setProperty("dataSource.password", password);
        }
        Iterator keyIterator = configuration.getKeys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            if (!key.startsWith("dataSource")) continue;
            props.setProperty(key.substring("dataSource.".length()), configuration.getProperty(key).toString());
        }
        HikariConfig config = new HikariConfig(props);
        config.setJdbcUrl(jdbcUrl);
        config.setDriverClassName(driver);
        HikariDataSource hikariDataSource = new HikariDataSource(config);
        return new SqlgHikariDataSource(jdbcUrl, hikariDataSource, sqlDialect);
    }

    private SqlgHikariDataSource(String jdbcUrl, HikariDataSource dss, SqlDialect sqlDialect) {
        this.dss = dss;
        this.jdbcUrl = jdbcUrl;
        this.sqlDialect = sqlDialect;
    }

    public DataSource getDatasource() {
        return this.dss;
    }

    public SqlDialect getDialect() {
        return this.sqlDialect;
    }

    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        try {
            int numBusyConnections = this.dss.getHikariPoolMXBean().getActiveConnections();
            if (numBusyConnections > 0) {
                logger.debug("Open connection on calling close. " + numBusyConnections);
            }
        }
        finally {
            this.dss.close();
            this.dss = null;
        }
    }

    public String getPoolStatsAsJson() {
        try {
            return "[{\"jdbcUrl\":\"" + this.jdbcUrl + "\",\"jndi\": false,\"numMaxPoolSize\":\"" + this.dss.getMaximumPoolSize() + "\",}]";
        }
        catch (Exception e) {
            throw new IllegalStateException("Json generation failed", e);
        }
    }

    public boolean isHikari() {
        return true;
    }
}

