/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.ocl;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.uml.ExpressionInOCL;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Type;
import org.umlg.framework.ModelLoadedEvent;
import org.umlg.framework.ModelLoader;
import org.umlg.ocl.UmlgChoice;

public class UmlgOcl2Parser
implements ModelLoadedEvent {
    private final Logger logger = Logger.getLogger(UmlgOcl2Parser.class.getPackage().getName());
    private OCL<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> ocl;
    private Environment<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> environment;
    private OCLHelper<Classifier, Operation, Property, Constraint> helper;
    public static final UmlgOcl2Parser INSTANCE = new UmlgOcl2Parser();

    public Model init(URI modelFile) {
        Model model = ModelLoader.INSTANCE.loadModel(modelFile);
        ModelLoader.INSTANCE.subscribeModelLoaderEvent((ModelLoadedEvent)this);
        org.eclipse.ocl.uml.OCL.initialize((ResourceSet)ModelLoader.INSTANCE.getRESOURCE_SET());
        this.ocl = org.eclipse.ocl.uml.OCL.newInstance((ResourceSet)ModelLoader.INSTANCE.getRESOURCE_SET());
        this.environment = this.ocl.getEnvironment();
        this.helper = this.ocl.createOCLHelper();
        return model;
    }

    public Model init(String modelFileName) {
        URI modelFileURI;
        URL modelFileURL = Thread.currentThread().getContextClassLoader().getResource(modelFileName);
        if (modelFileURL == null) {
            throw new IllegalStateException(String.format("Model file %s not found. The model's file name must be on the classpath.", modelFileName));
        }
        try {
            modelFileURI = modelFileURL.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this.init(modelFileURI);
    }

    private UmlgOcl2Parser() {
    }

    public OCLHelper<Classifier, Operation, Property, Constraint> getHelper() {
        return this.helper;
    }

    public List<Choice> getCodeInsights(ConstraintKind invariant, String query) {
        List insights = INSTANCE.getHelper().getSyntaxHelp(ConstraintKind.INVARIANT, query);
        INSTANCE.addAssociationMemberEnds(insights);
        return insights;
    }

    private void addAssociationMemberEnds(List<Choice> choices) {
        HashSet<Type> contextElements = new HashSet<Type>();
        ArrayList<UmlgChoice> ownedMemberEnds = new ArrayList<UmlgChoice>();
        for (Choice choice : choices) {
            Element context;
            if (!(choice.getElement() instanceof Element) || !((context = ((Element)choice.getElement()).getOwner()) instanceof Type)) continue;
            contextElements.add((Type)context);
        }
        for (Type context : contextElements) {
            EList associations = context.getAssociations();
            for (Association association : associations) {
                for (Property ownedMemberEnd : association.getOwnedEnds()) {
                    if (ownedMemberEnd.getType().equals(context)) continue;
                    ownedMemberEnds.add(new UmlgChoice(ChoiceKind.PROPERTY, ownedMemberEnd.getName(), ownedMemberEnd.getType().getName(), ownedMemberEnd));
                }
            }
        }
        choices.addAll(ownedMemberEnds);
        Collections.sort(choices, new Comparator<Choice>(){

            @Override
            public int compare(Choice o1, Choice o2) {
                return o1.getKind().compareTo((Enum)o2.getKind());
            }
        });
    }

    public static void main(String[] args) {
        Model model = ModelLoader.INSTANCE.loadModel(new File("/home/pieter/Downloads/umlg/test/umlg-test-ocl/src/main/model/test-ocl.uml").toURI());
        UmlgOcl2Parser parser = new UmlgOcl2Parser();
        StringBuilder sb = new StringBuilder();
        sb.append("package testoclmodel::org::umlg::testocl\n");
        sb.append("context OclTest1::derivedProperty1 : String\n");
        sb.append("derive :\n");
        sb.append("self.property1\n");
        sb.append("endpackage\n");
        OCLExpression expr = parser.parseOcl(sb.toString());
        System.out.println("Success 1 " + expr);
        sb = new StringBuilder();
        sb.append("package testoclmodel::org::umlg::testocl\n");
        sb.append("context OclTest1\n");
        sb.append("inv testInv : property1 = 'halo'\n");
        sb.append("endpackage\n");
        expr = parser.parseOcl(sb.toString());
        System.out.println("Success 2 " + expr);
        sb = new StringBuilder();
        sb.append("package testoclmodel::org::umlg::testocl\n");
        sb.append("context OclTest1\n");
        sb.append("inv testInv : (property1 = 'halo1') and (property1 = 'halo2') and (property1 = 'halo3')\n");
        sb.append("endpackage\n");
        expr = parser.parseOcl(sb.toString());
        System.out.println("Success 3 " + expr);
        NamedElement c = ModelLoader.INSTANCE.findNamedElement("testoclmodel::org::umlg::qualifier::Bank");
        parser.helper.setContext((Object)((Classifier)c));
        try {
            expr = parser.helper.createQuery("employee");
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
        System.out.println("wow");
    }

    public OCLExpression<Classifier> parseOcl(String oclText, boolean validate) {
        if (validate) {
            return this.parseConstraint(oclText);
        }
        return this.parseConstraintUnvalidated(oclText);
    }

    public OCLExpression<Classifier> parseOcl(String oclText) {
        return this.parseConstraint(oclText);
    }

    private OCLExpression<Classifier> parseConstraint(String text) {
        OCLExpression<Classifier> result = this.parseConstraintUnvalidated(text);
        this.validate(result);
        return result;
    }

    private OCLExpression<Classifier> parseConstraintUnvalidated(String text) {
        Constraint constraint;
        try {
            List constraints = this.ocl.parse(new OCLInput(text));
            constraint = (Constraint)constraints.get(0);
        }
        catch (ParserException e) {
            this.logger.severe(String.format("Error parsing ocl: %s", text));
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        OCLExpression<Classifier> result = this.getBodyExpression(constraint);
        return result;
    }

    private void validate(Constraint constraint) {
        try {
            this.ocl.validate((Object)constraint);
        }
        catch (SemanticException e) {
            throw new RuntimeException(e);
        }
    }

    private void validate(OCLExpression<Classifier> expr) {
        try {
            EObject eContainer = expr.eContainer();
            if (eContainer != null && Constraint.class.isAssignableFrom(eContainer.eContainer().getClass())) {
                Constraint eContainerContainer = (Constraint)eContainer.eContainer();
                this.validate(eContainerContainer);
            } else {
                this.ocl.validate(expr);
            }
        }
        catch (SemanticException e) {
            throw new RuntimeException(e);
        }
    }

    private OCLExpression<Classifier> getBodyExpression(Constraint constraint) {
        return ((ExpressionInOCL)constraint.getSpecification()).getBodyExpression();
    }

    public void loaded(Model model) {
        org.eclipse.ocl.uml.OCL.initialize((ResourceSet)ModelLoader.INSTANCE.getRESOURCE_SET());
        this.ocl = org.eclipse.ocl.uml.OCL.newInstance((ResourceSet)ModelLoader.INSTANCE.getRESOURCE_SET());
        this.environment = this.ocl.getEnvironment();
        this.helper = this.ocl.createOCLHelper();
    }
}

