/*
 * Decompiled with CFR 0.152.
 */
package org.ufoss.kotysa.vertx;

import io.vertx.core.buffer.Buffer;
import io.vertx.sqlclient.data.Numeric;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.ConvertersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ufoss.kotysa.Row;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J/\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/ufoss/kotysa/vertx/VertxRow;", "Lorg/ufoss/kotysa/Row;", "vertxRow", "Lio/vertx/sqlclient/Row;", "(Lio/vertx/sqlclient/Row;)V", "get", "T", "", "index", "", "clazz", "Ljava/lang/Class;", "(ILjava/lang/Class;)Ljava/lang/Object;", "kotysa-vertx-sqlclient"})
public final class VertxRow
implements Row {
    @NotNull
    private final io.vertx.sqlclient.Row vertxRow;

    public VertxRow(@NotNull io.vertx.sqlclient.Row vertxRow) {
        Intrinsics.checkNotNullParameter((Object)vertxRow, (String)"vertxRow");
        this.vertxRow = vertxRow;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public <T> T get(int index, @NotNull Class<T> clazz) {
        Object object;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String string = clazz.getName();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -1405464277: {
                    if (!string.equals("java.math.BigDecimal")) break;
                    n = 1;
                    break;
                }
                case -61177187: {
                    if (!string.equals("kotlinx.datetime.LocalDate")) break;
                    n = 2;
                    break;
                }
                case 2887: {
                    if (!string.equals("[B")) break;
                    n = 3;
                    break;
                }
                case -1246033885: {
                    if (!string.equals("java.time.LocalTime")) break;
                    n = 4;
                    break;
                }
                case 344809556: {
                    if (!string.equals("java.lang.Boolean")) break;
                    n = 5;
                    break;
                }
                case -60693060: {
                    if (!string.equals("kotlinx.datetime.LocalTime")) break;
                    n = 6;
                    break;
                }
                case 1880470282: {
                    if (!string.equals("kotlinx.datetime.LocalDateTime")) break;
                    n = 7;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    LocalDate localDate = this.vertxRow.getLocalDate(index);
                    if (localDate != null) {
                        object = ConvertersKt.toKotlinLocalDate((LocalDate)localDate);
                        return (T)object;
                    }
                    object = null;
                    return (T)object;
                }
                case 7: {
                    LocalDateTime localDateTime = this.vertxRow.getLocalDateTime(index);
                    if (localDateTime != null) {
                        object = ConvertersKt.toKotlinLocalDateTime((LocalDateTime)localDateTime);
                        return (T)object;
                    }
                    object = null;
                    return (T)object;
                }
                case 6: {
                    LocalTime localTime = this.vertxRow.getLocalTime(index);
                    if (localTime != null) {
                        object = ConvertersKt.toKotlinLocalTime((LocalTime)localTime);
                        return (T)object;
                    }
                    object = null;
                    return (T)object;
                }
                case 3: {
                    Buffer buffer = this.vertxRow.getBuffer(index);
                    if (buffer != null) {
                        object = buffer.getBytes();
                        return (T)object;
                    }
                    object = null;
                    return (T)object;
                }
                case 1: {
                    BigDecimal bigDecimal;
                    try {
                        Numeric numeric = this.vertxRow.getNumeric(index);
                        bigDecimal = numeric != null ? numeric.bigDecimalValue() : null;
                    }
                    catch (UnsupportedOperationException uoe) {
                        bigDecimal = this.vertxRow.getBigDecimal(index);
                    }
                    object = bigDecimal;
                    return (T)object;
                }
                case 5: {
                    Boolean bl;
                    try {
                        bl = this.vertxRow.getBoolean(index);
                    }
                    catch (ClassCastException cce) {
                        Integer n2 = this.vertxRow.getInteger(index);
                        bl = n2 == null || n2 != 0;
                    }
                    object = bl;
                    return (T)object;
                }
                case 4: {
                    object = this.vertxRow.getLocalTime(index);
                    return (T)object;
                }
            }
        }
        object = this.vertxRow.get(clazz, index);
        return (T)object;
    }
}

