/*
 * Decompiled with CFR 0.152.
 */
package org.ufoss.kotysa.jdbc.transaction;

import java.sql.Connection;
import java.sql.Savepoint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.ufoss.kotysa.core.jdbc.transaction.JdbcTransaction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\r\u0010\u0019\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001aJ\b\u0010\u001b\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/ufoss/kotysa/jdbc/transaction/JdbcTransactionImpl;", "Lorg/ufoss/kotysa/core/jdbc/transaction/JdbcTransaction;", "connection", "Ljava/sql/Connection;", "(Ljava/sql/Connection;)V", "completed", "", "getConnection$kotysa_jdbc", "()Ljava/sql/Connection;", "value", "readOnly", "getReadOnly", "()Z", "setReadOnly", "(Z)V", "rollbackOnly", "createSavepoint", "Ljava/sql/Savepoint;", "isCompleted", "isNewTransaction", "isRollbackOnly", "releaseSavepoint", "", "savepoint", "rollbackToSavepoint", "setCompleted", "setCompleted$kotysa_jdbc", "setRollbackOnly", "kotysa-jdbc"})
public final class JdbcTransactionImpl
implements JdbcTransaction {
    @NotNull
    private final Connection connection;
    private boolean rollbackOnly;
    private boolean completed;

    public JdbcTransactionImpl(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
    }

    @NotNull
    public final Connection getConnection$kotysa_jdbc() {
        return this.connection;
    }

    public boolean isNewTransaction() {
        return true;
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    @NotNull
    public Savepoint createSavepoint() {
        Savepoint savepoint = this.connection.setSavepoint();
        Intrinsics.checkNotNullExpressionValue((Object)savepoint, (String)"connection.setSavepoint()");
        return savepoint;
    }

    public void rollbackToSavepoint(@NotNull Savepoint savepoint) {
        Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
        this.connection.rollback(savepoint);
    }

    public void releaseSavepoint(@NotNull Savepoint savepoint) {
        Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
        this.connection.releaseSavepoint(savepoint);
    }

    public boolean getReadOnly() {
        return this.connection.isReadOnly();
    }

    public void setReadOnly(boolean value) {
        this.connection.setReadOnly(value);
    }

    public final void setCompleted$kotysa_jdbc() {
        this.completed = true;
    }
}

