/*
 * Decompiled with CFR 0.152.
 */
package org.ufoss.kotysa.jdbc.transaction;

import java.sql.Connection;
import java.sql.Savepoint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.ufoss.kotysa.transaction.Transaction;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\r\u0010\u0013\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0014J\b\u0010\u0015\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/ufoss/kotysa/jdbc/transaction/JdbcTransaction;", "Lorg/ufoss/kotysa/transaction/Transaction;", "connection", "Ljava/sql/Connection;", "(Ljava/sql/Connection;)V", "completed", "", "getConnection$kotysa_jdbc", "()Ljava/sql/Connection;", "rollbackOnly", "createSavepoint", "Ljava/sql/Savepoint;", "isCompleted", "isNewTransaction", "isRollbackOnly", "releaseSavepoint", "", "savepoint", "rollbackToSavepoint", "setCompleted", "setCompleted$kotysa_jdbc", "setRollbackOnly", "kotysa-jdbc"})
public final class JdbcTransaction
implements Transaction {
    @NotNull
    private final Connection connection;
    private boolean rollbackOnly;
    private boolean completed;

    public JdbcTransaction(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
    }

    @NotNull
    public final Connection getConnection$kotysa_jdbc() {
        return this.connection;
    }

    public boolean isNewTransaction() {
        return true;
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    @NotNull
    public final Savepoint createSavepoint() {
        Savepoint savepoint = this.connection.setSavepoint();
        Intrinsics.checkNotNullExpressionValue((Object)savepoint, (String)"connection.setSavepoint()");
        return savepoint;
    }

    public final void rollbackToSavepoint(@NotNull Savepoint savepoint) {
        Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
        this.connection.rollback(savepoint);
    }

    public final void releaseSavepoint(@NotNull Savepoint savepoint) {
        Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
        this.connection.releaseSavepoint(savepoint);
    }

    public final void setCompleted$kotysa_jdbc() {
        this.completed = true;
    }
}

